/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonElement;
import java.util.EnumSet;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.Deserializer;
import net.sf.uadetector.json.internal.data.hashcodebuilder.HashCodeGenerator;
import net.sf.uadetector.json.internal.data.util.AbstractMessageCollector;

abstract class AbstractDeserializer<T>
extends AbstractMessageCollector<T>
implements Deserializer {
    private final EnumSet<SerDeOption> options;

    public AbstractDeserializer(EnumSet<SerDeOption> options) {
        this.options = options;
    }

    public final void checkHash(JsonElement json, String hash, T element) {
        String newHash;
        if (this.getOptions().contains((Object)SerDeOption.HASH_VALIDATING) && !hash.equals(newHash = HashCodeGenerator.generate(element))) {
            String warning = String.format("The computed hash code (%s) differs from the original (%s): %s", hash, newHash, json);
            this.addWarning(warning);
        }
    }

    @Override
    public final EnumSet<SerDeOption> getOptions() {
        return this.options;
    }
}

