/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.BrowserPatternDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.BrowserTypeDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.OperatingSystemDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableBrowserField;

public final class BrowserDeserializer
extends AbstractDeserializer<Browser>
implements JsonDeserializer<Browser> {
    private final BrowserPatternDeserializer browserPatternDeserializer;
    private final BrowserTypeDeserializer browserTypeDeserializer;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final OperatingSystemDeserializer operatingSystemDeserializer;

    public BrowserDeserializer(EnumSet<SerDeOption> options, BrowserPatternDeserializer browserPatternDeserializer, BrowserTypeDeserializer browserTypeDeserializer, OperatingSystemDeserializer operatingSystemDeserializer) {
        super(options);
        this.browserPatternDeserializer = (BrowserPatternDeserializer)Check.notNull((Object)browserPatternDeserializer, (String)"browserPatternDeserializer");
        this.browserTypeDeserializer = (BrowserTypeDeserializer)Check.notNull((Object)browserTypeDeserializer, (String)"browserTypeDeserializer");
        this.operatingSystemDeserializer = (OperatingSystemDeserializer)Check.notNull((Object)operatingSystemDeserializer, (String)"operatingSystemDeserializer");
    }

    public Browser deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String hash = "";
        Browser.Builder b = new Browser.Builder();
        b.setId(this.counter.incrementAndGet());
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializableBrowserField.FAMILY.getName().equals(entry.getKey())) {
                b.setFamilyName(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableBrowserField.HASH.getName().equals(entry.getKey())) {
                hash = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (SerializableBrowserField.ICON.getName().equals(entry.getKey())) {
                b.setIcon(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableBrowserField.INFO_URL.getName().equals(entry.getKey())) {
                b.setInfoUrl(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableBrowserField.OPERATING_SYSTEM_HASH.getName().equals(entry.getKey())) {
                OperatingSystem os = this.operatingSystemDeserializer.findOperatingSystem(((JsonElement)entry.getValue()).getAsString());
                if (os == null) continue;
                b.setOperatingSystem(os);
                continue;
            }
            if (SerializableBrowserField.PATTERNS.getName().equals(entry.getKey())) {
                TreeSet<BrowserPattern> patterns = new TreeSet<BrowserPattern>();
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    BrowserPattern browserPattern = this.browserPatternDeserializer.findBrowserPattern(element.getAsString());
                    if (browserPattern == null) continue;
                    patterns.add(browserPattern);
                }
                b.setPatterns(patterns);
                continue;
            }
            if (SerializableBrowserField.PRODUCER.getName().equals(entry.getKey())) {
                b.setProducer(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableBrowserField.PRODUCER_URL.getName().equals(entry.getKey())) {
                b.setProducerUrl(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableBrowserField.BROWSER_TYPE_HASH.getName().equals(entry.getKey())) {
                BrowserType type = this.browserTypeDeserializer.findBrowserType(((JsonElement)entry.getValue()).getAsString());
                if (type == null) continue;
                b.setType(type);
                continue;
            }
            if (!SerializableBrowserField.URL.getName().equals(entry.getKey())) continue;
            b.setUrl(((JsonElement)entry.getValue()).getAsString());
        }
        Browser browser = null;
        try {
            browser = b.build();
            this.checkHash(json, hash, browser);
        }
        catch (Exception e) {
            String msg = String.format("Can not create browser entry: %s", e.getLocalizedMessage());
            this.addWarning(msg);
        }
        return browser;
    }
}

