/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableOrderedPatternField;

public final class BrowserPatternDeserializer
extends AbstractDeserializer<BrowserPattern>
implements JsonDeserializer<BrowserPattern> {
    private final Map<String, BrowserPattern> browserPatterns = new HashMap<String, BrowserPattern>();
    private final AtomicInteger counter = new AtomicInteger(0);

    public BrowserPatternDeserializer(EnumSet<SerDeOption> options) {
        super(options);
    }

    public BrowserPattern deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String hash = "";
        Pattern pattern = null;
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializableOrderedPatternField.PATTERN.getName().equals(entry.getKey())) {
                pattern = (Pattern)context.deserialize((JsonElement)entry.getValue(), Pattern.class);
                continue;
            }
            if (!SerializableOrderedPatternField.HASH.getName().equals(entry.getKey())) continue;
            hash = ((JsonElement)entry.getValue()).getAsString();
        }
        int id = this.counter.incrementAndGet();
        BrowserPattern browserPattern = null;
        try {
            browserPattern = new BrowserPattern(id, pattern, id);
            this.checkHash(json, hash, browserPattern);
            this.browserPatterns.put(hash, browserPattern);
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return browserPattern;
    }

    @Nullable
    public BrowserPattern findBrowserPattern(@Nonnull String hash) {
        Check.notEmpty((CharSequence)hash, (String)"hash");
        BrowserPattern browserPattern = this.browserPatterns.get(hash);
        if (browserPattern == null) {
            this.addWarning("Can not find browser pattern for hash '" + hash + "'.");
        }
        return browserPattern;
    }
}

