/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableBrowserTypeField;

public final class BrowserTypeDeserializer
extends AbstractDeserializer<BrowserType>
implements JsonDeserializer<BrowserType> {
    private final Map<String, BrowserType> browserTypes = new HashMap<String, BrowserType>();
    private final AtomicInteger counter = new AtomicInteger(0);

    public BrowserTypeDeserializer(EnumSet<SerDeOption> options) {
        super(options);
    }

    public BrowserType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String name = null;
        String hash = "";
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializableBrowserTypeField.NAME.getName().equals(entry.getKey())) {
                name = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (!SerializableBrowserTypeField.HASH.getName().equals(entry.getKey())) continue;
            hash = ((JsonElement)entry.getValue()).getAsString();
        }
        BrowserType type = null;
        try {
            type = new BrowserType(this.counter.incrementAndGet(), name);
            this.checkHash(json, hash, type);
            this.browserTypes.put(hash, type);
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return type;
    }

    @Nullable
    public BrowserType findBrowserType(@Nonnull String hash) {
        Check.notEmpty((CharSequence)hash, (String)"hash");
        BrowserType browserType = this.browserTypes.get(hash);
        if (browserType == null) {
            this.addWarning("Can not find browser type for hash '" + hash + "'.");
        }
        return browserType;
    }
}

