/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.DataBuilder;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableDataField;

public final class DataDeserializer
extends AbstractDeserializer<Data>
implements JsonDeserializer<Data> {
    private static <T> List<T> deserializeType(JsonDeserializationContext context, Map.Entry<String, JsonElement> jsonObject, SerializableDataField field, Class<T> classOfT) {
        Check.notNull((Object)context, (String)"context");
        Check.notNull(jsonObject, (String)"jsonObject");
        Check.notNull((Object)((Object)field), (String)"field");
        Check.notNull(classOfT, (String)"classOfT");
        ArrayList<Object> result = new ArrayList<Object>();
        if (field.getName().equals(jsonObject.getKey())) {
            JsonArray browsers = jsonObject.getValue().getAsJsonArray();
            for (JsonElement element : browsers) {
                Object entry = context.deserialize(element, classOfT);
                if (entry == null) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public DataDeserializer(EnumSet<SerDeOption> options) {
        super(options);
    }

    public Data deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject obj = json.getAsJsonObject();
        Set entrySet = obj.entrySet();
        DataBuilder builder = new DataBuilder();
        for (Map.Entry entry : entrySet) {
            List<BrowserPattern> browserPatterns = DataDeserializer.deserializeType(context, entry, SerializableDataField.BROWSERPATTERNS, BrowserPattern.class);
            for (BrowserPattern browserPattern : browserPatterns) {
                builder.appendBrowserPattern(browserPattern);
            }
            List<BrowserType> browserTypes = DataDeserializer.deserializeType(context, entry, SerializableDataField.BROWSERTYPES, BrowserType.class);
            for (BrowserType browserType : browserTypes) {
                builder.appendBrowserType(browserType);
            }
            List<Browser> browsers = DataDeserializer.deserializeType(context, entry, SerializableDataField.BROWSERS, Browser.class);
            for (Browser browser : browsers) {
                builder.appendBrowser(browser);
            }
            List<OperatingSystemPattern> operatingSystemPatterns = DataDeserializer.deserializeType(context, entry, SerializableDataField.OPERATINGSYSTEMPATTERNS, OperatingSystemPattern.class);
            for (OperatingSystemPattern operatingSystemPattern : operatingSystemPatterns) {
                builder.appendOperatingSystemPattern(operatingSystemPattern);
            }
            List<OperatingSystem> operatingSystems = DataDeserializer.deserializeType(context, entry, SerializableDataField.OPERATINGSYSTEMS, OperatingSystem.class);
            for (OperatingSystem operatingSystem : operatingSystems) {
                builder.appendOperatingSystem(operatingSystem);
            }
            List<Robot> robots = DataDeserializer.deserializeType(context, entry, SerializableDataField.ROBOTS, Robot.class);
            for (Robot robot : robots) {
                builder.appendRobot(robot);
            }
            if (!SerializableDataField.VERSION.getName().equals(entry.getKey())) continue;
            builder.setVersion(((JsonElement)entry.getValue()).getAsString());
        }
        Data data = Data.EMPTY;
        try {
            data = builder.build();
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return data;
    }
}

