/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.BrowserDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.BrowserPatternDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.BrowserTypeDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.DataDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.Deserialization;
import net.sf.uadetector.json.internal.data.deserializer.OperatingSystemDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.OperatingSystemPatternDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.PatternDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.RobotDeserializer;

@Immutable
public final class Deserializers
extends AbstractDeserializer<Data> {
    private final BrowserDeserializer browserDeserializer;
    private final BrowserPatternDeserializer browserPatternDeserializer;
    private final BrowserTypeDeserializer browserTypeDeserializer;
    private final DataDeserializer dataDeserializer;
    private final Gson gson;
    private final OperatingSystemDeserializer operatingSystemDeserializer;
    private final OperatingSystemPatternDeserializer operatingSystemPatternDeserializer;
    private final PatternDeserializer patternDeserializer;
    private final RobotDeserializer robotDeserializer;

    public static Deserialization<Data> deserialize(String json, EnumSet<SerDeOption> options) {
        return Deserializers.deserialize(json, options, Data.class);
    }

    public static <T> Deserialization<T> deserialize(String json, EnumSet<SerDeOption> options, Class<T> classOfT) {
        Deserializers deserializers = new Deserializers(options);
        return new Deserialization<T>(deserializers.deserialize(json, classOfT), deserializers.getWarnings());
    }

    private Deserializers(EnumSet<SerDeOption> options) {
        super((EnumSet)Check.notNull(options));
        this.dataDeserializer = new DataDeserializer(options);
        this.browserPatternDeserializer = new BrowserPatternDeserializer(options);
        this.browserTypeDeserializer = new BrowserTypeDeserializer(options);
        this.operatingSystemPatternDeserializer = new OperatingSystemPatternDeserializer(options);
        this.operatingSystemDeserializer = new OperatingSystemDeserializer(options, this.operatingSystemPatternDeserializer);
        this.browserDeserializer = new BrowserDeserializer(options, this.browserPatternDeserializer, this.browserTypeDeserializer, this.operatingSystemDeserializer);
        this.robotDeserializer = new RobotDeserializer(options);
        this.patternDeserializer = new PatternDeserializer(options);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Data.class, (Object)this.dataDeserializer);
        gsonBuilder.registerTypeAdapter(Browser.class, (Object)this.browserDeserializer);
        gsonBuilder.registerTypeAdapter(BrowserPattern.class, (Object)this.browserPatternDeserializer);
        gsonBuilder.registerTypeAdapter(BrowserType.class, (Object)this.browserTypeDeserializer);
        gsonBuilder.registerTypeAdapter(OperatingSystem.class, (Object)this.operatingSystemDeserializer);
        gsonBuilder.registerTypeAdapter(OperatingSystemPattern.class, (Object)this.operatingSystemPatternDeserializer);
        gsonBuilder.registerTypeAdapter(Robot.class, (Object)this.robotDeserializer);
        gsonBuilder.registerTypeAdapter(Pattern.class, (Object)this.patternDeserializer);
        this.gson = gsonBuilder.create();
    }

    public <T> T deserialize(String json, Class<T> classOfT) {
        Check.notNull((Object)json);
        Check.notNull(classOfT);
        return (T)this.gson.fromJson(json, classOfT);
    }

    public BrowserDeserializer getBrowserDeserializer() {
        return this.browserDeserializer;
    }

    public BrowserPatternDeserializer getBrowserPatternDeserializer() {
        return this.browserPatternDeserializer;
    }

    public BrowserTypeDeserializer getBrowserTypeDeserializer() {
        return this.browserTypeDeserializer;
    }

    public DataDeserializer getDataDeserializer() {
        return this.dataDeserializer;
    }

    public OperatingSystemDeserializer getOperatingSystemDeserializer() {
        return this.operatingSystemDeserializer;
    }

    public OperatingSystemPatternDeserializer getOperatingSystemPatternDeserializer() {
        return this.operatingSystemPatternDeserializer;
    }

    public PatternDeserializer getPatternDeserializer() {
        return this.patternDeserializer;
    }

    public RobotDeserializer getRobotDeserializer() {
        return this.robotDeserializer;
    }

    @Override
    public List<String> getWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        warnings.addAll(this.patternDeserializer.getWarnings());
        warnings.addAll(this.operatingSystemPatternDeserializer.getWarnings());
        warnings.addAll(this.operatingSystemDeserializer.getWarnings());
        warnings.addAll(this.browserTypeDeserializer.getWarnings());
        warnings.addAll(this.browserPatternDeserializer.getWarnings());
        warnings.addAll(this.browserDeserializer.getWarnings());
        warnings.addAll(this.robotDeserializer.getWarnings());
        warnings.addAll(this.dataDeserializer.getWarnings());
        return Collections.unmodifiableList(warnings);
    }
}

