/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.deserializer.OperatingSystemPatternDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableOperatingSystemField;

public final class OperatingSystemDeserializer
extends AbstractDeserializer<OperatingSystem>
implements JsonDeserializer<OperatingSystem> {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final OperatingSystemPatternDeserializer operatingSystemPatternDeserializer;
    private final Map<String, OperatingSystem> operatingSystems = new HashMap<String, OperatingSystem>();

    public OperatingSystemDeserializer(EnumSet<SerDeOption> options, OperatingSystemPatternDeserializer operatingSystemPatternDeserializer) {
        super(options);
        this.operatingSystemPatternDeserializer = (OperatingSystemPatternDeserializer)Check.notNull((Object)operatingSystemPatternDeserializer, (String)"operatingSystemPatternDeserializer");
    }

    public OperatingSystem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String hash = "";
        OperatingSystem.Builder b = new OperatingSystem.Builder();
        b.setId(this.counter.incrementAndGet());
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializableOperatingSystemField.FAMILY.getName().equals(entry.getKey())) {
                b.setFamily(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableOperatingSystemField.HASH.getName().equals(entry.getKey())) {
                hash = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (SerializableOperatingSystemField.ICON.getName().equals(entry.getKey())) {
                b.setIcon(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableOperatingSystemField.INFO_URL.getName().equals(entry.getKey())) {
                b.setInfoUrl(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableOperatingSystemField.NAME.getName().equals(entry.getKey())) {
                b.setName(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableOperatingSystemField.PATTERN_HASHS.getName().equals(entry.getKey())) {
                HashSet<OperatingSystemPattern> patternSet = new HashSet<OperatingSystemPattern>();
                for (JsonElement patternHash : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    OperatingSystemPattern osPattern = this.operatingSystemPatternDeserializer.findOperatingSystemPattern(patternHash.getAsString());
                    if (osPattern == null) continue;
                    patternSet.add(osPattern);
                }
                b.addPatterns(patternSet);
                continue;
            }
            if (SerializableOperatingSystemField.PRODUCER.getName().equals(entry.getKey())) {
                b.setProducer(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableOperatingSystemField.PRODUCER_URL.getName().equals(entry.getKey())) {
                b.setProducerUrl(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (!SerializableOperatingSystemField.URL.getName().equals(entry.getKey())) continue;
            b.setUrl(((JsonElement)entry.getValue()).getAsString());
        }
        OperatingSystem os = null;
        try {
            os = b.build();
            this.checkHash(json, hash, os);
            this.operatingSystems.put(hash, os);
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return os;
    }

    @Nullable
    public OperatingSystem findOperatingSystem(@Nonnull String hash) {
        Check.notEmpty((CharSequence)hash, (String)"hash");
        OperatingSystem os = this.operatingSystems.get(hash);
        if (os == null) {
            this.addWarning("Can not find operating system for hash '" + hash + "'.");
        }
        return os;
    }
}

