/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableOrderedPatternField;

public final class OperatingSystemPatternDeserializer
extends AbstractDeserializer<OperatingSystemPattern>
implements JsonDeserializer<OperatingSystemPattern> {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<String, OperatingSystemPattern> operatingSystemPatterns = new HashMap<String, OperatingSystemPattern>();

    public OperatingSystemPatternDeserializer(EnumSet<SerDeOption> options) {
        super(options);
    }

    public OperatingSystemPattern deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String hash = "";
        Pattern pattern = null;
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializableOrderedPatternField.PATTERN.getName().equals(entry.getKey())) {
                pattern = (Pattern)context.deserialize((JsonElement)entry.getValue(), Pattern.class);
                continue;
            }
            if (!SerializableOrderedPatternField.HASH.getName().equals(entry.getKey())) continue;
            hash = ((JsonElement)entry.getValue()).getAsString();
        }
        int id = this.counter.incrementAndGet();
        OperatingSystemPattern osPattern = new OperatingSystemPattern(id, pattern, id);
        try {
            osPattern = new OperatingSystemPattern(id, pattern, id);
            this.checkHash(json, hash, osPattern);
            this.operatingSystemPatterns.put(hash, osPattern);
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return osPattern;
    }

    @Nullable
    public OperatingSystemPattern findOperatingSystemPattern(@Nonnull String hash) {
        Check.notEmpty((CharSequence)hash, (String)"hash");
        OperatingSystemPattern pattern = this.operatingSystemPatterns.get(hash);
        if (pattern == null) {
            this.addWarning("Can not find operating system pattern for hash '" + hash + "'.");
        }
        return pattern;
    }
}

