/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.uadetector.internal.util.RegularExpressionConverter;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializablePatternField;

public final class PatternDeserializer
extends AbstractDeserializer<Pattern>
implements JsonDeserializer<Pattern> {
    public PatternDeserializer(EnumSet<SerDeOption> options) {
        super(options);
    }

    private void checkPattern(String pattern, JsonElement json) {
        if (pattern.isEmpty()) {
            this.addWarning("The parsed regular expression pattern is empty: " + json);
        }
    }

    public Pattern deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String flags = "";
        String expression = "";
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializablePatternField.FLAGS.getName().equals(entry.getKey())) {
                flags = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (!SerializablePatternField.PATTERN.getName().equals(entry.getKey())) continue;
            expression = ((JsonElement)entry.getValue()).getAsString();
        }
        this.checkPattern(expression, json);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(expression, RegularExpressionConverter.Flag.convertToBitmask((Collection)RegularExpressionConverter.Flag.parse((String)flags)));
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return pattern;
    }
}

