/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.deserializer.AbstractDeserializer;
import net.sf.uadetector.json.internal.data.field.SerializableRobotField;

public final class RobotDeserializer
extends AbstractDeserializer<Robot>
implements JsonDeserializer<Robot> {
    private final AtomicInteger counter = new AtomicInteger(0);

    public RobotDeserializer(EnumSet<SerDeOption> options) {
        super(options);
    }

    public Robot deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        String hash = "";
        Robot.Builder b = new Robot.Builder();
        b.setId(this.counter.incrementAndGet());
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            if (SerializableRobotField.FAMILY_NAME.getName().equals(entry.getKey())) {
                b.setFamilyName(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableRobotField.HASH.getName().equals(entry.getKey())) {
                hash = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (SerializableRobotField.ICON.getName().equals(entry.getKey())) {
                b.setIcon(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableRobotField.INFO_URL.getName().equals(entry.getKey())) {
                b.setInfoUrl(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableRobotField.NAME.getName().equals(entry.getKey())) {
                b.setName(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableRobotField.PRODUCER.getName().equals(entry.getKey())) {
                b.setProducer(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (SerializableRobotField.PRODUCER_URL.getName().equals(entry.getKey())) {
                b.setProducerUrl(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (!SerializableRobotField.USER_AGENT_STRING.getName().equals(entry.getKey())) continue;
            b.setUserAgentString(((JsonElement)entry.getValue()).getAsString());
        }
        Robot robot = null;
        try {
            robot = b.build();
            this.checkHash(json, hash, robot);
        }
        catch (Exception e) {
            this.addWarning(e.getLocalizedMessage());
        }
        return robot;
    }
}

