/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.hashcodebuilder;

import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.json.internal.data.hashcodebuilder.OperatingSystemHashCodeBuilder;
import net.sf.uadetector.json.internal.data.hashcodebuilder.OrderedPatternHashCodeBuilder;
import net.sf.uadetector.json.internal.data.hashcodebuilder.Sha256CodeBuilder;

final class BrowserHashCodeBuilder {
    public static String build(Browser browser) {
        StringBuilder builder = new StringBuilder();
        builder.append(browser.getFamilyName());
        builder.append(browser.getIcon());
        builder.append(browser.getInfoUrl());
        if (browser.getOperatingSystem() != null) {
            builder.append(OperatingSystemHashCodeBuilder.build(browser.getOperatingSystem()));
        }
        for (BrowserPattern pattern : browser.getPatterns()) {
            builder.append(OrderedPatternHashCodeBuilder.build(pattern));
        }
        builder.append(browser.getProducer());
        builder.append(browser.getProducerUrl());
        builder.append(browser.getUrl());
        return Sha256CodeBuilder.asHexString(builder.toString());
    }

    private BrowserHashCodeBuilder() {
    }
}

