/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.hashcodebuilder;

import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.json.internal.data.hashcodebuilder.OrderedPatternHashCodeBuilder;
import net.sf.uadetector.json.internal.data.hashcodebuilder.Sha256CodeBuilder;

final class OperatingSystemHashCodeBuilder {
    public static String build(OperatingSystem os) {
        StringBuilder builder = new StringBuilder();
        builder.append(os.getFamily());
        builder.append(os.getIcon());
        builder.append(os.getInfoUrl());
        builder.append(os.getName());
        for (OperatingSystemPattern pattern : os.getPatterns()) {
            builder.append(OrderedPatternHashCodeBuilder.build(pattern));
        }
        builder.append(os.getProducer());
        builder.append(os.getProducerUrl());
        builder.append(os.getUrl());
        return Sha256CodeBuilder.asHexString(builder.toString());
    }

    private OperatingSystemHashCodeBuilder() {
    }
}

