/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.hashcodebuilder;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;

final class Sha256CodeBuilder {
    private static final String ALGORITHM = "SHA-256";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final int HASH_CODE_LENGTH = 64;
    private static final int MAX_BYTE = 255;
    private static final String MSG_NO_SUCH_ALGORITHM = "The cryptographic algorithm '%s' is not available in this environment.";

    @Nonnull
    public static String asHexString(String content) {
        byte[] byteData;
        Check.notNull((Object)content, (String)"content");
        MessageDigest md = Sha256CodeBuilder.getMessageDigest(ALGORITHM);
        StringBuffer hexString = new StringBuffer(64);
        md.update(content.getBytes(CHARSET));
        for (byte element : byteData = md.digest()) {
            String hex = Integer.toHexString(0xFF & element);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Nonnull
    static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(String.format(MSG_NO_SUCH_ALGORITHM, ALGORITHM), e);
        }
    }

    private Sha256CodeBuilder() {
    }
}

