/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.json.internal.data.field.SerializableBrowserField;
import net.sf.uadetector.json.internal.data.hashcodebuilder.HashCodeGenerator;

public final class BrowserSerializer
implements JsonSerializer<Browser> {
    static List<String> createHashCodeList(SortedSet<BrowserPattern> patterns) {
        ArrayList<String> hashs = new ArrayList<String>(patterns.size());
        for (BrowserPattern pattern : patterns) {
            hashs.add(HashCodeGenerator.generate(pattern));
        }
        return hashs;
    }

    public JsonElement serialize(Browser browser, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty(SerializableBrowserField.FAMILY.getName(), browser.getFamilyName());
        jsonObj.addProperty(SerializableBrowserField.ICON.getName(), browser.getIcon());
        jsonObj.addProperty(SerializableBrowserField.INFO_URL.getName(), browser.getInfoUrl());
        if (browser.getOperatingSystem() != null) {
            jsonObj.addProperty(SerializableBrowserField.OPERATING_SYSTEM_HASH.getName(), HashCodeGenerator.generate(browser.getOperatingSystem()));
        }
        jsonObj.add(SerializableBrowserField.PATTERNS.getName(), context.serialize(BrowserSerializer.createHashCodeList(browser.getPatterns())));
        jsonObj.addProperty(SerializableBrowserField.PRODUCER.getName(), browser.getProducer());
        jsonObj.addProperty(SerializableBrowserField.PRODUCER_URL.getName(), browser.getProducerUrl());
        jsonObj.addProperty(SerializableBrowserField.BROWSER_TYPE_HASH.getName(), HashCodeGenerator.generate(browser.getType()));
        jsonObj.addProperty(SerializableBrowserField.URL.getName(), browser.getUrl());
        jsonObj.addProperty(SerializableBrowserField.HASH.getName(), HashCodeGenerator.generate(browser));
        return jsonObj;
    }
}

