/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.IdentifiableComparator;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.json.internal.data.comparator.OrderedPatternPositionComparator;
import net.sf.uadetector.json.internal.data.field.SerializableDataField;
import net.sf.uadetector.json.internal.data.serializer.DataJsonFormat;

public final class DataSerializer
implements JsonSerializer<Data> {
    private static Set<BrowserType> findAllBrowserTypes(Set<Browser> browsers) {
        HashSet<BrowserType> types = new HashSet<BrowserType>(browsers.size());
        for (Browser browser : browsers) {
            types.add(browser.getType());
        }
        return types;
    }

    public JsonElement serialize(Data data, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.add(DataJsonFormat.VERSION_1_0.getKey(), context.serialize((Object)DataJsonFormat.VERSION_1_0.getVersion()));
        jsonObj.add(SerializableDataField.VERSION.getName(), context.serialize((Object)data.getVersion()));
        ArrayList osPatterns = new ArrayList(data.getPatternToOperatingSystemMap().keySet());
        Collections.sort(osPatterns, new OrderedPatternPositionComparator());
        jsonObj.add(SerializableDataField.OPERATINGSYSTEMPATTERNS.getName(), context.serialize(osPatterns));
        ArrayList systems = new ArrayList(data.getOperatingSystems());
        Collections.sort(systems, IdentifiableComparator.INSTANCE);
        jsonObj.add(SerializableDataField.OPERATINGSYSTEMS.getName(), context.serialize(systems));
        ArrayList<BrowserType> browserTypes = new ArrayList<BrowserType>(DataSerializer.findAllBrowserTypes(data.getBrowsers()));
        Collections.sort(browserTypes, IdentifiableComparator.INSTANCE);
        jsonObj.add(SerializableDataField.BROWSERTYPES.getName(), context.serialize(browserTypes));
        ArrayList browserPatterns = new ArrayList(data.getPatternToBrowserMap().keySet());
        Collections.sort(browserPatterns, new OrderedPatternPositionComparator());
        jsonObj.add(SerializableDataField.BROWSERPATTERNS.getName(), context.serialize(browserPatterns));
        ArrayList browsers = new ArrayList(data.getBrowsers());
        Collections.sort(browsers, IdentifiableComparator.INSTANCE);
        jsonObj.add(SerializableDataField.BROWSERS.getName(), context.serialize(browsers));
        ArrayList robots = new ArrayList(data.getRobots());
        Collections.sort(robots, IdentifiableComparator.INSTANCE);
        jsonObj.add(SerializableDataField.ROBOTS.getName(), context.serialize(robots));
        return jsonObj;
    }
}

