/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.json.internal.data.field.SerializableOperatingSystemField;
import net.sf.uadetector.json.internal.data.hashcodebuilder.HashCodeGenerator;

public final class OperatingSystemSerializer
implements JsonSerializer<OperatingSystem> {
    private static List<String> createHashCodeList(SortedSet<OperatingSystemPattern> patterns) {
        ArrayList<String> hashs = new ArrayList<String>(patterns.size());
        for (OperatingSystemPattern pattern : patterns) {
            hashs.add(HashCodeGenerator.generate(pattern));
        }
        return hashs;
    }

    public JsonElement serialize(OperatingSystem os, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty(SerializableOperatingSystemField.FAMILY.getName(), os.getFamily());
        jsonObj.addProperty(SerializableOperatingSystemField.ICON.getName(), os.getIcon());
        jsonObj.addProperty(SerializableOperatingSystemField.INFO_URL.getName(), os.getInfoUrl());
        jsonObj.addProperty(SerializableOperatingSystemField.NAME.getName(), os.getName());
        jsonObj.add(SerializableOperatingSystemField.PATTERN_HASHS.getName(), context.serialize(OperatingSystemSerializer.createHashCodeList(os.getPatterns())));
        jsonObj.addProperty(SerializableOperatingSystemField.PRODUCER.getName(), os.getProducer());
        jsonObj.addProperty(SerializableOperatingSystemField.PRODUCER_URL.getName(), os.getProducerUrl());
        jsonObj.addProperty(SerializableOperatingSystemField.URL.getName(), os.getUrl());
        jsonObj.addProperty(SerializableOperatingSystemField.HASH.getName(), HashCodeGenerator.generate(os));
        return jsonObj;
    }
}

