/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.json.internal.data.field.SerializableRobotField;
import net.sf.uadetector.json.internal.data.hashcodebuilder.HashCodeGenerator;

public final class RobotSerializer
implements JsonSerializer<Robot> {
    public JsonElement serialize(Robot robot, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty(SerializableRobotField.FAMILY_NAME.getName(), robot.getFamilyName());
        jsonObj.addProperty(SerializableRobotField.ICON.getName(), robot.getIcon());
        jsonObj.addProperty(SerializableRobotField.INFO_URL.getName(), robot.getInfoUrl());
        jsonObj.addProperty(SerializableRobotField.NAME.getName(), robot.getName());
        jsonObj.addProperty(SerializableRobotField.PRODUCER.getName(), robot.getProducer());
        jsonObj.addProperty(SerializableRobotField.PRODUCER_URL.getName(), robot.getProducerUrl());
        jsonObj.addProperty(SerializableRobotField.USER_AGENT_STRING.getName(), robot.getUserAgentString());
        jsonObj.addProperty(SerializableRobotField.HASH.getName(), HashCodeGenerator.generate(robot));
        return jsonObj;
    }
}

