/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.json.internal.data.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.EnumSet;
import java.util.regex.Pattern;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.json.SerDeOption;
import net.sf.uadetector.json.internal.data.serializer.BrowserSerializer;
import net.sf.uadetector.json.internal.data.serializer.BrowserTypeSerializer;
import net.sf.uadetector.json.internal.data.serializer.DataSerializer;
import net.sf.uadetector.json.internal.data.serializer.OperatingSystemSerializer;
import net.sf.uadetector.json.internal.data.serializer.OrderedPatternSerializer;
import net.sf.uadetector.json.internal.data.serializer.PatternSerializer;
import net.sf.uadetector.json.internal.data.serializer.RobotSerializer;
import net.sf.uadetector.json.internal.data.serializer.Serialization;
import net.sf.uadetector.json.internal.data.util.AbstractMessageCollector;

public final class Serializers
extends AbstractMessageCollector<Data> {
    private final Gson gson;

    public static Serialization serialize(Data data, EnumSet<SerDeOption> options) {
        Serializers serializers = new Serializers(options);
        return new Serialization(serializers.serialize(data), serializers.getWarnings());
    }

    private Serializers(EnumSet<SerDeOption> options) {
        Check.notNull(options);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Data.class, (Object)new DataSerializer());
        gsonBuilder.registerTypeAdapter(Browser.class, (Object)new BrowserSerializer());
        gsonBuilder.registerTypeAdapter(BrowserPattern.class, new OrderedPatternSerializer());
        gsonBuilder.registerTypeAdapter(BrowserType.class, (Object)new BrowserTypeSerializer());
        gsonBuilder.registerTypeAdapter(OperatingSystem.class, (Object)new OperatingSystemSerializer());
        gsonBuilder.registerTypeAdapter(OperatingSystemPattern.class, new OrderedPatternSerializer());
        gsonBuilder.registerTypeAdapter(Robot.class, (Object)new RobotSerializer());
        gsonBuilder.registerTypeAdapter(Pattern.class, (Object)new PatternSerializer());
        if (options.contains((Object)SerDeOption.PRETTY_PRINTING)) {
            gsonBuilder.setPrettyPrinting();
        }
        gsonBuilder.disableInnerClassSerialization();
        this.gson = gsonBuilder.create();
    }

    public String serialize(Data data) {
        Check.notNull((Object)data);
        return this.gson.toJson((Object)data);
    }
}

