/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.config;

import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;

public class DurationToLongConverter
implements Converter<String, Long>,
ConditionalConverter {
    public Long convert(String source) {
        if (source.startsWith("P")) {
            return DOMTypeSupport.durationToLong((String)source);
        }
        if (source.startsWith("-P")) {
            throw new IllegalArgumentException("Negative durations are not supported");
        }
        return Long.valueOf(source);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.hasAnnotation(Duration.class);
    }
}

