/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.barbecuecalculator.core;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import net.sourceforge.floggy.barbecuecalculator.core.DisplayManager;
import net.sourceforge.floggy.barbecuecalculator.core.DisplayManagerException;
import net.sourceforge.floggy.barbecuecalculator.core.FlowManager;
import net.sourceforge.floggy.barbecuecalculator.core.FlowManagerNotStartedException;

public class CommandHandler
implements CommandListener {
    private static CommandHandler instance;
    public static Command CALCULATE_CMD;
    public static Command SAVED_CMD;
    public static Command SHOW_BARBECUE_CMD;
    public static Command DELETE_BARBECUE_CMD;
    public static Command ABOUT_CMD;
    public static Command SET_BARBECUE_NAME_CMD;
    public static Command SAVE_BARBECUE_CMD;
    public static Command BACK_CMD;
    public static Command EXIT_CMD;

    private CommandHandler() {
    }

    public static CommandHandler getInstance() {
        if (instance == null) {
            instance = new CommandHandler();
        }
        return instance;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == BACK_CMD) {
            try {
                DisplayManager.getInstance().backAndRemove();
            }
            catch (DisplayManagerException e1) {}
        } else if (command == EXIT_CMD) {
            try {
                FlowManager.getInstance().endApplication();
            }
            catch (FlowManagerNotStartedException e) {}
        } else if (command.equals(CALCULATE_CMD)) {
            if (displayable instanceof Canvas) {
                try {
                    FlowManager.getInstance().exibirDadosChurrasForm();
                }
                catch (FlowManagerNotStartedException e) {}
            } else {
                try {
                    FlowManager.getInstance().calculateBarbecue();
                }
                catch (FlowManagerNotStartedException e) {}
            }
        } else if (command == SET_BARBECUE_NAME_CMD) {
            try {
                FlowManager.getInstance().salvarChurrasco();
            }
            catch (FlowManagerNotStartedException e) {}
        } else if (command == SAVE_BARBECUE_CMD) {
            try {
                FlowManager.getInstance().finalizarPersistenciaChurras();
            }
            catch (FlowManagerNotStartedException e) {}
        } else if (command == SAVED_CMD) {
            try {
                FlowManager.getInstance().exibirListaChurrasSalvos();
            }
            catch (FlowManagerNotStartedException e) {}
        } else if (command == SHOW_BARBECUE_CMD) {
            try {
                FlowManager.getInstance().exibirChurrasSalvo(((List)displayable).getSelectedIndex());
            }
            catch (FlowManagerNotStartedException e) {}
        } else if (command == DELETE_BARBECUE_CMD) {
            try {
                FlowManager.getInstance().apagarChurrasSalvo(((List)displayable).getSelectedIndex());
            }
            catch (FlowManagerNotStartedException e) {}
        } else if (command == ABOUT_CMD) {
            try {
                FlowManager.getInstance().showAboutForm();
            }
            catch (FlowManagerNotStartedException flowManagerNotStartedException) {
                // empty catch block
            }
        }
    }

    static {
        CALCULATE_CMD = new Command("Calculate", 1, 1);
        SAVED_CMD = new Command("Saved barbecues", 1, 2);
        SHOW_BARBECUE_CMD = new Command("Show barbecue", 4, 1);
        DELETE_BARBECUE_CMD = new Command("Delete barbecue", 1, 2);
        ABOUT_CMD = new Command("About", 5, 4);
        SET_BARBECUE_NAME_CMD = new Command("Save barbecue", 1, 1);
        SAVE_BARBECUE_CMD = new Command("Save", 1, 1);
        BACK_CMD = new Command("Back", 2, 2);
        EXIT_CMD = new Command("Exit", 7, 5);
    }
}

