/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.barbecuecalculator.core;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import net.sourceforge.floggy.barbecuecalculator.core.CommandHandler;
import net.sourceforge.floggy.barbecuecalculator.core.DisplayManager;
import net.sourceforge.floggy.barbecuecalculator.core.DisplayManagerException;
import net.sourceforge.floggy.barbecuecalculator.core.DisplayManagerNotStartedException;
import net.sourceforge.floggy.barbecuecalculator.core.FlowManagerAlreadyStartedException;
import net.sourceforge.floggy.barbecuecalculator.core.FlowManagerNotStartedException;
import net.sourceforge.floggy.barbecuecalculator.persistence.Barbecue;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;

public class FlowManager {
    private static FlowManager instance;
    private MIDlet midlet;
    private Barbecue barbecue;
    private Barbecue[] savedBarbecues;

    private FlowManager(MIDlet midlet) {
        this.midlet = midlet;
    }

    public static FlowManager startFlowManager(MIDlet midlet) throws FlowManagerAlreadyStartedException {
        if (instance != null) {
            throw new FlowManagerAlreadyStartedException("FlowManager already exists at " + instance);
        }
        instance = new FlowManager(midlet);
        return instance;
    }

    public static FlowManager getInstance() throws FlowManagerNotStartedException {
        if (instance == null) {
            throw new FlowManagerNotStartedException();
        }
        return instance;
    }

    public void endApplication() {
        this.midlet.notifyDestroyed();
    }

    public void exibirDadosChurrasForm() {
        Form barbecueForm = new Form("Churras Calculator");
        barbecueForm.append((Item)new TextField("# men", "", 3, 2));
        barbecueForm.append((Item)new TextField("# woman", "", 3, 2));
        barbecueForm.append((Item)new ChoiceGroup("", 2, new String[]{" With Caipirinha"}, new Image[]{null}));
        barbecueForm.append((Item)new Gauge("Alchool level", true, 5, 3));
        barbecueForm.append((Item)new Gauge("Food level", true, 5, 3));
        barbecueForm.addCommand(CommandHandler.CALCULATE_CMD);
        barbecueForm.addCommand(CommandHandler.BACK_CMD);
        barbecueForm.setCommandListener((CommandListener)CommandHandler.getInstance());
        try {
            DisplayManager.getInstance().show((Displayable)barbecueForm, true);
        }
        catch (DisplayManagerNotStartedException displayManagerNotStartedException) {
            // empty catch block
        }
    }

    public void calculateBarbecue() {
        Form barbecueForm = null;
        try {
            barbecueForm = (Form)DisplayManager.getInstance().getCurrent();
        }
        catch (DisplayManagerNotStartedException e) {
            // empty catch block
        }
        int men = 0;
        int women = 0;
        try {
            String value = ((TextField)barbecueForm.get(0)).getString();
            men = Integer.parseInt(value);
            value = ((TextField)barbecueForm.get(1)).getString();
            women = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        boolean withCaipirinha = ((ChoiceGroup)barbecueForm.get(2)).isSelected(0);
        int alchoolLevel = ((Gauge)barbecueForm.get(3)).getValue();
        int foodQuantity = ((Gauge)barbecueForm.get(4)).getValue();
        if (men == 0 && women == 0) {
            try {
                DisplayManager.getInstance().show(new Alert("Warn!", "# of men and woman required!", null, AlertType.ERROR));
            }
            catch (DisplayManagerException e) {}
        } else if (alchoolLevel <= 0 || foodQuantity <= 0) {
            try {
                DisplayManager.getInstance().show(new Alert("Warn!", "Every barbecue has to have drink and food!!!", null, AlertType.ERROR));
            }
            catch (DisplayManagerException e) {}
        } else {
            this.barbecue = new Barbecue(men, women, alchoolLevel, foodQuantity, withCaipirinha);
            this.barbecue.calculateBarbecue();
            this.showBarbecue();
        }
    }

    public void showBarbecue() {
        Form listaChurras = new Form("Show barbecue");
        listaChurras.append("\nMens: " + this.barbecue.getMen());
        listaChurras.append("\nWomen: " + this.barbecue.getWomen());
        listaChurras.append("\nSalsague: " + this.barbecue.getSalsague() + " kg");
        listaChurras.append("\nMeat: " + this.barbecue.getMeat() + " kg");
        listaChurras.append("\nBeer: " + this.barbecue.getBeer() + " cans");
        listaChurras.append("\nSoda: " + this.barbecue.getSoda() + " 2 litters bottle");
        listaChurras.append("\nBread: " + this.barbecue.getBread() + " un");
        listaChurras.append("\nFarofa: " + this.barbecue.getFarofa() + " un");
        listaChurras.append("\nCoal: " + this.barbecue.getCoal() + " bags");
        listaChurras.append("\nNapkins: " + this.barbecue.getNapkin() + " emb. c/50");
        listaChurras.append("\nAlchool: " + this.barbecue.getAlchool() + " L");
        listaChurras.append("\nPano de Prato: " + this.barbecue.getPanoDePrato() + " un");
        listaChurras.append("\nBarbecue knife: " + this.barbecue.getBarbecueKnife() + " un");
        listaChurras.append("\nPlates: " + this.barbecue.getPlate() + " un");
        listaChurras.append("\nForks: " + this.barbecue.getFork() + " un");
        listaChurras.append("\nPlastic cups: " + this.barbecue.getPlasticCup() + " emb. c/20");
        listaChurras.append("\nSalt: " + this.barbecue.getBulkedSalt() + " kg");
        if (this.barbecue.isWithCaipirinha()) {
            listaChurras.append("\nLimon: " + this.barbecue.getLimon() + " un");
            listaChurras.append("\nCacha\u00e7a: " + this.barbecue.getCachaca() + " L");
            listaChurras.append("\nSugar: " + this.barbecue.getSugar() + " kg");
        }
        listaChurras.addCommand(CommandHandler.SET_BARBECUE_NAME_CMD);
        listaChurras.addCommand(CommandHandler.BACK_CMD);
        listaChurras.addCommand(CommandHandler.EXIT_CMD);
        listaChurras.setCommandListener((CommandListener)CommandHandler.getInstance());
        try {
            DisplayManager.getInstance().show((Displayable)listaChurras, true);
        }
        catch (DisplayManagerNotStartedException displayManagerNotStartedException) {
            // empty catch block
        }
    }

    public void salvarChurrasco() {
        Form salvarChurrasForm = new Form("Save barbecue");
        salvarChurrasForm.append((Item)new TextField("Give a name to the barbecue to save: ", "", 30, 0));
        salvarChurrasForm.addCommand(CommandHandler.SAVE_BARBECUE_CMD);
        salvarChurrasForm.addCommand(CommandHandler.BACK_CMD);
        salvarChurrasForm.setCommandListener((CommandListener)CommandHandler.getInstance());
        try {
            DisplayManager.getInstance().show((Displayable)salvarChurrasForm, true);
        }
        catch (DisplayManagerNotStartedException displayManagerNotStartedException) {
            // empty catch block
        }
    }

    public void finalizarPersistenciaChurras() {
        Form dadosChurras = null;
        try {
            dadosChurras = (Form)DisplayManager.getInstance().getCurrent();
        }
        catch (DisplayManagerNotStartedException e) {
            // empty catch block
        }
        this.barbecue.setDescription(((TextField)dadosChurras.get(0)).getString());
        try {
            PersistableManager.getInstance().save((Persistable)this.barbecue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DisplayManager.getInstance().backToTheFirst();
            DisplayManager.getInstance().show(new Alert("Success", "Barbecue saved!", null, AlertType.CONFIRMATION));
        }
        catch (DisplayManagerException displayManagerException) {
            // empty catch block
        }
    }

    public void exibirListaChurrasSalvos() {
        List churrasSalvosList = new List("Saved barbecues", 3);
        churrasSalvosList.setFitPolicy(2);
        try {
            Barbecue temp = new Barbecue();
            ObjectSet os = PersistableManager.getInstance().find(temp.getClass(), null, null);
            int size = os.size();
            this.savedBarbecues = new Barbecue[size];
            for (int i = 0; i < size; ++i) {
                this.savedBarbecues[i] = (Barbecue)os.get(i);
            }
        }
        catch (FloggyException e) {
            e.printStackTrace();
        }
        if (this.savedBarbecues.length == 0) {
            try {
                DisplayManager.getInstance().show(new Alert("Warn", "There isn't barbecues saved.", null, AlertType.INFO));
            }
            catch (DisplayManagerException e) {}
        } else {
            for (int i = 0; i < this.savedBarbecues.length; ++i) {
                churrasSalvosList.append(this.savedBarbecues[i].getDescription(), null);
            }
            churrasSalvosList.addCommand(CommandHandler.SHOW_BARBECUE_CMD);
            churrasSalvosList.addCommand(CommandHandler.DELETE_BARBECUE_CMD);
            churrasSalvosList.addCommand(CommandHandler.BACK_CMD);
            churrasSalvosList.setCommandListener((CommandListener)CommandHandler.getInstance());
            try {
                DisplayManager.getInstance().show((Displayable)churrasSalvosList, true);
            }
            catch (DisplayManagerNotStartedException displayManagerNotStartedException) {
                // empty catch block
            }
        }
    }

    public void exibirChurrasSalvo(int selectedIndex) {
        this.barbecue = this.savedBarbecues[selectedIndex];
        this.showBarbecue();
    }

    public void apagarChurrasSalvo(int selectedIndex) {
        try {
            PersistableManager.getInstance().delete((Persistable)this.savedBarbecues[selectedIndex]);
            DisplayManager.getInstance().removeFromToShowStack();
            this.exibirListaChurrasSalvos();
        }
        catch (FloggyException e) {
        }
        catch (DisplayManagerException displayManagerException) {
            // empty catch block
        }
    }

    public void showAboutForm() {
        Form aboutForm = new Form("About");
        aboutForm.append((Item)new StringItem("Barbecue Calculator Floggynized", "Calculator of itens to do a barbecue."));
        aboutForm.append((Item)new StringItem("Author: ", "Neto Marin"));
        aboutForm.append((Item)new StringItem("Contatc: ", "netomarin@gmail.com"));
        aboutForm.append((Item)new StringItem("Floggynizer: ", "Thiago Moreira"));
        aboutForm.append((Item)new StringItem("Contatc: ", "thiago.moreira@floggy.org"));
        aboutForm.addCommand(CommandHandler.BACK_CMD);
        aboutForm.setCommandListener((CommandListener)CommandHandler.getInstance());
        try {
            DisplayManager.getInstance().show((Displayable)aboutForm, true);
        }
        catch (DisplayManagerNotStartedException displayManagerNotStartedException) {
            // empty catch block
        }
    }
}

