/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.barbecuecalculator.persistence;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Hashtable;
import net.sourceforge.floggy.barbecuecalculator.core.Util;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.impl.FloggyOutputStream;
import net.sourceforge.floggy.persistence.impl.SerializationHelper;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class Barbecue
implements Persistable,
__Persistable {
    public static int ALCHOOL_LEVEL_SUSSA = 1;
    public static int ALCHOOL_LEVEL_RELAX = 2;
    public static int ALCHOOL_LEVEL_NORMAL = 3;
    public static int ALCHOOL_LEVEL_BUDDIES = 4;
    public static int ALCHOOL_LEVEL_UNIVERSITY = 5;
    public static int FOOD_QUANTITY_LUNCH = 1;
    public static int FOOD_QUANTITY_LIGHT = 2;
    public static int FOOD_QUANTITY_NORMAL = 3;
    public static int FOOD_QUANTITY_BIG_FAMILY = 4;
    public static int FOOD_QUANTITY_LONG_DURATION = 5;
    private static Hashtable DRINK_RATE = new Hashtable();
    private static Hashtable FOOD_RATE = new Hashtable();
    private int alchool;
    private int alchoolLevel;
    private int barbecueKnife;
    private int beer;
    private int bread;
    private int bulkedSalt;
    private int cachaca;
    private int coal;
    private String description;
    private int farofa;
    private int foodQuantity;
    private int fork;
    private int limon;
    private double meat;
    private int men;
    private int napkin;
    private int panoDePrato;
    private int plasticCup;
    private int plate;
    private double salsague;
    private int soda;
    private int sugar;
    private boolean withCaipirinha;
    private int women;
    public int __id = -1;

    public Barbecue() {
    }

    public Barbecue(int men, int women, int alchoolLevel, int foodQuantity, boolean withCaipirinha) {
        this.men = men;
        this.women = women;
        this.alchoolLevel = alchoolLevel;
        this.foodQuantity = foodQuantity;
        this.withCaipirinha = withCaipirinha;
    }

    public void calculateBarbecue() {
        double foodRate = (Double)FOOD_RATE.get(new Integer(this.getFoodQuantity()));
        int drinkRate = (Integer)DRINK_RATE.get(new Integer(this.getAlchoolLevel()));
        this.setSalsague((double)this.men * (foodRate - 0.08) + (double)this.women * (foodRate - 0.1));
        this.setMeat((double)this.men * foodRate + (double)this.women * (foodRate - 0.07));
        this.setBeer(this.men * drinkRate + this.women * (drinkRate - 2));
        this.setSoda(1 + Util.round(((double)this.men * 0.3 + (double)this.women * 0.5) / 2.0));
        this.setBread((int)((double)(this.men * 2) + (double)this.women * 1.5));
        this.setFarofa(Util.round(1.0 + ((double)this.men * 0.03 + (double)this.women * 0.01)));
        this.setCoal(Util.round(1.0 + this.getMeat() / 7.0));
        this.setNapkin(Util.round(1 + (this.men + this.women) / 14));
        this.setAlchool(1);
        this.setPanoDePrato(1 + Util.round((this.men + this.women) / 10));
        this.setBarbecueKnife(2 + Util.round((this.men + this.women) / 10));
        this.setPlate(3 + Util.round(this.men / 10 + this.women / 10));
        this.setFork(2 + Util.round((this.men + this.women) / 10));
        this.setPlasticCup(Util.round(((double)this.men * 1.2 + (double)this.women * 1.5 + 1.0) / 20.0));
        this.setBulkedSalt(Util.round(this.getMeat() / 30.0));
        this.setLimon(3 + Util.round(this.men / 2 + this.women / 2));
        this.setCachaca(Util.round((this.men + this.women) / 20));
        this.setSugar(Util.round(((this.men + this.women) / 20 + 1) / 5));
    }

    public int getAlchool() {
        return this.alchool;
    }

    public int getAlchoolLevel() {
        return this.alchoolLevel;
    }

    public int getBarbecueKnife() {
        return this.barbecueKnife;
    }

    public int getBeer() {
        return this.beer;
    }

    public int getBread() {
        return this.bread;
    }

    public int getBulkedSalt() {
        return this.bulkedSalt;
    }

    public int getCachaca() {
        return this.cachaca;
    }

    public int getCoal() {
        return this.coal;
    }

    public String getDescription() {
        return this.description;
    }

    public int getFarofa() {
        return this.farofa;
    }

    public int getFoodQuantity() {
        return this.foodQuantity;
    }

    public int getFork() {
        return this.fork;
    }

    public int getLimon() {
        return this.limon;
    }

    public double getMeat() {
        return this.meat;
    }

    public int getMen() {
        return this.men;
    }

    public int getNapkin() {
        return this.napkin;
    }

    public int getPanoDePrato() {
        return this.panoDePrato;
    }

    public int getPlasticCup() {
        return this.plasticCup;
    }

    public int getPlate() {
        return this.plate;
    }

    public double getSalsague() {
        return this.salsague;
    }

    public int getSoda() {
        return this.soda;
    }

    public int getSugar() {
        return this.sugar;
    }

    public int getWomen() {
        return this.women;
    }

    public boolean isWithCaipirinha() {
        return this.withCaipirinha;
    }

    public void setAlchool(int alchool) {
        this.alchool = alchool;
    }

    public void setAlchoolLevel(int alchoolLevel) {
        this.alchoolLevel = alchoolLevel;
    }

    public void setBarbecueKnife(int barbecueKnife) {
        this.barbecueKnife = barbecueKnife;
    }

    public void setBeer(int beer) {
        this.beer = beer;
    }

    public void setBread(int bread) {
        this.bread = bread;
    }

    public void setBulkedSalt(int bulkedSalt) {
        this.bulkedSalt = bulkedSalt;
    }

    public void setCachaca(int cachaca) {
        this.cachaca = cachaca;
    }

    public void setCoal(int coal) {
        this.coal = coal;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFarofa(int farofa) {
        this.farofa = farofa;
    }

    public void setFoodQuantity(int foodQuantity) {
        this.foodQuantity = foodQuantity;
    }

    public void setFork(int fork) {
        this.fork = fork;
    }

    public void setLimon(int limon) {
        this.limon = limon;
    }

    public void setMeat(double meat) {
        this.meat = meat;
    }

    public void setMen(int men) {
        this.men = men;
    }

    public void setNapkin(int napkin) {
        this.napkin = napkin;
    }

    public void setPanoDePrato(int panoDePrato) {
        this.panoDePrato = panoDePrato;
    }

    public void setPlasticCup(int plasticCup) {
        this.plasticCup = plasticCup;
    }

    public void setPlate(int plate) {
        this.plate = plate;
    }

    public void setSalsague(double salsague) {
        this.salsague = salsague;
    }

    public void setSoda(int soda) {
        this.soda = soda;
    }

    public void setSugar(int sugar) {
        this.sugar = sugar;
    }

    public void setWithCaipirinha(boolean withCaipirinha) {
        this.withCaipirinha = withCaipirinha;
    }

    public void setWomen(int women) {
        this.women = women;
    }

    static {
        DRINK_RATE.put(new Integer(1), new Integer(3));
        DRINK_RATE.put(new Integer(2), new Integer(4));
        DRINK_RATE.put(new Integer(3), new Integer(6));
        DRINK_RATE.put(new Integer(4), new Integer(9));
        DRINK_RATE.put(new Integer(5), new Integer(12));
        FOOD_RATE.put(new Integer(1), new Double(0.15));
        FOOD_RATE.put(new Integer(2), new Double(0.22));
        FOOD_RATE.put(new Integer(3), new Double(0.3));
        FOOD_RATE.put(new Integer(4), new Double(0.45));
        FOOD_RATE.put(new Integer(5), new Double(0.6));
    }

    public int __getId() {
        return this.__id;
    }

    public void __setId(int n) {
        this.__id = n;
    }

    public String getRecordStoreName() {
        return "Barbecue1554295280";
    }

    public void __deserialize(byte[] byArray, boolean bl) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        this.alchool = dataInputStream.readInt();
        this.alchoolLevel = dataInputStream.readInt();
        this.barbecueKnife = dataInputStream.readInt();
        this.beer = dataInputStream.readInt();
        this.bread = dataInputStream.readInt();
        this.bulkedSalt = dataInputStream.readInt();
        this.cachaca = dataInputStream.readInt();
        this.coal = dataInputStream.readInt();
        this.description = SerializationHelper.readString(dataInputStream);
        this.farofa = dataInputStream.readInt();
        this.foodQuantity = dataInputStream.readInt();
        this.fork = dataInputStream.readInt();
        this.limon = dataInputStream.readInt();
        this.meat = dataInputStream.readDouble();
        this.men = dataInputStream.readInt();
        this.napkin = dataInputStream.readInt();
        this.panoDePrato = dataInputStream.readInt();
        this.plasticCup = dataInputStream.readInt();
        this.plate = dataInputStream.readInt();
        this.salsague = dataInputStream.readDouble();
        this.soda = dataInputStream.readInt();
        this.sugar = dataInputStream.readInt();
        this.withCaipirinha = dataInputStream.readBoolean();
        this.women = dataInputStream.readInt();
        dataInputStream.close();
    }

    public byte[] __serialize() throws Exception {
        FloggyOutputStream floggyOutputStream = new FloggyOutputStream();
        floggyOutputStream.writeInt(this.alchool);
        floggyOutputStream.writeInt(this.alchoolLevel);
        floggyOutputStream.writeInt(this.barbecueKnife);
        floggyOutputStream.writeInt(this.beer);
        floggyOutputStream.writeInt(this.bread);
        floggyOutputStream.writeInt(this.bulkedSalt);
        floggyOutputStream.writeInt(this.cachaca);
        floggyOutputStream.writeInt(this.coal);
        SerializationHelper.writeString(floggyOutputStream, this.description);
        floggyOutputStream.writeInt(this.farofa);
        floggyOutputStream.writeInt(this.foodQuantity);
        floggyOutputStream.writeInt(this.fork);
        floggyOutputStream.writeInt(this.limon);
        floggyOutputStream.writeDouble(this.meat);
        floggyOutputStream.writeInt(this.men);
        floggyOutputStream.writeInt(this.napkin);
        floggyOutputStream.writeInt(this.panoDePrato);
        floggyOutputStream.writeInt(this.plasticCup);
        floggyOutputStream.writeInt(this.plate);
        floggyOutputStream.writeDouble(this.salsague);
        floggyOutputStream.writeInt(this.soda);
        floggyOutputStream.writeInt(this.sugar);
        floggyOutputStream.writeBoolean(this.withCaipirinha);
        floggyOutputStream.writeInt(this.women);
        floggyOutputStream.flush();
        return floggyOutputStream.toByteArray();
    }

    public void __delete() throws Exception {
    }
}

