/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Enumeration;
import java.util.Hashtable;

public class PersistableMetadata {
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int CALENDAR = 4;
    public static final int CHARACTER = 8;
    public static final int DATE = 16;
    public static final int DOUBLE = 32;
    public static final int FLOAT = 64;
    public static final int HASHTABLE = 128;
    public static final int INT = 256;
    public static final int LONG = 512;
    public static final int PERSISTABLE = 1024;
    public static final int SHORT = 2048;
    public static final int STACK = 4096;
    public static final int STRING = 8192;
    public static final int STRINGBUFFER = 16384;
    public static final int TIMEZONE = 32768;
    public static final int VECTOR = 65536;
    public static final int ARRAY = 131072;
    public static final int PRIMITIVE = 262144;
    private String className;
    private boolean isAbstract;
    private String superClassName;
    private String[] fieldNames;
    private int[] fieldTypes;
    private Hashtable persistableImplementations;
    private String recordStoreName;
    private transient int recordId;

    private static boolean equals(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == hashtable2) {
            return true;
        }
        if (hashtable == null || hashtable2 == null) {
            return false;
        }
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (!(v == null ? hashtable2.get(k) != null || !hashtable2.containsKey(k) : !v.equals(hashtable2.get(k)))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (nArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        int n = stringArray.length;
        if (stringArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String string2 = stringArray2[i];
            if (string != null ? string.equals(string2) : string2 == null) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n = 31 * n + nArray[i];
        }
        return n;
    }

    private static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n = 31 * n + (objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n;
    }

    public PersistableMetadata(boolean bl, String string, String string2, String[] stringArray, int[] nArray, Hashtable hashtable, String string3) {
        this(bl, string, string2, stringArray, nArray, hashtable, string3, -1);
    }

    public PersistableMetadata(boolean bl, String string, String string2, String[] stringArray, int[] nArray, Hashtable hashtable, String string3, int n) {
        this.isAbstract = bl;
        this.className = string;
        this.superClassName = string2;
        this.fieldNames = stringArray;
        this.fieldTypes = nArray;
        this.persistableImplementations = hashtable;
        this.recordStoreName = string3;
        this.recordId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PersistableMetadata persistableMetadata = (PersistableMetadata)object;
        if (this.className == null ? persistableMetadata.className != null : !this.className.equals(persistableMetadata.className)) {
            return false;
        }
        if (!PersistableMetadata.equals(this.fieldNames, persistableMetadata.fieldNames)) {
            return false;
        }
        if (!PersistableMetadata.equals(this.fieldTypes, persistableMetadata.fieldTypes)) {
            return false;
        }
        if (this.isAbstract != persistableMetadata.isAbstract) {
            return false;
        }
        if (this.persistableImplementations == null ? persistableMetadata.persistableImplementations != null : !PersistableMetadata.equals(this.persistableImplementations, persistableMetadata.persistableImplementations)) {
            return false;
        }
        if (this.recordStoreName == null ? persistableMetadata.recordStoreName != null : !this.recordStoreName.equals(persistableMetadata.recordStoreName)) {
            return false;
        }
        return !(this.superClassName == null ? persistableMetadata.superClassName != null : !this.superClassName.equals(persistableMetadata.superClassName));
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int[] getFieldTypes() {
        return this.fieldTypes;
    }

    public String getPersistableImplementationClassForField(String string) {
        return (String)this.persistableImplementations.get(string);
    }

    public Hashtable getPersistableImplementations() {
        return this.persistableImplementations;
    }

    public int getRecordId() {
        return this.recordId;
    }

    public String getRecordStoreName() {
        return this.recordStoreName;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.className == null ? 0 : this.className.hashCode());
        n = 31 * n + PersistableMetadata.hashCode(this.fieldNames);
        n = 31 * n + PersistableMetadata.hashCode(this.fieldTypes);
        n = 31 * n + (this.isAbstract ? 1231 : 1237);
        n = 31 * n + (this.persistableImplementations == null ? 0 : ((Object)this.persistableImplementations).hashCode());
        n = 31 * n + (this.recordStoreName == null ? 0 : this.recordStoreName.hashCode());
        n = 31 * n + (this.superClassName == null ? 0 : this.superClassName.hashCode());
        return n;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setRecordId(int n) {
        this.recordId = n;
    }
}

