/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.PersistableManagerImpl;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class SerializationHelper {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    private static PersistableManager pm = null;

    public static void setPersistableManager(PersistableManager persistableManager) {
        pm = persistableManager;
    }

    public static final Boolean readBoolean(DataInput dataInput) throws IOException {
        Boolean bl = null;
        if (dataInput.readByte() == 0) {
            bl = dataInput.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        return bl;
    }

    public static final Byte readByte(DataInput dataInput) throws IOException {
        Byte by = null;
        if (dataInput.readByte() == 0) {
            by = new Byte(dataInput.readByte());
        }
        return by;
    }

    public static final Calendar readCalendar(DataInput dataInput) throws IOException {
        Calendar calendar = null;
        if (dataInput.readByte() == 0) {
            String string = dataInput.readUTF();
            calendar = Calendar.getInstance(TimeZone.getTimeZone(string));
            calendar.setTime(new Date(dataInput.readLong()));
        }
        return calendar;
    }

    public static final Character readChar(DataInput dataInput) throws IOException {
        Character c = null;
        if (dataInput.readByte() == 0) {
            c = new Character(dataInput.readChar());
        }
        return c;
    }

    public static final Date readDate(DataInput dataInput) throws IOException {
        Date date = null;
        if (dataInput.readByte() == 0) {
            date = new Date(dataInput.readLong());
        }
        return date;
    }

    public static final Double readDouble(DataInput dataInput) throws IOException {
        Double d = null;
        if (dataInput.readByte() == 0) {
            d = new Double(dataInput.readDouble());
        }
        return d;
    }

    public static final Float readFloat(DataInput dataInput) throws IOException {
        Float f = null;
        if (dataInput.readByte() == 0) {
            f = new Float(dataInput.readFloat());
        }
        return f;
    }

    public static final Hashtable readHashtable(DataInput dataInput) throws Exception {
        Hashtable<Object, Object> hashtable = null;
        if (dataInput.readByte() == 0) {
            int n = dataInput.readInt();
            hashtable = new Hashtable<Object, Object>(n);
            for (int i = 0; i < n; ++i) {
                Object object = SerializationHelper.readObject(dataInput, false);
                Object object2 = SerializationHelper.readObject(dataInput, false);
                hashtable.put(object, object2);
            }
        }
        return hashtable;
    }

    public static final Integer readInt(DataInput dataInput) throws IOException {
        Integer n = null;
        if (dataInput.readByte() == 0) {
            n = new Integer(dataInput.readInt());
        }
        return n;
    }

    public static final Long readLong(DataInput dataInput) throws IOException {
        Long l = null;
        if (dataInput.readByte() == 0) {
            l = new Long(dataInput.readLong());
        }
        return l;
    }

    public static final Object readObject(DataInput dataInput, boolean bl) throws Exception {
        Object object = null;
        String string = dataInput.readUTF();
        if ("java.lang.Boolean".equals(string)) {
            object = dataInput.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        } else if ("java.lang.Byte".equals(string)) {
            object = new Byte(dataInput.readByte());
        } else if ("java.lang.Character".equals(string)) {
            object = new Character(dataInput.readChar());
        } else if ("java.lang.Double".equals(string)) {
            object = new Double(dataInput.readDouble());
        } else if ("java.lang.Float".equals(string)) {
            object = new Float(dataInput.readFloat());
        } else if ("java.util.Hashtable".equals(string)) {
            object = SerializationHelper.readHashtable(dataInput);
        } else if ("java.lang.Integer".equals(string)) {
            object = new Integer(dataInput.readInt());
        } else if ("java.lang.Long".equals(string)) {
            object = new Long(dataInput.readLong());
        } else if ("java.lang.Short".equals(string)) {
            object = new Short(dataInput.readShort());
        } else if ("java.lang.String".equals(string)) {
            object = dataInput.readUTF();
        } else if ("java.lang.StringBuffer".equals(string)) {
            object = new StringBuffer(dataInput.readUTF());
        } else if ("java.util.Calendar".equals(string)) {
            String string2 = dataInput.readUTF();
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(string2));
            calendar.setTime(new Date(dataInput.readLong()));
            object = calendar;
        } else if ("java.util.Date".equals(string)) {
            object = new Date(dataInput.readLong());
        } else if ("java.util.TimeZone".equals(string)) {
            object = TimeZone.getTimeZone(dataInput.readUTF());
        } else if ("java.util.Vector".equals(string)) {
            object = SerializationHelper.readVector(dataInput, bl);
        } else if (bl) {
            dataInput.readInt();
        } else {
            object = PersistableManagerImpl.createInstance(Class.forName(string));
            pm.load((Persistable)object, dataInput.readInt(), bl);
        }
        return object;
    }

    public static final Persistable readPersistable(DataInput dataInput, Persistable persistable, boolean bl) throws Exception {
        if (bl) {
            switch (dataInput.readByte()) {
                case -1: {
                    dataInput.readUTF();
                }
                case 0: {
                    dataInput.readInt();
                }
                case 1: {
                    persistable = null;
                }
            }
        } else {
            switch (dataInput.readByte()) {
                case -1: {
                    String string = dataInput.readUTF();
                    persistable = (Persistable)Class.forName(string).newInstance();
                }
                case 0: {
                    pm.load(persistable, dataInput.readInt());
                    break;
                }
                case 1: {
                    persistable = null;
                }
            }
        }
        return persistable;
    }

    public static final Short readShort(DataInput dataInput) throws IOException {
        Short s = null;
        if (dataInput.readByte() == 0) {
            s = new Short(dataInput.readShort());
        }
        return s;
    }

    public static final Stack readStack(DataInput dataInput, boolean bl) throws Exception {
        Stack stack = null;
        Vector vector = SerializationHelper.readVector(dataInput, bl);
        if (vector != null) {
            stack = new Stack();
            for (int i = 0; i < vector.size(); ++i) {
                stack.push(vector.elementAt(i));
            }
        }
        return stack;
    }

    public static final String readString(DataInput dataInput) throws IOException {
        String string = null;
        if (dataInput.readByte() == 0) {
            string = dataInput.readUTF();
        }
        return string;
    }

    public static final StringBuffer readStringBuffer(DataInput dataInput) throws IOException {
        StringBuffer stringBuffer = null;
        if (dataInput.readByte() == 0) {
            stringBuffer = new StringBuffer(dataInput.readUTF());
        }
        return stringBuffer;
    }

    public static final TimeZone readTimeZone(DataInput dataInput) throws IOException {
        TimeZone timeZone = null;
        if (dataInput.readByte() == 0) {
            timeZone = TimeZone.getTimeZone(dataInput.readUTF());
        }
        return timeZone;
    }

    public static final Vector readVector(DataInput dataInput, boolean bl) throws Exception {
        Vector<Object> vector = null;
        if (dataInput.readByte() == 0) {
            int n = dataInput.readInt();
            vector = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                if (dataInput.readByte() == 1) {
                    vector.addElement(null);
                    continue;
                }
                vector.addElement(SerializationHelper.readObject(dataInput, bl));
            }
        }
        return vector;
    }

    public static final void writeBoolean(DataOutput dataOutput, Boolean bl) throws IOException {
        if (bl == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeBoolean(bl);
        }
    }

    public static final void writeByte(DataOutput dataOutput, Byte by) throws IOException {
        if (by == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeByte(by.byteValue());
        }
    }

    public static final void writeCalendar(DataOutput dataOutput, Calendar calendar) throws IOException {
        if (calendar == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeUTF(calendar.getTimeZone().getID());
            dataOutput.writeLong(calendar.getTime().getTime());
        }
    }

    public static final void writeChar(DataOutput dataOutput, Character c) throws IOException {
        if (c == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeChar(c.charValue());
        }
    }

    public static final void writeDate(DataOutput dataOutput, Date date) throws IOException {
        if (date == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeLong(date.getTime());
        }
    }

    public static final void writeDouble(DataOutput dataOutput, Double d) throws IOException {
        if (d == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeDouble(d);
        }
    }

    public static final void writeFloat(DataOutput dataOutput, Float f) throws IOException {
        if (f == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeFloat(f.floatValue());
        }
    }

    public static final void writeHashtable(DataOutput dataOutput, Hashtable hashtable) throws Exception {
        if (hashtable == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeInt(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                SerializationHelper.writeObject(dataOutput, k);
                SerializationHelper.writeObject(dataOutput, hashtable.get(k));
            }
        }
    }

    public static final void writeInt(DataOutput dataOutput, Integer n) throws IOException {
        if (n == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeInt(n);
        }
    }

    public static final void writeLong(DataOutput dataOutput, Long l) throws IOException {
        if (l == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeLong(l);
        }
    }

    public static final void writeObject(DataOutput dataOutput, Object object) throws Exception {
        String string = object.getClass().getName();
        if (object instanceof Calendar) {
            string = "java.util.Calendar";
        } else if (object instanceof TimeZone) {
            string = "java.util.TimeZone";
        }
        dataOutput.writeUTF(string);
        if (object instanceof Boolean) {
            dataOutput.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            dataOutput.writeByte(((Byte)object).byteValue());
        } else if (object instanceof Character) {
            dataOutput.writeChar(((Character)object).charValue());
        } else if (object instanceof Double) {
            dataOutput.writeDouble((Double)object);
        } else if (object instanceof Float) {
            dataOutput.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            SerializationHelper.writeHashtable(dataOutput, hashtable);
        } else if (object instanceof Integer) {
            dataOutput.writeInt((Integer)object);
        } else if (object instanceof Long) {
            dataOutput.writeLong((Long)object);
        } else if (object instanceof Short) {
            dataOutput.writeShort(((Short)object).shortValue());
        } else if (object instanceof String) {
            dataOutput.writeUTF(object.toString());
        } else if (object instanceof StringBuffer) {
            dataOutput.writeUTF(object.toString());
        } else if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            dataOutput.writeUTF(calendar.getTimeZone().getID());
            dataOutput.writeLong(calendar.getTime().getTime());
        } else if (object instanceof Date) {
            dataOutput.writeLong(((Date)object).getTime());
        } else if (object instanceof TimeZone) {
            TimeZone timeZone = (TimeZone)object;
            dataOutput.writeUTF(timeZone.getID());
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            SerializationHelper.writeVector(dataOutput, vector);
        } else if (object instanceof __Persistable) {
            int n = pm.save((Persistable)object);
            dataOutput.writeInt(n);
        } else {
            throw new FloggyException("The class " + string + " doesn't is a persistable class!");
        }
    }

    public static final void writePersistable(DataOutput dataOutput, String string, Persistable persistable) throws Exception {
        if (persistable == null) {
            dataOutput.writeByte(1);
        } else {
            String string2 = persistable.getClass().getName();
            if (!string.equals(string2)) {
                dataOutput.writeByte(-1);
                dataOutput.writeUTF(string2);
            } else {
                dataOutput.writeByte(0);
            }
            dataOutput.writeInt(pm.save(persistable));
        }
    }

    public static final void writeShort(DataOutput dataOutput, Short s) throws IOException {
        if (s == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeChar(s.shortValue());
        }
    }

    public static final void writeStack(DataOutput dataOutput, Stack stack) throws Exception {
        SerializationHelper.writeVector(dataOutput, stack);
    }

    public static final void writeString(DataOutput dataOutput, String string) throws IOException {
        if (string == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeUTF(string);
        }
    }

    public static final void writeStringBuffer(DataOutput dataOutput, StringBuffer stringBuffer) throws IOException {
        if (stringBuffer == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeUTF(stringBuffer.toString());
        }
    }

    public static final void writeTimeZone(DataOutput dataOutput, TimeZone timeZone) throws IOException {
        if (timeZone == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            dataOutput.writeUTF(timeZone.getID());
        }
    }

    public static final void writeVector(DataOutput dataOutput, Vector vector) throws Exception {
        if (vector == null) {
            dataOutput.writeByte(1);
        } else {
            dataOutput.writeByte(0);
            int n = vector.size();
            dataOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Object e = vector.elementAt(i);
                if (e == null) {
                    dataOutput.writeByte(1);
                    continue;
                }
                dataOutput.writeByte(0);
                SerializationHelper.writeObject(dataOutput, e);
            }
        }
    }

    protected SerializationHelper() {
    }
}

