/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence;

import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.Filter;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.ObjectSet;
import net.sourceforge.floggy.persistence.Persistable;

public abstract class PersistableManager {
    private static PersistableManager instance;

    public static PersistableManager getInstance() {
        if (instance == null) {
            try {
                Class<?> pmClass = Class.forName("net.sourceforge.floggy.persistence.impl.PersistableManagerImpl");
                instance = (PersistableManager)pmClass.newInstance();
            }
            catch (ClassNotFoundException cnfex) {
                throw new RuntimeException("No PersistableManager implementation was found. Please check the weaver execution.");
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                if (message == null) {
                    message = ex.getClass().getName();
                }
                throw new RuntimeException(message);
            }
        }
        return instance;
    }

    public abstract void load(Persistable var1, int var2) throws FloggyException;

    public abstract void load(Persistable var1, int var2, boolean var3) throws FloggyException;

    public abstract int save(Persistable var1) throws FloggyException;

    public abstract void delete(Persistable var1) throws FloggyException;

    public abstract void deleteAll() throws FloggyException;

    public abstract void deleteAll(Class var1) throws FloggyException;

    public abstract ObjectSet find(Class var1, Filter var2, Comparator var3) throws FloggyException;

    public abstract ObjectSet find(Class var1, Filter var2, Comparator var3, boolean var4) throws FloggyException;

    public abstract int getId(Persistable var1);

    public abstract boolean isPersisted(Persistable var1);
}

