/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.SubmitMethod;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.math.NumberUtils;

public class Cache
implements Serializable {
    private static final long serialVersionUID = -3864114727885057419L;
    private int maxSize_ = 20;
    private final Map entries_ = Collections.synchronizedMap(new HashMap(this.maxSize_));

    public void cacheIfNeeded(WebRequestSettings request, WebResponse response) {
        if (this.isCacheable(request, response)) {
            this.entries_.put(response.getUrl(), new Entry(response));
            this.deleteOverflow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteOverflow() {
        Map map = this.entries_;
        synchronized (map) {
            while (this.entries_.size() > this.maxSize_) {
                Entry oldestEntry = (Entry)Collections.min(this.entries_.values());
                this.entries_.remove(oldestEntry.response_.getUrl());
            }
        }
    }

    protected boolean isCacheable(WebRequestSettings request, WebResponse response) {
        return SubmitMethod.GET.equals(response.getRequestMethod()) && this.isJavaScript(response) && !this.isDynamicContent(response);
    }

    protected boolean isDynamicContent(WebResponse response) {
        Date lastModified = this.parseDateHeader(response, "Last-Modified");
        Date expires = this.parseDateHeader(response, "Expires");
        long delay = 600000L;
        long now = System.currentTimeMillis();
        boolean cacheableContent = expires != null && expires.getTime() - now > 600000L || expires == null && lastModified != null && now - lastModified.getTime() > 600000L;
        return !cacheableContent;
    }

    protected Date parseDateHeader(WebResponse response, String headerName) {
        String value = response.getResponseHeaderValue(headerName);
        Date date = null;
        if (value != null) {
            try {
                date = DateUtil.parseDate((String)value);
            }
            catch (DateParseException e) {
                date = null;
            }
        }
        return date;
    }

    protected boolean isJavaScript(WebResponse webResponse) {
        String contentType = webResponse.getContentType().toLowerCase();
        return "text/javascript".equals(contentType) || "application/x-javascript".equals(contentType) || webResponse.getUrl().getPath().endsWith(".js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebResponse getCachedContent(WebRequestSettings request) {
        if (!SubmitMethod.GET.equals(request.getSubmitMethod())) {
            return null;
        }
        Entry cachedEntry = (Entry)this.entries_.get(request.getURL());
        if (cachedEntry == null) {
            return null;
        }
        Map map = this.entries_;
        synchronized (map) {
            cachedEntry.touch();
        }
        return cachedEntry.response_;
    }

    public int getMaxSize() {
        return this.maxSize_;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Illegal value for maxSize: " + maxSize);
        }
        this.maxSize_ = maxSize;
        this.deleteOverflow();
    }

    public int getSize() {
        return this.entries_.size();
    }

    private class Entry
    implements Comparable {
        private final WebResponse response_;
        private long lastAccess_;

        Entry(WebResponse response) {
            this.response_ = response;
            this.lastAccess_ = System.currentTimeMillis();
        }

        public int compareTo(Object other) {
            return NumberUtils.compare((float)this.lastAccess_, (float)((Entry)other).lastAccess_);
        }

        public void touch() {
            this.lastAccess_ = System.currentTimeMillis();
        }
    }
}

