/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ObjectInstantiationException;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DefaultElementFactory;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLErrorHandler;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.IElementFactory;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.UnknownElementFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class HTMLParser {
    private static final Map ELEMENT_FACTORIES = new HashMap();
    private static boolean IgnoreOutsideContent_;

    public static void setIgnoreOutsideContent(boolean ignoreOutsideContent) {
        IgnoreOutsideContent_ = ignoreOutsideContent;
    }

    public static boolean getIgnoreOutsideContent() {
        return IgnoreOutsideContent_;
    }

    public static IElementFactory getFactory(String tagName) {
        IElementFactory result = (IElementFactory)ELEMENT_FACTORIES.get(tagName);
        if (result != null) {
            return result;
        }
        return UnknownElementFactory.instance;
    }

    private HTMLParser() {
    }

    public static void parseFragment(DomNode parent, String source) throws SAXException, IOException {
        URL url = parent.getPage().getWebResponse().getUrl();
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(parent, url);
        domBuilder.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        XMLInputSource in = new XMLInputSource(null, parent.getPage().getWebResponse().getUrl().toString(), null, (Reader)new StringReader(source), null);
        domBuilder.parse(in);
    }

    public static HtmlPage parse(WebResponse webResponse, WebWindow webWindow) throws IOException {
        HtmlPage page = new HtmlPage(webResponse.getUrl(), webResponse, webWindow);
        webWindow.setEnclosedPage(page);
        HtmlUnitDOMBuilder domBuilder = new HtmlUnitDOMBuilder(page, webResponse.getUrl());
        String charSet = webResponse.getContentCharSet();
        if (!Charset.isSupported(charSet)) {
            charSet = "ISO-8859-1";
        }
        XMLInputSource in = new XMLInputSource(null, webResponse.getUrl().toString(), null, webResponse.getContentAsStream(), charSet);
        try {
            domBuilder.parse(in);
        }
        catch (XNIException e) {
            Throwable origin = HTMLParser.extractNestedException(e);
            throw new RuntimeException("Failed parsing content from " + webResponse.getUrl(), origin);
        }
        return domBuilder.page_;
    }

    static Throwable extractNestedException(Throwable e) {
        Throwable originalException = e;
        Throwable cause = ((XNIException)e).getException();
        while (cause != null) {
            originalException = cause;
            if (cause instanceof XNIException) {
                cause = ((XNIException)cause).getException();
                continue;
            }
            if (cause instanceof InvocationTargetException) {
                cause = cause.getCause();
                continue;
            }
            cause = null;
        }
        return originalException;
    }

    static {
        ELEMENT_FACTORIES.put("input", InputElementFactory.instance);
        DefaultElementFactory defaultElementFactory = new DefaultElementFactory();
        ELEMENT_FACTORIES.put("a", defaultElementFactory);
        ELEMENT_FACTORIES.put("applet", defaultElementFactory);
        ELEMENT_FACTORIES.put("address", defaultElementFactory);
        ELEMENT_FACTORIES.put("area", defaultElementFactory);
        ELEMENT_FACTORIES.put("base", defaultElementFactory);
        ELEMENT_FACTORIES.put("basefont", defaultElementFactory);
        ELEMENT_FACTORIES.put("bdo", defaultElementFactory);
        ELEMENT_FACTORIES.put("blockquote", defaultElementFactory);
        ELEMENT_FACTORIES.put("body", defaultElementFactory);
        ELEMENT_FACTORIES.put("br", defaultElementFactory);
        ELEMENT_FACTORIES.put("button", defaultElementFactory);
        ELEMENT_FACTORIES.put("caption", defaultElementFactory);
        ELEMENT_FACTORIES.put("center", defaultElementFactory);
        ELEMENT_FACTORIES.put("col", defaultElementFactory);
        ELEMENT_FACTORIES.put("colgroup", defaultElementFactory);
        ELEMENT_FACTORIES.put("dd", defaultElementFactory);
        ELEMENT_FACTORIES.put("del", defaultElementFactory);
        ELEMENT_FACTORIES.put("dir", defaultElementFactory);
        ELEMENT_FACTORIES.put("div", defaultElementFactory);
        ELEMENT_FACTORIES.put("dl", defaultElementFactory);
        ELEMENT_FACTORIES.put("dt", defaultElementFactory);
        ELEMENT_FACTORIES.put("fieldset", defaultElementFactory);
        ELEMENT_FACTORIES.put("font", defaultElementFactory);
        ELEMENT_FACTORIES.put("form", defaultElementFactory);
        ELEMENT_FACTORIES.put("frame", defaultElementFactory);
        ELEMENT_FACTORIES.put("frameset", defaultElementFactory);
        ELEMENT_FACTORIES.put("h1", defaultElementFactory);
        ELEMENT_FACTORIES.put("h2", defaultElementFactory);
        ELEMENT_FACTORIES.put("h3", defaultElementFactory);
        ELEMENT_FACTORIES.put("h4", defaultElementFactory);
        ELEMENT_FACTORIES.put("h5", defaultElementFactory);
        ELEMENT_FACTORIES.put("h6", defaultElementFactory);
        ELEMENT_FACTORIES.put("head", defaultElementFactory);
        ELEMENT_FACTORIES.put("hr", defaultElementFactory);
        ELEMENT_FACTORIES.put("html", defaultElementFactory);
        ELEMENT_FACTORIES.put("iframe", defaultElementFactory);
        ELEMENT_FACTORIES.put("img", defaultElementFactory);
        ELEMENT_FACTORIES.put("ins", defaultElementFactory);
        ELEMENT_FACTORIES.put("isindex", defaultElementFactory);
        ELEMENT_FACTORIES.put("label", defaultElementFactory);
        ELEMENT_FACTORIES.put("legend", defaultElementFactory);
        ELEMENT_FACTORIES.put("li", defaultElementFactory);
        ELEMENT_FACTORIES.put("link", defaultElementFactory);
        ELEMENT_FACTORIES.put("map", defaultElementFactory);
        ELEMENT_FACTORIES.put("menu", defaultElementFactory);
        ELEMENT_FACTORIES.put("meta", defaultElementFactory);
        ELEMENT_FACTORIES.put("noframes", defaultElementFactory);
        ELEMENT_FACTORIES.put("noscript", defaultElementFactory);
        ELEMENT_FACTORIES.put("object", defaultElementFactory);
        ELEMENT_FACTORIES.put("ol", defaultElementFactory);
        ELEMENT_FACTORIES.put("optgroup", defaultElementFactory);
        ELEMENT_FACTORIES.put("option", defaultElementFactory);
        ELEMENT_FACTORIES.put("p", defaultElementFactory);
        ELEMENT_FACTORIES.put("param", defaultElementFactory);
        ELEMENT_FACTORIES.put("pre", defaultElementFactory);
        ELEMENT_FACTORIES.put("q", defaultElementFactory);
        ELEMENT_FACTORIES.put("script", defaultElementFactory);
        ELEMENT_FACTORIES.put("select", defaultElementFactory);
        ELEMENT_FACTORIES.put("span", defaultElementFactory);
        ELEMENT_FACTORIES.put("style", defaultElementFactory);
        ELEMENT_FACTORIES.put("title", defaultElementFactory);
        ELEMENT_FACTORIES.put("table", defaultElementFactory);
        ELEMENT_FACTORIES.put("tbody", defaultElementFactory);
        ELEMENT_FACTORIES.put("td", defaultElementFactory);
        ELEMENT_FACTORIES.put("th", defaultElementFactory);
        ELEMENT_FACTORIES.put("tr", defaultElementFactory);
        ELEMENT_FACTORIES.put("textarea", defaultElementFactory);
        ELEMENT_FACTORIES.put("tfoot", defaultElementFactory);
        ELEMENT_FACTORIES.put("thead", defaultElementFactory);
        ELEMENT_FACTORIES.put("ul", defaultElementFactory);
    }

    private static final class HtmlUnitDOMBuilder
    extends AbstractSAXParser
    implements ContentHandler,
    LexicalHandler {
        private final HtmlPage page_;
        private Locator locator_;
        private final Stack stack_ = new Stack();
        private DomNode currentNode_;
        private StringBuffer characters_;
        private boolean headParsed_ = false;

        private HtmlUnitDOMBuilder(DomNode page, URL url) {
            super((XMLParserConfiguration)new HTMLConfiguration());
            boolean reportErrors;
            this.page_ = page.getPage();
            this.currentNode_ = page;
            this.stack_.push(this.currentNode_);
            HTMLParserListener listener = this.page_.getWebClient().getHTMLParserListener();
            if (listener != null) {
                reportErrors = true;
                this.fConfiguration.setErrorHandler((XMLErrorHandler)new HTMLErrorHandler(listener, url));
            } else {
                reportErrors = false;
            }
            try {
                this.setFeature("http://cyberneko.org/html/features/augmentations", true);
                this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
                this.setFeature("http://cyberneko.org/html/features/report-errors", reportErrors);
                this.setFeature("http://cyberneko.org/html/features/balance-tags/ignore-outside-content", IgnoreOutsideContent_);
                this.setContentHandler(this);
                this.setLexicalHandler(this);
            }
            catch (SAXException e) {
                throw new ObjectInstantiationException("unable to create HTML parser", e);
            }
        }

        public Locator getLocator() {
            return this.locator_;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator_ = locator;
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            HtmlElement newElement;
            IElementFactory factory;
            this.handleCharacters();
            String tagLower = localName.toLowerCase();
            if (tagLower.equals("head")) {
                this.headParsed_ = true;
            } else if (!this.headParsed_ && (tagLower.equals("body") || tagLower.equals("frameset"))) {
                factory = this.getElementFactory("head");
                newElement = factory.createElement(this.page_, "head", null);
                this.currentNode_.appendDomChild(newElement);
                this.headParsed_ = true;
            } else if (tagLower.equals("tr") && this.currentNode_.getNodeName().equals("table")) {
                factory = this.getElementFactory("tbody");
                newElement = factory.createElement(this.page_, "tbody", null);
                this.currentNode_.appendDomChild(newElement);
                this.currentNode_ = newElement;
                this.stack_.push(this.currentNode_);
            }
            factory = this.getElementFactory(tagLower);
            newElement = factory.createElement(this.page_, tagLower, atts);
            newElement.setStartLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            this.currentNode_.appendDomChild(newElement);
            this.currentNode_ = newElement;
            this.stack_.push(this.currentNode_);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.handleCharacters();
            DomNode previousNode = (DomNode)this.stack_.pop();
            previousNode.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
            previousNode.onAllChildrenAddedToPage();
            if (!this.currentNode_.getNodeName().equalsIgnoreCase(localName)) {
                this.stack_.pop();
            }
            if (!this.stack_.isEmpty()) {
                this.currentNode_ = (DomNode)this.stack_.peek();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuffer();
            }
            this.characters_.append(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.characters_ == null) {
                this.characters_ = new StringBuffer();
            }
            this.characters_.append(ch, start, length);
        }

        private void handleCharacters() {
            if (this.characters_ != null && this.characters_.length() > 0) {
                DomText text = new DomText(this.page_, this.characters_.toString());
                this.currentNode_.appendDomChild(text);
                this.characters_.setLength(0);
            }
        }

        private IElementFactory getElementFactory(String tagName) {
            IElementFactory factory = (IElementFactory)ELEMENT_FACTORIES.get(tagName);
            if (factory != null) {
                return factory;
            }
            return UnknownElementFactory.instance;
        }

        public void endDocument() throws SAXException {
            this.handleCharacters();
            HtmlPage currentPage = this.page_;
            currentPage.setEndLocation(this.locator_.getLineNumber(), this.locator_.getColumnNumber());
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void comment(char[] ch, int start, int length) {
            this.handleCharacters();
            DomComment comment = new DomComment(this.page_, String.valueOf(ch, start, length));
            this.currentNode_.appendDomChild(comment);
        }

        public void endCDATA() {
        }

        public void endDTD() {
        }

        public void endEntity(String name) {
        }

        public void startCDATA() {
        }

        public void startDTD(String name, String publicId, String systemId) {
        }

        public void startEntity(String name) {
        }
    }
}

