/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.FocusableElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.util.Map;

public class HtmlButton
extends FocusableElement
implements DisabledElement,
SubmittableElement {
    private static final long serialVersionUID = 4828725767615187345L;
    public static final String TAG_NAME = "button";

    public HtmlButton(HtmlPage page, Map attributes) {
        this(null, TAG_NAME, page, attributes);
    }

    HtmlButton(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public void setValueAttribute(String newValue) {
        this.setAttributeValue("value", newValue);
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        String type = this.getTypeAttribute().toLowerCase();
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            if (type.equals("submit")) {
                return form.submit(this);
            }
            if (type.equals("reset")) {
                return form.reset();
            }
        }
        return defaultPage;
    }

    public final boolean isDisabled() {
        return this.isAttributeDefined("disabled");
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public void reset() {
        this.getLog().debug((Object)"reset() not implemented for this element");
    }

    public void setDefaultValue(String defaultValue) {
        this.getLog().debug((Object)"setDefaultValue() not implemented for this element");
    }

    public String getDefaultValue() {
        this.getLog().debug((Object)"getDefaultValue() not implemented for this element");
        return "";
    }

    public void setDefaultChecked(boolean defaultChecked) {
    }

    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttributeValue("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeValue("value");
    }

    public final String getTypeAttribute() {
        String type = this.getAttributeValue("type");
        if (type == HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            BrowserVersion browser = this.getPage().getWebClient().getBrowserVersion();
            type = browser.isIE() ? TAG_NAME : "submit";
        }
        return type;
    }

    public final String getDisabledAttribute() {
        return this.getAttributeValue("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeValue("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeValue("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeValue("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeValue("onblur");
    }
}

