/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.KeyValuePair;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class HtmlSubmitInput
extends HtmlInput {
    private static final long serialVersionUID = -615974535731910492L;
    private static final String DEFAULT_VALUE = "Submit Query";

    public HtmlSubmitInput(HtmlPage page, Map attributes) {
        this(null, "input", page, attributes);
    }

    HtmlSubmitInput(String namespaceURI, String qualifiedName, HtmlPage page, Map attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getPage().getWebClient().getBrowserVersion().isIE() && !this.isAttributeDefined("value")) {
            this.setAttributeValue("value", DEFAULT_VALUE);
        }
    }

    protected Page doClickAction(Page defaultPage) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            return form.submit(this);
        }
        return super.doClickAction(defaultPage);
    }

    public void reset() {
    }

    public String asText() {
        String text = super.asText();
        if (text == ATTRIBUTE_NOT_DEFINED) {
            text = DEFAULT_VALUE;
        }
        return text;
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        Iterator it = this.getAttributeEntriesIterator();
        while (it.hasNext()) {
            HtmlAttr attribute = (HtmlAttr)it.next();
            if (attribute.getNodeName().equals("value") && attribute.getHtmlValue().equals(DEFAULT_VALUE)) continue;
            printWriter.print(" ");
            String name = attribute.getNodeName();
            printWriter.print(name);
            printWriter.print("=\"");
            printWriter.print(StringEscapeUtils.escapeXml((String)attribute.getNodeValue()));
            printWriter.print("\"");
        }
    }

    public KeyValuePair[] getSubmitKeyValuePairs() {
        if (this.getNameAttribute().length() != 0 && !this.isAttributeDefined("value")) {
            return new KeyValuePair[]{new KeyValuePair(this.getNameAttribute(), DEFAULT_VALUE)};
        }
        return super.getSubmitKeyValuePairs();
    }
}

