/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.xml.XmlAttr;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class HTMLCollection
extends SimpleScriptable
implements Function {
    private static final long serialVersionUID = 4049916048017011764L;
    private XPath xpath_;
    private DomNode node_;
    private Transformer transformer_;
    private List cachedElements_;

    public HTMLCollection() {
    }

    public HTMLCollection(SimpleScriptable parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(((Object)((Object)this)).getClass()));
    }

    public void init(DomNode node, XPath xpath) {
        this.init(node, xpath, NOPTransformer.INSTANCE);
    }

    public void init(DomNode node, XPath xpath, Transformer transformer) {
        if (node != null) {
            this.node_ = node;
            this.xpath_ = xpath;
            try {
                if (node instanceof XmlPage) {
                    XmlElement documentElement = ((XmlPage)node).getDocumentXmlElement();
                    if (documentElement != null) {
                        this.addNamespace(documentElement);
                    }
                } else if (node instanceof XmlElement) {
                    this.addNamespace((XmlElement)node);
                }
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Exception adding namespaces: " + (Object)((Object)e)));
            }
            this.transformer_ = transformer;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    private void addNamespace(XmlElement element) throws JaxenException {
        Map attributes = element.getAttributes();
        Iterator keys = attributes.keySet().iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            String value = (String)((XmlAttr)attributes.get(name)).getValue();
            if (!name.startsWith("xmlns:")) continue;
            String prefix = name.substring("xmlns:".length());
            this.xpath_.addNamespace(prefix, value);
        }
        Iterator children = element.getChildIterator();
        while (children.hasNext()) {
            DomNode child = (DomNode)children.next();
            if (!(child instanceof XmlElement)) continue;
            this.addNamespace((XmlElement)child);
        }
    }

    public final Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        Object response = this.get(args[0]);
        if (response == NOT_FOUND) {
            return null;
        }
        return response;
    }

    public final Scriptable construct(Context arg0, Scriptable arg1, Object[] arg2) throws JavaScriptException {
        return null;
    }

    private Object get(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        HTMLCollection array = (HTMLCollection)start;
        List elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableFor(this.transformer_.transform(elements.get(index)));
        }
        return NOT_FOUND;
    }

    private List getElements() {
        if (this.cachedElements_ == null) {
            try {
                this.cachedElements_ = this.node_ != null ? this.xpath_.selectNodes((Object)this.node_) : new ArrayList();
                boolean isXmlPage = false;
                for (DomNode parent = this.node_; parent != null; parent = parent.getParentDomNode()) {
                    if (!(parent instanceof XmlPage)) continue;
                    isXmlPage = true;
                }
                boolean isIE = this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE();
                block3: for (int i = 0; i < this.cachedElements_.size(); ++i) {
                    Boolean xmlSpaceDefault;
                    DomNode element = (DomNode)this.cachedElements_.get(i);
                    if (isIE && isXmlPage && element instanceof DomText && ((DomText)element).getNodeValue().trim().length() == 0 && (xmlSpaceDefault = HTMLCollection.isXMLSpaceDefault(element.getParentDomNode())) != Boolean.FALSE) {
                        this.cachedElements_.remove(i--);
                        continue;
                    }
                    for (DomNode parent = element.getParentDomNode(); parent != null; parent = parent.getParentDomNode()) {
                        if (!(parent instanceof HtmlNoScript)) continue;
                        this.cachedElements_.remove(i--);
                        continue block3;
                    }
                }
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Exeption getting elements: " + e.getMessage()));
            }
        }
        return this.cachedElements_;
    }

    private static Boolean isXMLSpaceDefault(DomNode node) {
        while (node instanceof XmlElement) {
            String value = ((XmlElement)node).getAttributeValue("xml:space");
            if (value.length() != 0) {
                if (value.equals("default")) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            node = node.getParentDomNode();
        }
        return null;
    }

    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List elements = this.getElements();
        CollectionUtils.transform((Collection)elements, (Transformer)this.transformer_);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof HtmlElement) {
                HtmlElement element = (HtmlElement)next;
                String id = element.getId();
                if (id == null || !id.equals(name)) continue;
                this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by id) to " + element));
                return this.getScriptableFor(element);
            }
            if (next instanceof WebWindow) {
                WebWindow window = (WebWindow)next;
                String windowName = window.getName();
                if (windowName == null || !windowName.equals(name)) continue;
                this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + window));
                return this.getScriptableFor(window);
            }
            this.getLog().debug((Object)("Unrecognized type in array: \"" + next.getClass().getName() + "\""));
        }
        HTMLCollection array = new HTMLCollection(this);
        try {
            String newCondition = "@name = '" + name + "'";
            String currentXPathExpr = this.xpath_.toString();
            String xpathExpr = currentXPathExpr.endsWith("]") ? currentXPathExpr.substring(0, currentXPathExpr.length() - 1) + " and " + newCondition + "]" : currentXPathExpr + "[" + newCondition + "]";
            XPath xpathName = this.xpath_.getNavigator().parseXPath(xpathExpr);
            array.init(this.node_, xpathName);
        }
        catch (SAXPathException e) {
            throw Context.reportRuntimeError((String)("Failed getting sub elements by name" + e.getMessage()));
        }
        List subElements = array.getElements();
        if (subElements.size() > 1) {
            this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + (Object)((Object)array) + " with " + subElements.size() + " elements"));
            return array;
        }
        if (subElements.size() == 1) {
            SimpleScriptable singleResult = this.getScriptableFor(subElements.get(0));
            this.getLog().debug((Object)("Property \"" + name + "\" evaluated (by name) to " + (Object)((Object)singleResult)));
            return singleResult;
        }
        return NOT_FOUND;
    }

    public final int jsxGet_length() {
        return this.getElements().size();
    }

    public final Object jsxFunction_item(Object index) {
        return this.get(index);
    }

    public final Object jsxFunction_namedItem(String name) {
        return this.get(name);
    }

    public final Object jsxFunction_tags(String tagName) {
        HTMLCollection array = new HTMLCollection(this);
        try {
            String newXPathExpr = this.xpath_ + "[name() = '" + tagName.toLowerCase() + "']";
            array.init(this.node_, this.xpath_.getNavigator().parseXPath(newXPathExpr));
        }
        catch (SAXPathException e) {
            throw Context.reportRuntimeError((String)("Failed call tags: " + e.getMessage()));
        }
        return array;
    }

    public String toString() {
        if (this.xpath_ != null) {
            return super.toString() + '<' + this.xpath_ + '>';
        }
        return super.toString();
    }

    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof HTMLCollection) {
            HTMLCollection otherArray = (HTMLCollection)((Object)other);
            if (this.node_ == otherArray.node_ && this.xpath_.toString().equals(otherArray.xpath_.toString()) && this.transformer_.equals(otherArray.transformer_)) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    public boolean has(String name, Scriptable start) {
        if (!this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) {
            if (name.equals("0") || name.equals("length")) {
                return true;
            }
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_2);
            Set functionKeys = jsConfig.getClassConfiguration(this.getClassName()).functionKeys();
            Iterator functionIt = functionKeys.iterator();
            while (functionIt.hasNext()) {
                if (!name.equals(functionIt.next())) continue;
                return true;
            }
            return false;
        }
        return name.equals("length") || this.getWithPreemption(name) != NOT_FOUND;
    }

    public Object[] getIds() {
        ArrayList<String> idList = new ArrayList<String>();
        if (!this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) {
            idList.add("0");
            idList.add("length");
            JavaScriptConfiguration jsConfig = JavaScriptConfiguration.getInstance(BrowserVersion.FIREFOX_2);
            Set functionKeys = jsConfig.getClassConfiguration(this.getClassName()).functionKeys();
            Iterator functionIt = functionKeys.iterator();
            while (functionIt.hasNext()) {
                idList.add((String)functionIt.next());
            }
            idList.remove("tags");
        } else {
            idList.add("length");
            List elements = this.getElements();
            CollectionUtils.transform((Collection)elements, (Transformer)this.transformer_);
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (next instanceof HtmlElement) {
                    HtmlElement element = (HtmlElement)next;
                    String id = element.getId();
                    if (id == HtmlElement.ATTRIBUTE_NOT_DEFINED) continue;
                    idList.add(id);
                    continue;
                }
                if (next instanceof WebWindow) {
                    WebWindow window = (WebWindow)next;
                    String windowName = window.getName();
                    if (windowName == null) continue;
                    idList.add(windowName);
                    continue;
                }
                this.getLog().debug((Object)("Unrecognized type in array: \"" + next.getClass().getName() + "\""));
            }
            if (this.xpath_ != null) {
                HTMLCollection array = new HTMLCollection(this);
                try {
                    String newCondition = "@name";
                    String currentXPathExpr = this.xpath_.toString();
                    String xpathExpr = currentXPathExpr.endsWith("]") ? currentXPathExpr.substring(0, currentXPathExpr.length() - 1) + " and " + "@name" + "]" : currentXPathExpr + "[" + "@name" + "]";
                    XPath xpathName = this.xpath_.getNavigator().parseXPath(xpathExpr);
                    array.init(this.node_, xpathName);
                }
                catch (SAXPathException e) {
                    throw Context.reportRuntimeError((String)("Failed getting sub elements by name" + e.getMessage()));
                }
                List subElements = array.getElements();
                Iterator it = subElements.iterator();
                while (it.hasNext()) {
                    HtmlElement element;
                    String id;
                    DomNode next = (DomNode)it.next();
                    if (!(next instanceof HtmlElement) || (id = (element = (HtmlElement)next).getAttribute("name")) == null) continue;
                    idList.add(id);
                }
            }
        }
        return idList.toArray();
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void nodeDeleted(DomChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            HTMLCollection.this.cachedElements_ = null;
        }
    }
}

