/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class SimpleScriptable
extends ScriptableObject {
    private static final long serialVersionUID = 3120000176890886780L;
    private DomNode domNode_;

    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response != NOT_FOUND) {
            return response;
        }
        if (this == start) {
            return this.getWithPreemption(name);
        }
        return NOT_FOUND;
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    public String getClassName() {
        String javaClassName = ((Object)((Object)this)).getClass().getName();
        int index = javaClassName.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException("No dot in classname: " + javaClassName);
        }
        return javaClassName.substring(index + 1);
    }

    public final DomNode getDomNodeOrDie() throws IllegalStateException {
        if (this.domNode_ == null) {
            String clazz = ((Object)((Object)this)).getClass().getName();
            throw new IllegalStateException("DomNode has not been set for this SimpleScriptable: " + clazz);
        }
        return this.domNode_;
    }

    public final DomNode getDomNodeOrNull() {
        return this.domNode_;
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        Assert.notNull("domNode", domNode);
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptObject(this);
        }
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        this.setDomNode(htmlElement);
    }

    protected final Log getLog() {
        return LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    protected SimpleScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (SimpleScriptable)((Object)((WebWindow)object).getScriptObject());
        }
        DomNode domNode = (DomNode)object;
        ScriptableObject scriptObject = domNode.getScriptObject();
        if (scriptObject != null) {
            return (SimpleScriptable)scriptObject;
        }
        return this.makeScriptableFor(domNode);
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        Class javaScriptClass = null;
        for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
            javaScriptClass = (Class)JavaScriptConfiguration.getHtmlJavaScriptMapping().get(c);
        }
        if (javaScriptClass == null) {
            scriptable = new HTMLElement();
            this.getLog().debug((Object)("No javascript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement"));
        } else {
            try {
                scriptable = (SimpleScriptable)((Object)javaScriptClass.newInstance());
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        if (domNode.getPage().getEnclosingWindow().getEnclosedPage() == domNode.getPage()) {
            scriptable.setParentScope(this.getWindow());
        } else {
            scriptable.setParentScope(ScriptableObject.getTopLevelScope((Scriptable)domNode.getPage().getScriptObject()));
        }
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected Scriptable getPrototype(Class javaScriptClass) {
        return this.getWindow().getPrototype(javaScriptClass);
    }

    protected Transformer getTransformerScriptableFor() {
        return new Transformer(){

            public Object transform(Object obj) {
                return SimpleScriptable.this.getScriptableFor(obj);
            }
        };
    }

    public static Object getObjectArg(int index, Object[] args, Object defaultValue) {
        if (index >= args.length) {
            return defaultValue;
        }
        return args[index];
    }

    public static String getStringArg(int index, Object[] args, String defaultValue) {
        return Context.toString((Object)SimpleScriptable.getObjectArg(index, args, defaultValue));
    }

    public static boolean getBooleanArg(int index, Object[] args, boolean defaultValue) {
        Boolean defaultBoolean = defaultValue;
        return Context.toBoolean((Object)SimpleScriptable.getObjectArg(index, args, defaultBoolean));
    }

    public static int getIntArg(int index, Object[] args, int defaultValue) {
        return (int)Context.toNumber((Object)SimpleScriptable.getObjectArg(index, args, new Integer(defaultValue)));
    }

    public Object getDefaultValue(Class hint) {
        if (String.class.equals(hint) || hint == null) {
            if (this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) {
                return "[object]";
            }
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    protected Window getWindow() throws RuntimeException {
        return SimpleScriptable.getWindow((Scriptable)this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope((Scriptable)s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected Scriptable getStartingScope() {
        return (Scriptable)Context.getCurrentContext().getThreadLocal((Object)"startingScope");
    }
}

