/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNamespaceNode;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.xpath.FunctionContextWrapper;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.html.xpath.LowerCaseFunction;
import com.gargoylesoftware.htmlunit.javascript.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Attribute;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Range;
import com.gargoylesoftware.htmlunit.javascript.host.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.Stylesheet;
import com.gargoylesoftware.htmlunit.javascript.host.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.XPathResult;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.UniqueTag;
import org.w3c.dom.DOMException;

public class Document
extends Node {
    private static final long serialVersionUID = -7646789903352066465L;
    private static final Map SUPPORTED_EVENT_TYPE_MAP;
    private HTMLCollection all_;
    private HTMLCollection forms_;
    private HTMLCollection links_;
    private HTMLCollection images_;
    private HTMLCollection scripts_;
    private HTMLCollection anchors_;
    private StyleSheetList styleSheets_;
    private final StringBuffer writeBuffer_ = new StringBuffer();
    private boolean writeInCurrentDocument_ = true;
    private String domain_;
    private Window window_;
    private final FunctionContextWrapper functionContext_ = new FunctionContextWrapper(XPathFunctionContext.getInstance());
    private DOMImplementation implementation_;

    public Document() {
        this.functionContext_.registerFunction("lower-case", new LowerCaseFunction());
    }

    public void jsConstructor() {
    }

    void setWindow(Window window) {
        this.window_ = window;
    }

    public HtmlPage getHtmlPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    public HtmlPage getHtmlPageOrNull() {
        return (HtmlPage)this.getDomNodeOrNull();
    }

    public Object jsxGet_forms() {
        if (this.forms_ == null) {
            this.forms_ = new HTMLCollection(this);
            try {
                this.forms_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath("//form"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.forms: " + e.getMessage()));
            }
        }
        return this.forms_;
    }

    public Object jsxGet_links() {
        if (this.links_ == null) {
            this.links_ = new HTMLCollection(this);
            try {
                this.links_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath("//a[@href] | //area[@href]"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.links: " + e.getMessage()));
            }
        }
        return this.links_;
    }

    public Object jsxGet_anchors() {
        if (this.anchors_ == null) {
            this.anchors_ = new HTMLCollection(this);
            try {
                String xpath = this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE() ? "//a[@name or @id]" : "//a[@name]";
                this.anchors_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath(xpath));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.anchors: " + e.getMessage()));
            }
        }
        return this.anchors_;
    }

    public static void jsxFunction_write(Context context, Scriptable thisObj, Object[] args, Function function) {
        Document thisAsDocument = Document.getDocument(thisObj);
        thisAsDocument.write(Document.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buffer.append(Context.toString((Object)args[i]));
        }
        return buffer.toString();
    }

    public static void jsxFunction_writeln(Context context, Scriptable thisObj, Object[] args, Function function) {
        Document thisAsDocument = Document.getDocument(thisObj);
        thisAsDocument.write(Document.concatArgsAsString(args) + "\n");
    }

    private static Document getDocument(Scriptable thisObj) {
        if (thisObj instanceof Document) {
            return (Document)thisObj;
        }
        Window window = Document.getWindow(thisObj);
        BrowserVersion browser = window.getWebWindow().getWebClient().getBrowserVersion();
        if (browser.isIE()) {
            return window.jsxGet_document();
        }
        throw Context.reportRuntimeError((String)"Function can't be used detached from document");
    }

    protected void write(String content) {
        this.getLog().debug((Object)("write: " + content));
        this.writeBuffer_.append(content);
        if (!this.writeInCurrentDocument_) {
            this.getLog().debug((Object)"written content added to buffer");
        } else {
            String bufferedContent = this.writeBuffer_.toString();
            if (this.canAlreadyBeParsed(bufferedContent)) {
                this.writeBuffer_.setLength(0);
                this.getLog().debug((Object)("parsing buffered content: " + bufferedContent));
                HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
                HtmlElement current = this.getLastHtmlElement(page.getDocumentHtmlElement());
                this.getLog().debug((Object)("current: " + current));
                if (current instanceof HtmlInlineFrame) {
                    current = (HtmlElement)current.getParentDomNode();
                }
                ((HTMLElement)this.getJavaScriptNode(current)).jsxFunction_insertAdjacentHTML("beforeEnd", bufferedContent);
            } else {
                this.getLog().debug((Object)"write: not enough content to parsed it now");
            }
        }
    }

    private boolean canAlreadyBeParsed(String content) {
        boolean tagOutside = false;
        boolean tagSart = true;
        int tagInName = 2;
        int tagInside = 3;
        int tagState = 0;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        block6: for (int index = 0; index < content.length(); ++index) {
            char currentChar = content.charAt(index);
            switch (tagState) {
                case 0: {
                    if (currentChar != '<') continue block6;
                    tagState = 1;
                    tagIsOpen = true;
                    continue block6;
                }
                case 1: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = 2;
                    continue block6;
                }
                case 2: {
                    if (Character.isLetter(currentChar)) continue block6;
                    String tagName = content.substring(tagNameBeginIndex, index);
                    if (tagName.equalsIgnoreCase("script")) {
                        if (tagIsOpen) {
                            ++scriptTagCount;
                        } else if (scriptTagCount > 0) {
                            --scriptTagCount;
                        }
                    }
                    if (currentChar == '>') {
                        tagState = 0;
                        continue block6;
                    }
                    tagState = 3;
                    continue block6;
                }
                case 3: {
                    if (currentChar != '>') continue block6;
                    tagState = 0;
                    continue block6;
                }
            }
        }
        return scriptTagCount <= 0 && tagState == 0;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastDomChild();
        if (lastChild == null || !(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    public String jsxGet_cookie() {
        HtmlPage page = this.getHtmlPage();
        HttpState state = page.getWebClient().getWebConnection().getState();
        URL url = page.getWebResponse().getUrl();
        boolean secure = "https".equals(url.getProtocol());
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        CookieSpec spec = CookiePolicy.getCookieSpec((String)"compatibility");
        Cookie[] cookies = spec.match(url.getHost(), port, url.getPath(), secure, state.getCookies());
        if (cookies == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            if (i != 0) {
                buffer.append(";");
            }
            buffer.append(cookies[i].getName());
            buffer.append("=");
            buffer.append(cookies[i].getValue());
        }
        return buffer.toString();
    }

    public void jsxSet_cookie(String newCookie) {
        HttpState state = this.getHtmlPage().getWebClient().getWebConnection().getState();
        Cookie cookie = Document.buildCookie(newCookie, this.getHtmlPage().getWebResponse().getUrl());
        state.addCookie(cookie);
        this.getLog().info((Object)("Added cookie: " + cookie));
    }

    static Cookie buildCookie(String newCookie, URL currentURL) {
        StringTokenizer st = new StringTokenizer(newCookie, ";");
        String nameValue = st.nextToken();
        String name = StringUtils.substringBefore((String)nameValue, (String)"=").trim();
        String value = StringUtils.substringAfter((String)nameValue, (String)"=").trim();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("domain", currentURL.getHost());
        attributes.put("path", "");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexEqual = token.indexOf("=");
            if (indexEqual > -1) {
                attributes.put(token.substring(0, indexEqual).toLowerCase().trim(), token.substring(indexEqual + 1).trim());
                continue;
            }
            attributes.put(token.toLowerCase().trim(), Boolean.TRUE);
        }
        Date expires = null;
        String date = (String)attributes.get("expires");
        if (date != null) {
            try {
                expires = DateUtil.parseDate((String)date);
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        String domain = (String)attributes.get("domain");
        String path = (String)attributes.get("path");
        boolean secure = attributes.get("secure") != null;
        Cookie cookie = new Cookie(domain, name, value, path, expires, secure);
        return cookie;
    }

    public Location jsxGet_location() {
        return this.window_.jsxGet_location();
    }

    public void jsxSet_location(String location) throws IOException {
        this.window_.jsxSet_location(location);
    }

    public Object jsxGet_images() {
        if (this.images_ == null) {
            this.images_ = new HTMLCollection(this);
            try {
                this.images_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath("//img"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.images: " + e.getMessage()));
            }
        }
        return this.images_;
    }

    public String jsxGet_referrer() {
        String referrer = this.getHtmlPage().getWebResponse().getResponseHeaderValue("referrer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    public String jsxGet_URL() {
        return this.getHtmlPage().getWebResponse().getUrl().toExternalForm();
    }

    public HTMLCollection jsxGet_all() {
        if (this.all_ == null) {
            this.all_ = new HTMLCollection(this);
            try {
                this.all_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath("//*"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.all: " + e.getMessage()));
            }
        }
        return this.all_;
    }

    public static Object jsxFunction_open(Context context, Scriptable scriptable, Object[] args, Function function) {
        Document document = (Document)scriptable;
        if (!document.writeInCurrentDocument_) {
            document.getLog().warn((Object)"open() called when document is already open.");
        }
        document.writeInCurrentDocument_ = false;
        return null;
    }

    public void jsxFunction_close() throws IOException {
        if (this.writeInCurrentDocument_) {
            this.getLog().warn((Object)"close() called when document is not open.");
        } else {
            StringWebResponse webResponse = new StringWebResponse(this.writeBuffer_.toString());
            HtmlPage page = this.getDomNodeOrDie().getPage();
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            webClient.loadWebResponseInto(webResponse, window);
            this.writeInCurrentDocument_ = true;
            this.writeBuffer_.setLength(0);
        }
    }

    public SimpleScriptable jsxGet_documentElement() {
        return this.getScriptableFor(((HtmlPage)this.getDomNodeOrDie()).getDocumentHtmlElement());
    }

    public Object jsxGet_defaultView() {
        return this.getWindow();
    }

    public Object jsxGet_parentWindow() {
        return this.getWindow();
    }

    public Object jsxFunction_createElement(String tagName) {
        Object result;
        block8: {
            result = NOT_FOUND;
            try {
                SgmlPage page = (SgmlPage)this.getDomNodeOrDie().getNativePage();
                BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
                if (tagName.startsWith("<") && browserVersion.isIE()) {
                    try {
                        HtmlDivision proxyNode = new HtmlDivision(null, "div", this.getDomNodeOrDie().getPage(), null);
                        HTMLParser.parseFragment(proxyNode, tagName);
                        DomNode resultNode = proxyNode.getFirstDomChild();
                        resultNode.removeAllChildren();
                        result = resultNode.getScriptObject();
                        break block8;
                    }
                    catch (Exception e) {
                        this.getLog().error((Object)"Unexpected exception occurred while parsing html snippet", (Throwable)e);
                        throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing html snippet: " + e.getMessage()));
                    }
                }
                if (tagName.startsWith("<") && tagName.endsWith(">") && browserVersion.isNetscape() && !(tagName = tagName.substring(1, tagName.length() - 1)).matches("\\w+")) {
                    this.getLog().error((Object)"Unexpected exception occurred while parsing html snippet");
                    throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing html snippet: " + tagName));
                }
                DomNamespaceNode element = page instanceof HtmlPage ? ((HtmlPage)page).createHtmlElement(tagName) : ((XmlPage)page).createXmlElement(tagName);
                SimpleScriptable jsElement = this.getScriptableFor(element);
                if (jsElement == NOT_FOUND) {
                    this.getLog().debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a javascript object for the element " + element.getClass().getName()));
                } else {
                    result = jsElement;
                }
            }
            catch (ElementNotFoundException elementNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    public Object jsxFunction_createElementNS(String namespaceURI, String qualifiedName) {
        Object result = NOT_FOUND;
        try {
            HtmlElement htmlElement = this.getDomNodeOrDie().getPage().createHtmlElementNS(namespaceURI, qualifiedName);
            SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("createElementNS(" + namespaceURI + ',' + qualifiedName + ") cannot return a result as there isn't a javascript object for the html element " + htmlElement.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException e) {
            // empty catch block
        }
        return result;
    }

    public Object jsxFunction_createDocumentFragment() {
        DomDocumentFragment fragment = ((SgmlPage)this.getDomNodeOrDie().getNativePage()).createDomDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(((Object)((Object)node)).getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    public Attribute jsxFunction_createAttribute(String attributeName) {
        Attribute att = new Attribute();
        att.setPrototype(this.getPrototype(Attribute.class));
        att.setParentScope(this.getWindow());
        att.init(attributeName, null);
        return att;
    }

    public Stylesheet jsxFunction_createStyleSheet(String url, int index) {
        Stylesheet stylesheet = new Stylesheet();
        stylesheet.setPrototype(this.getPrototype(Stylesheet.class));
        stylesheet.setParentScope(this.getWindow());
        return stylesheet;
    }

    public Object jsxFunction_createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getNativePage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a javascript object for the DOM node " + domNode.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public BoxObject jsxFunction_getBoxObjectFor(HTMLElement element) {
        return element.getBoxObject();
    }

    public Object jsxFunction_getElementById(String id) {
        Object result = null;
        try {
            HtmlElement htmlElement = ((HtmlPage)this.getDomNodeOrDie()).getDocumentHtmlElement().getHtmlElementById(id);
            SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
            if (jsElement == NOT_FOUND) {
                this.getLog().debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a javascript object for the html element " + htmlElement.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException e) {
            BrowserVersion browser = this.getHtmlPage().getWebClient().getBrowserVersion();
            if (browser.isIE()) {
                HTMLCollection elements = (HTMLCollection)((Object)this.jsxFunction_getElementsByName(id));
                result = elements.get(0, (Scriptable)elements);
                if (result instanceof UniqueTag) {
                    return null;
                }
                this.getLog().warn((Object)("getElementById(" + id + ") did a getElementByName for Internet Explorer"));
                return result;
            }
            this.getLog().debug((Object)("getElementById(" + id + "): no DOM node found with this id"));
        }
        return result;
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection = new HTMLCollection(this);
        try {
            String xpath = "//" + tagName.toLowerCase();
            collection.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath(xpath));
        }
        catch (JaxenException e) {
            String msg = "Error initializing collection getElementsByTagName(" + tagName + "): ";
            throw Context.reportRuntimeError((String)(msg + e.getMessage()));
        }
        return collection;
    }

    public Object jsxFunction_getElementsByName(String elementName) {
        HTMLCollection collection = new HTMLCollection(this);
        String exp = "//*[@name='" + elementName + "']";
        try {
            HtmlUnitXPath xpath = new HtmlUnitXPath(exp);
            collection.init(this.getDomNodeOrDie(), (XPath)xpath);
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection document.getElementsByName: " + e.getMessage()));
        }
        return collection;
    }

    protected Object getWithPreemption(String name) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if (page == null) {
            return NOT_FOUND;
        }
        List elements = page.getHtmlElementsByName(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            HtmlElement element = (HtmlElement)elements.get(0);
            String tagName = element.getTagName();
            if ("img".equals(tagName) || "form".equals(tagName)) {
                return this.getScriptableFor(element);
            }
            return NOT_FOUND;
        }
        HTMLCollection collection = new HTMLCollection(this);
        String xpath = "//*[(@name = '" + name + "' and (name() = 'img' or name() = 'form'))]";
        try {
            collection.init(page, (XPath)new HtmlUnitXPath(xpath));
        }
        catch (JaxenException e) {
            String msg = "Failed to initialize collection (using xpath " + xpath + "): " + e.getMessage();
            throw Context.reportRuntimeError((String)msg);
        }
        int size = collection.jsxGet_length();
        if (size == 1) {
            return collection.get(0, (Scriptable)collection);
        }
        if (size > 1) {
            return collection;
        }
        return NOT_FOUND;
    }

    public Object jsxGet_body() {
        List<String> tagNames = Arrays.asList("body", "frameset");
        List list = this.getHtmlPage().getDocumentHtmlElement().getHtmlElementsByTagNames(tagNames);
        if (list.isEmpty()) {
            return NOT_FOUND;
        }
        DomNode bodyElement = (DomNode)list.get(0);
        return this.getScriptableFor(bodyElement);
    }

    public String jsxGet_title() {
        return this.getHtmlPage().getTitleText();
    }

    public void jsxSet_title(String title) {
        this.getHtmlPage().setTitleText(title);
    }

    public String jsxGet_readyState() {
        DomNode node = this.getDomNodeOrDie();
        if (node instanceof HtmlPage) {
            return ((HtmlPage)node).getDocumentHtmlElement().getReadyState();
        }
        return node.getReadyState();
    }

    public String jsxGet_domain() {
        if (this.domain_ == null) {
            this.domain_ = this.getHtmlPage().getWebResponse().getUrl().getHost();
            BrowserVersion browser = this.getHtmlPage().getWebClient().getBrowserVersion();
            if (browser.isNetscape()) {
                this.domain_ = this.domain_.toLowerCase();
            }
        }
        return this.domain_;
    }

    public void jsxSet_domain(String newDomain) {
        String currentDomain = this.jsxGet_domain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(".") == -1 || !currentDomain.toLowerCase().endsWith("." + newDomain.toLowerCase())) {
            throw Context.reportRuntimeError((String)("Illegal domain value, can not set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\""));
        }
        this.domain_ = this.getHtmlPage().getWebClient().getBrowserVersion().isNetscape() ? newDomain.toLowerCase() : newDomain;
    }

    public Object jsxGet_scripts() {
        if (this.scripts_ == null) {
            this.scripts_ = new HTMLCollection(this);
            try {
                this.scripts_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath("//script"));
            }
            catch (JaxenException e) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection document.scripts: " + e.getMessage()));
            }
        }
        return this.scripts_;
    }

    public Object jsxGet_frames() {
        return this.getWindow().jsxGet_frames();
    }

    public DOMImplementation jsxGet_implementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(((Object)((Object)this.implementation_)).getClass()));
        }
        return this.implementation_;
    }

    public Object jsxGet_styleSheets() {
        if (this.styleSheets_ == null) {
            this.styleSheets_ = new StyleSheetList(this);
        }
        return this.styleSheets_;
    }

    public Event jsxFunction_createEvent(String eventType) throws DOMException {
        Class clazz = (Class)SUPPORTED_EVENT_TYPE_MAP.get(eventType);
        if (clazz == null) {
            throw new DOMException(9, "Event Type is not supported: " + eventType);
        }
        try {
            Event event = (Event)((Object)clazz.newInstance());
            event.setEventType(eventType);
            event.setParentScope(this.getWindow());
            event.setPrototype(this.getPrototype(clazz));
            return event;
        }
        catch (InstantiationException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
    }

    public Event jsxFunction_createEventObject() {
        Event event = new Event();
        event.setParentScope(this.getWindow());
        event.setPrototype(this.getPrototype(((Object)((Object)event)).getClass()));
        return event;
    }

    public Object jsxFunction_elementFromPoint(int x, int y) {
        return this.jsxGet_body();
    }

    public Object jsxFunction_createRange() {
        Range r = new Range();
        r.setParentScope(this.getWindow());
        r.setPrototype(this.getPrototype(Range.class));
        return r;
    }

    public XPathNSResolver jsxFunction_createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(((Object)((Object)resolver)).getClass()));
        return resolver;
    }

    public XPathResult jsxFunction_evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)((Object)result);
        try {
            if (xPathResult == null) {
                xPathResult = new XPathResult();
                xPathResult.setPrototype(this.getPrototype(((Object)((Object)xPathResult)).getClass()));
            }
            xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression), type);
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Error using exression: " + expression));
        }
        return xPathResult;
    }

    static {
        HashMap<String, Class> eventMap = new HashMap<String, Class>();
        eventMap.put("Event", Event.class);
        eventMap.put("Events", Event.class);
        eventMap.put("HTMLEvents", Event.class);
        eventMap.put("UIEvent", UIEvent.class);
        eventMap.put("UIEvents", UIEvent.class);
        eventMap.put("MouseEvent", MouseEvent.class);
        eventMap.put("MouseEvents", MouseEvent.class);
        SUPPORTED_EVENT_TYPE_MAP = Collections.unmodifiableMap(eventMap);
    }
}

