/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Function;

class JavaScriptBackgroundJob
implements Runnable {
    private final Window window_;
    private final int timeout_;
    private final String script_;
    private final boolean loopForever_;
    private final Function function_;
    private final String label_;

    private Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    JavaScriptBackgroundJob(Window window, int timeout, String script, boolean loopForever, String label) {
        this.window_ = window;
        this.timeout_ = timeout;
        this.loopForever_ = loopForever;
        this.script_ = script;
        this.function_ = null;
        this.label_ = label;
    }

    JavaScriptBackgroundJob(Window window, int timeout, Function function, boolean loopForever, String label) {
        this.window_ = window;
        this.timeout_ = timeout;
        this.loopForever_ = loopForever;
        this.script_ = null;
        this.function_ = function;
        this.label_ = label;
    }

    public void run() {
        Page page = this.window_.getWebWindow().getEnclosedPage();
        try {
            do {
                Thread.sleep(this.timeout_);
                String message = "Executing JavaScriptBackgroundJob (" + this.label_ + "):";
                message = this.function_ == null ? message + this.script_ : message + "(function reference)";
                this.getLog().debug((Object)message);
                WebWindow webWindow = this.window_.getWebWindow();
                if (!webWindow.getWebClient().getWebWindows().contains(webWindow) || webWindow.getEnclosedPage() != page) {
                    this.getLog().debug((Object)"the page that originated this job doesnt exist anymore. Execution cancelled.");
                    return;
                }
                HtmlPage htmlPage = (HtmlPage)this.window_.getWebWindow().getEnclosedPage();
                if (this.function_ == null) {
                    htmlPage.executeJavaScriptIfPossible(this.script_, "JavaScriptBackgroundJob", 1);
                } else {
                    htmlPage.executeJavaScriptFunctionIfPossible(this.function_, this.window_, new Object[0], htmlPage.getDocumentHtmlElement());
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                this.getLog().debug((Object)("JavaScript " + this.label_ + " thread interrupted; clearTimeout() probably called."));
                break;
            } while (this.loopForever_);
        }
        catch (InterruptedException e) {
            this.getLog().debug((Object)"JavaScript timeout thread interrupted; clearTimeout() probably called.");
        }
        catch (Exception e) {
            this.getLog().error((Object)"Caught exception in Window.setTimeout()", (Throwable)e);
        }
    }
}

