/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;

public class Node
extends SimpleScriptable {
    private HTMLCollection childNodes_;
    private static final long serialVersionUID = -5695262053081637445L;
    private EventListenersContainer eventListenersContainer_;
    public static final short ELEMENT_NODE = 1;
    public static final short ATTRIBUTE_NODE = 2;
    public static final short TEXT_NODE = 3;
    public static final short CDATA_SECTION_NODE = 4;
    public static final short ENTITY_REFERENCE_NODE = 5;
    public static final short ENTITY_NODE = 6;
    public static final short PROCESSING_INSTRUCTION_NODE = 7;
    public static final short COMMENT_NODE = 8;
    public static final short DOCUMENT_NODE = 9;
    public static final short DOCUMENT_TYPE_NODE = 10;
    public static final short DOCUMENT_FRAGMENT_NODE = 11;
    public static final short NOTATION_NODE = 12;

    public short jsxGet_nodeType() {
        return this.getDomNodeOrDie().getNodeType();
    }

    public String jsxGet_nodeName() {
        DomNode domNode = this.getDomNodeOrDie();
        String nodeName = domNode.getNodeName();
        if (domNode instanceof HtmlElement && ((HtmlElement)domNode).getNamespaceURI() == null) {
            nodeName = nodeName.toUpperCase();
        }
        return nodeName;
    }

    public String jsxGet_nodeValue() {
        return this.getDomNodeOrDie().getNodeValue();
    }

    public void jsxSet_nodeValue(String newValue) {
        this.getDomNodeOrDie().setNodeValue(newValue);
    }

    public Object jsxFunction_appendChild(Object childObject) {
        Object appendedChild = null;
        if (childObject instanceof Node) {
            DomNode childDomNode = ((Node)((Object)childObject)).getDomNodeOrDie();
            DomNode parentNode = this.getDomNodeOrDie();
            parentNode.appendDomChild(childDomNode);
            appendedChild = childObject;
            if (!(this instanceof DocumentFragment) && parentNode.getParentDomNode() == null && this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) {
                DomDocumentFragment fragment = ((SgmlPage)parentNode.getNativePage()).createDomDocumentFragment();
                fragment.appendDomChild(parentNode);
            }
        }
        return appendedChild;
    }

    public Object jsxFunction_cloneNode(boolean deep) {
        DomNode domNode = this.getDomNodeOrDie();
        DomNode clonedNode = domNode.cloneDomNode(deep);
        return this.getJavaScriptNode(clonedNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object jsxFunction_insertBefore(Object newChildObject, Object refChildObject) {
        DomNode refChildNode;
        Object appendedChild = null;
        if (!(newChildObject instanceof Node)) return appendedChild;
        DomNode newChildNode = ((Node)((Object)newChildObject)).getDomNodeOrDie();
        if (Context.getUndefinedValue().equals(refChildObject)) {
            if (!this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) throw Context.reportRuntimeError((String)"insertBefore: not enough arguments");
            refChildNode = null;
        } else {
            refChildNode = refChildObject != null ? ((Node)((Object)refChildObject)).getDomNodeOrDie() : null;
        }
        if (refChildNode != null) {
            refChildNode.insertBefore(newChildNode);
            appendedChild = newChildObject;
        } else {
            this.getDomNodeOrDie().appendDomChild(newChildNode);
        }
        if (this.getDomNodeOrDie().getParentDomNode() != null || !this.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE()) return appendedChild;
        DomDocumentFragment fragment = this.getDomNodeOrDie().getPage().createDomDocumentFragment();
        fragment.appendDomChild(this.getDomNodeOrDie());
        return appendedChild;
    }

    public boolean jsxFunction_isSameNode(Object other) {
        return other == this;
    }

    public Object jsxFunction_removeChild(Object childObject) {
        Object removedChild = null;
        if (childObject instanceof Node) {
            DomNode childNode = ((Node)((Object)childObject)).getDomNodeOrDie();
            childNode.remove();
            removedChild = childObject;
        }
        return removedChild;
    }

    public boolean jsxFunction_hasChildNodes() {
        return this.getDomNodeOrDie().getChildIterator().hasNext();
    }

    public Object jsxGet_childNodes() {
        if (this.childNodes_ == null) {
            this.childNodes_ = new HTMLCollection(this);
            try {
                this.childNodes_.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath("(./* | text() | comment())"));
            }
            catch (JaxenException je) {
                throw Context.reportRuntimeError((String)("Failed to initialize collection element.childNodes: " + je.getMessage()));
            }
        }
        return this.childNodes_;
    }

    public Object jsxFunction_replaceChild(Object newChildObject, Object oldChildObject) {
        Object removedChild = null;
        if (newChildObject instanceof Node && oldChildObject instanceof Node) {
            DomNode newChildNode = ((Node)((Object)newChildObject)).getDomNodeOrDie();
            if (oldChildObject != null) {
                DomNode oldChildNode = ((Node)((Object)oldChildObject)).getDomNodeOrDie();
                oldChildNode.replace(newChildNode);
                removedChild = oldChildObject;
            }
        }
        return removedChild;
    }

    public Object jsxGet_parentNode() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getParentDomNode());
    }

    public Object jsxGet_nextSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getNextDomSibling());
    }

    public Object jsxGet_previousSibling() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getPreviousDomSibling());
    }

    public Object jsxGet_firstChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getFirstDomChild());
    }

    public Object jsxGet_lastChild() {
        return this.getJavaScriptNode(this.getDomNodeOrDie().getLastDomChild());
    }

    protected Object getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return this.getScriptableFor(domNode);
    }

    public boolean jsxFunction_attachEvent(String type, Function listener) {
        return this.getEventListenersContainer().addEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_addEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    private EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public void jsxFunction_detachEvent(String type, Function listener) {
        this.jsxFunction_removeEventListener(StringUtils.substring((String)type, (int)2), listener, false);
    }

    public void jsxFunction_removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult executeEvent(Event event) {
        if (this.eventListenersContainer_ != null) {
            HtmlPage page = this.getDomNodeOrDie().getPage();
            boolean isIE = page.getWebClient().getBrowserVersion().isIE();
            Window window = (Window)page.getEnclosingWindow().getScriptObject();
            Object[] args = new Object[]{event};
            if (isIE) {
                window.setEvent((Object)event);
            }
            Object[] propHandlerArgs = isIE ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            try {
                ScriptResult scriptResult = this.eventListenersContainer_.executeListeners(event, args, propHandlerArgs);
                return scriptResult;
            }
            finally {
                window.setEvent(null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult fireEvent(Event event) {
        HtmlPage page = this.getDomNodeOrDie().getPage();
        boolean isIE = page.getWebClient().getBrowserVersion().isIE();
        Window window = (Window)page.getEnclosingWindow().getScriptObject();
        Object[] args = new Object[]{event};
        event.startFire();
        ScriptResult result = null;
        if (isIE) {
            window.setEvent((Object)event);
        }
        try {
            DomNode node;
            EventListenersContainer windowsListeners = this.getWindow().getEventListenersContainer();
            event.setEventPhase((short)1);
            result = windowsListeners.executeCapturingListeners(event, args);
            if (event.isPropagationStopped()) {
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            ArrayList<DomNode> parents = new ArrayList<DomNode>();
            for (node = this.getDomNodeOrDie(); node != null; node = node.getParentDomNode()) {
                parents.add(node);
            }
            for (int i = parents.size() - 1; i >= 0; --i) {
                DomNode curNode = (DomNode)parents.get(i);
                Node jsNode = (Node)curNode.getScriptObject();
                if (jsNode.eventListenersContainer_ == null) continue;
                result = this.defaultResult(jsNode.eventListenersContainer_.executeCapturingListeners(event, args), result);
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            Object[] propHandlerArgs = isIE ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            event.setEventPhase((short)2);
            for (node = this.getDomNodeOrDie(); node != null; node = node.getParentDomNode()) {
                Node jsNode = (Node)node.getScriptObject();
                if (jsNode.eventListenersContainer_ != null) {
                    result = this.defaultResult(jsNode.eventListenersContainer_.executeBubblingListeners(event, args, propHandlerArgs), result);
                    if (event.isPropagationStopped()) {
                        ScriptResult scriptResult = result;
                        return scriptResult;
                    }
                }
                event.setEventPhase((short)3);
            }
            result = this.defaultResult(windowsListeners.executeBubblingListeners(event, args, propHandlerArgs), result);
        }
        finally {
            event.endFire();
            window.setEvent(null);
        }
        return result;
    }

    private ScriptResult defaultResult(ScriptResult newResult, ScriptResult defaultResult) {
        if (newResult != null) {
            return newResult;
        }
        return defaultResult;
    }

    public Function getEventHandler(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandler(StringUtils.substring((String)eventName, (int)2));
    }

    public void setEventHandler(String eventName, Function eventHandler) {
        this.setEventHandlerProp(eventName, eventHandler);
    }

    protected void setEventHandlerProp(String eventName, Object value) {
        this.getEventListenersContainer().setEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2), value);
    }

    protected Object getEventHandlerProp(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2));
    }
}

