/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Assert;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class Style
extends SimpleScriptable
implements Cloneable {
    public static final short WRITE_MODE_UPDATE_ELEMENT = 0;
    public static final short WRITE_MODE_DO_NOT_UPDATE_ELEMENT = 1;
    public static final short WRITE_MODE_NOT_WRITEABLE = 2;
    private static final long serialVersionUID = -1976370264911039311L;
    private static final MessageFormat URL_FORMAT = new MessageFormat("url({0})");
    private HTMLElement jsElement_;
    private short writeMode_ = 0;
    private Map localModifications_ = new HashMap();
    private static final String[] STYLE_PROPERTIES = new String[]{"backgroundColor", "backgroundImage", "borderBottom", "borderBottomColor", "borderBottomStyle", "borderBottomWidth", "borderLeft", "borderLeftColor", "borderLeftStyle", "borderLeftWidth", "borderRight", "borderRightColor", "borderRightStyle", "borderRightWidth", "borderTop", "borderTopColor", "borderTopStyle", "borderTopWidth", "bottom", "clear", "clip", "color", "direction", "display", "font", "fontFamily", "fontSize", "fontStyle", "fontWeight", "fontWeight", "hasLayout", "height", "layoutFlow", "layoutGrid", "layoutGridMode", "left", "letterSpacing", "lineHeight", "maxHeight", "maxWidth", "minHeight", "minWidth", "padding", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "pixelBottom", "pixelHeight", "pixelLeft", "pixelRight", "pixelTop", "pixelWidth", "posBottom", "posHeight", "position", "posLeft", "posRight", "posTop", "posWidth", "right", "styleFloat", "textAutospace", "textDecoration", "textDecorationBlink", "textDecorationLineThrough", "textDecorationNone", "textDecorationOverline", "textDecorationUnderline", "textTransform", "textUnderlinePosition", "top", "unicodeBidi", "visibility", "width", "wordSpacing", "wordWrap", "zoom"};
    private static final Set STYLE_ALLOWED_PROPERTIES;

    public Style() {
    }

    Style(HTMLElement htmlElement) {
        this.setParentScope(htmlElement.getParentScope());
        this.setPrototype(this.getPrototype(Style.class));
        this.initialize(htmlElement);
    }

    void initialize(HTMLElement htmlElement) {
        Assert.notNull("htmlElement", htmlElement);
        this.jsElement_ = htmlElement;
        this.setDomNode(htmlElement.getDomNodeOrNull(), false);
        if (htmlElement.getDomNodeOrDie().getPage().getWebClient().getBrowserVersion().isIE()) {
            Iterator i = this.getStyleMap(true).entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (!"behavior".equals(key)) continue;
                String value = (String)entry.getValue();
                try {
                    Object[] url = URL_FORMAT.parse(value);
                    if (url.length <= 0) continue;
                    this.jsElement_.jsxFunction_addBehavior((String)url[0]);
                    break;
                }
                catch (ParseException e) {
                    this.getLog().warn((Object)("Invalid behavior: '" + value + "'."));
                }
            }
        }
    }

    Style createClone() {
        try {
            return (Style)this.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    void setWriteMode(short writeMode) {
        this.writeMode_ = writeMode;
    }

    protected Object getWithPreemption(String name) {
        if (STYLE_ALLOWED_PROPERTIES.contains(name)) {
            return this.getStyleAttribute(name, true);
        }
        return super.getWithPreemption(name);
    }

    protected String getStyleAttribute(String name, boolean camelCase) {
        String value = (String)this.getStyleMap(camelCase).get(name);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void put(String name, Scriptable start, Object newValue) {
        if (this.jsElement_ == null || !STYLE_ALLOWED_PROPERTIES.contains(name)) {
            super.put(name, start, newValue);
            return;
        }
        String styleValue = (String)Context.jsToJava((Object)newValue, (Class)String.class);
        this.setStyleAttribute(name, styleValue);
    }

    protected void setStyleAttribute(String name, String newValue) {
        if (this.writeMode_ == 0) {
            SortedMap styleMap = this.getStyleMap(true);
            styleMap.put(name, newValue);
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = styleMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                buffer.append(" ");
                buffer.append(entry.getKey());
                buffer.append(": ");
                buffer.append(entry.getValue());
                buffer.append(";");
            }
            buffer.deleteCharAt(0);
            this.jsElement_.getHtmlElementOrDie().setAttributeValue("style", buffer.toString());
        } else if (this.writeMode_ == 1) {
            this.localModifications_.put(name, newValue);
        }
    }

    private SortedMap getStyleMap(boolean camelCase) {
        String value;
        String key;
        TreeMap<String, String> styleMap = new TreeMap<String, String>();
        String styleAttribute = this.jsElement_.getHtmlElementOrDie().getAttributeValue("style");
        StringTokenizer tokenizer = new StringTokenizer(styleAttribute, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(":");
            if (index == -1) continue;
            key = token.substring(0, index).trim();
            if (!camelCase) {
                key = key.replaceAll("([A-Z])", "-$1").toLowerCase();
            }
            value = token.substring(index + 1).trim();
            styleMap.put(key, value);
        }
        Iterator i = this.localModifications_.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            key = (String)entry.getKey();
            if (!camelCase) {
                key = key.replaceAll("([A-Z])", "-$1").toLowerCase();
            }
            value = (String)entry.getValue();
            styleMap.put(key, value);
        }
        return styleMap;
    }

    public String jsxGet_behavior() {
        return this.getStyleAttribute("behavior", true);
    }

    public void jsxSet_behavior(String behavior) {
        this.setStyleAttribute("behavior", behavior);
    }

    public String jsxGet_filter() {
        return this.getStyleAttribute("filter", true);
    }

    public void jsxSet_filter(String filter) {
        this.setStyleAttribute("filter", filter);
    }

    public String jsxFunction_getPropertyValue(String name) {
        return this.getStyleAttribute(name, false);
    }

    public void jsxFunction_setExpression(String propertyName, String expression, String language) {
    }

    public boolean jsxFunction_removeExpression(String propertyName) {
        return true;
    }

    static {
        HashSet set = new HashSet();
        CollectionUtils.addAll(set, (Object[])STYLE_PROPERTIES);
        STYLE_ALLOWED_PROPERTIES = Collections.unmodifiableSet(set);
    }
}

