/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomCData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.javascript.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.TextImpl;
import com.gargoylesoftware.htmlunit.javascript.host.XMLAttribute;
import com.gargoylesoftware.htmlunit.javascript.host.XMLDOMParseError;
import com.gargoylesoftware.htmlunit.javascript.host.XMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlAttr;
import com.gargoylesoftware.htmlunit.xml.XmlElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.util.ArrayList;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class XMLDocument
extends Document {
    private static final long serialVersionUID = 1225601711396578064L;
    private boolean async_ = true;
    private boolean preserveWhiteSpace_;
    private XMLDOMParseError parseError_;

    public XMLDocument() {
        this(null);
    }

    XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("IOException: " + e));
            }
        }
    }

    public void jsxSet_async(boolean async) {
        this.async_ = async;
    }

    public boolean jsxGet_async() {
        return this.async_;
    }

    public boolean jsxFunction_load(String xmlSrouce) {
        if (this.async_) {
            this.getLog().debug((Object)"XMLDocument.load(): 'async' is true, currently treated as false.");
        }
        try {
            HtmlPage htmlPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
            WebRequestSettings settings = new WebRequestSettings(htmlPage.getFullyQualifiedUrl(xmlSrouce));
            WebResponse webResponse = this.getWindow().getWebWindow().getWebClient().loadWebResponse(settings);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow(), false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            XMLDOMParseError parseError = this.jsxGet_parseError();
            parseError.setErrorCode(-1);
            parseError.setFilepos(1);
            parseError.setLine(1);
            parseError.setLinepos(1);
            parseError.setReason(e.getMessage());
            parseError.setSrcText("xml");
            parseError.setUrl(xmlSrouce);
            this.getLog().debug((Object)("Error parsing XML from '" + xmlSrouce + "'"), (Throwable)e);
            return false;
        }
    }

    public boolean jsxFunction_loadXML(String strXML) {
        try {
            WebResponseData data = new WebResponseData(strXML.getBytes(), 200, null, new ArrayList());
            WebResponseImpl webResponse = new WebResponseImpl(data, null, null, 0L);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow());
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            this.getLog().debug((Object)("Error parsing XML\n" + strXML), (Throwable)e);
            return false;
        }
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        if (domNode instanceof XmlElement) {
            scriptable = new XMLElement();
        } else if (domNode instanceof XmlAttr) {
            XMLAttribute attribute = new XMLAttribute();
            attribute.init(domNode.getNodeName(), (XmlElement)domNode.getParentDomNode());
            scriptable = attribute;
        } else if (domNode instanceof DomText || domNode instanceof DomCData || domNode instanceof DomComment) {
            scriptable = new TextImpl();
        } else {
            throw new IllegalArgumentException("Can not make scriptable for " + domNode);
        }
        scriptable.setPrototype(this.getPrototype(((Object)((Object)scriptable)).getClass()));
        scriptable.setParentScope(this.getParentScope());
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    public SimpleScriptable jsxGet_documentElement() {
        XmlElement documentElement = ((XmlPage)this.getDomNodeOrDie()).getDocumentXmlElement();
        if (documentElement == null) {
            return null;
        }
        return this.getScriptableFor(documentElement);
    }

    public XMLDOMParseError jsxGet_parseError() {
        if (this.parseError_ == null) {
            this.parseError_ = new XMLDOMParseError();
            this.parseError_.setPrototype(this.getPrototype(((Object)((Object)this.parseError_)).getClass()));
            this.parseError_.setParentScope(this.getParentScope());
        }
        return this.parseError_;
    }

    public String jsxGet_xml() {
        XMLSerializer seralizer = new XMLSerializer();
        seralizer.setParentScope(this.getWindow());
        seralizer.setPrototype(this.getPrototype(((Object)((Object)seralizer)).getClass()));
        return seralizer.jsxFunction_serializeToString((Node)this.jsxGet_documentElement());
    }

    public boolean jsxGet_preserveWhiteSpace() {
        return this.preserveWhiteSpace_;
    }

    public void jsxSet_preserveWhiteSpace(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    public void jsxFunction_setProperty(String name, String value) {
    }

    public HTMLCollection jsxFunction_selectNodes(String expression) {
        HTMLCollection collection = new HTMLCollection(this);
        try {
            collection.init(this.getDomNodeOrDie(), (XPath)new HtmlUnitXPath(expression));
        }
        catch (JaxenException e) {
            throw Context.reportRuntimeError((String)("Failed to initialize collection 'selectNodes': " + e.getMessage()));
        }
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public Object jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection = new HTMLCollection(this);
        try {
            String xpath = "//" + tagName;
            collection.init(this.getDomNodeOrDie().getFirstDomChild(), (XPath)new HtmlUnitXPath(xpath));
        }
        catch (JaxenException e) {
            String msg = "Error initializing collection getElementsByTagName(" + tagName + "): ";
            throw Context.reportRuntimeError((String)(msg + e.getMessage()));
        }
        return collection;
    }

    public Object jsxGet_body() {
        return NOT_FOUND;
    }

    public Object jsxFunction_getElementById(String id) {
        return null;
    }
}

