/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebuggingWebConnection
extends WebConnectionWrapper {
    private static final Log LOG = LogFactory.getLog((Class)DebuggingWebConnection.class);
    private int counter_;
    private final WebConnection wrappedWebConnection_;
    private final String reportBaseName_;
    private final File javaScriptFile_;

    public DebuggingWebConnection(WebConnection webConnection, String reportBaseName) throws IOException {
        super(webConnection);
        this.wrappedWebConnection_ = webConnection;
        this.reportBaseName_ = reportBaseName;
        this.javaScriptFile_ = File.createTempFile(this.reportBaseName_, ".js");
        this.createOverview();
    }

    public WebResponse getResponse(WebRequestSettings webRequestSettings) throws IOException {
        WebResponse response = this.wrappedWebConnection_.getResponse(webRequestSettings);
        this.saveResponse(response, webRequestSettings);
        return response;
    }

    protected void saveResponse(WebResponse response, WebRequestSettings settings) throws IOException {
        ++this.counter_;
        String extension = "application/x-javascript".equals(response.getContentType()) ? ".js" : ("text/html".equals(response.getContentType()) ? ".html" : ".txt");
        File f = File.createTempFile(this.reportBaseName_ + this.counter_ + "-", extension);
        String content = response.getContentAsString();
        FileUtils.writeStringToFile((File)f, (String)content, (String)response.getContentCharSet());
        LOG.info((Object)("Created file " + f.getAbsolutePath() + " for response " + this.counter_ + ": " + response.getUrl()));
        StringBuffer buffer = new StringBuffer();
        buffer.append("tab[tab.length] = {code: " + response.getStatusCode() + ", ");
        buffer.append("fileName: '" + f.getName() + "', ");
        buffer.append("contentType: '" + response.getContentType() + "', ");
        buffer.append("method: '" + settings.getSubmitMethod().getName() + "', ");
        buffer.append("url: '" + response.getUrl() + "', ");
        buffer.append("headers: " + DebuggingWebConnection.nameValueListToJsMap(response.getResponseHeaders()));
        buffer.append("};\n");
        FileWriter jsFileWriter = new FileWriter(this.javaScriptFile_, true);
        jsFileWriter.write(buffer.toString());
        jsFileWriter.close();
    }

    static String nameValueListToJsMap(List headers) {
        if (headers == null || headers.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer("{");
        Iterator iter = headers.iterator();
        while (iter.hasNext()) {
            NameValuePair header = (NameValuePair)iter.next();
            buffer.append("'" + header.getName() + "': '" + header.getValue().replaceAll("'", "\\'") + "', ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        buffer.append("}");
        return buffer.toString();
    }

    private void createOverview() throws IOException {
        FileUtils.writeStringToFile((File)this.javaScriptFile_, (String)"var tab = [];\n", (String)"ISO-8859-1");
        File summary = new File(this.javaScriptFile_.getParentFile(), this.reportBaseName_ + ".html");
        String content = "<html><head><title>Summary for " + this.reportBaseName_ + "</title>\n" + "<h1>Received responses</h1>\n" + "<script src='" + this.javaScriptFile_.getName() + "' type='text/javascript'></script>\n" + "</head>\n" + "<body>" + "<ol>\n" + "<script>\n" + "for (var i=0; i<tab.length; i++) {\n" + "  var curRes = tab[i];\n" + "  document.writeln('<li>'" + " + curRes.code + ' ' + curRes.method + ' ' " + " + '<a href=\"' + curRes.fileName + '\" target=_blank>' + curRes.url + '</a> " + " (' + curRes.contentType + ')</li>');\n" + "}\n" + "</script>\n" + "</ol>" + "</body></html>";
        FileUtils.writeStringToFile((File)summary, (String)content, (String)"ISO-8859-1");
        LOG.info((Object)("Summary will be in " + summary.getAbsolutePath()));
    }
}

