/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSLTProcessor
extends SimpleScriptable {
    private Node style_;
    private Node input_;
    private Object output_;
    private Map<String, Object> parameters_ = new HashMap<String, Object>();

    public void jsConstructor() {
    }

    public void jsxFunction_importStylesheet(Node style) {
        this.style_ = style;
    }

    public XMLDocument jsxFunction_transformToDocument(Node source) {
        org.w3c.dom.Node node;
        XMLDocument doc = new XMLDocument();
        doc.setPrototype(this.getPrototype(doc.getClass()));
        doc.setParentScope(this.getParentScope());
        Object transformResult = this.transform(source);
        if (transformResult instanceof org.w3c.dom.Node) {
            org.w3c.dom.Node transformedDoc = (org.w3c.dom.Node)transformResult;
            node = transformedDoc.getFirstChild();
        } else {
            node = null;
        }
        XmlPage page = new XmlPage(node, this.getWindow().getWebWindow());
        doc.setDomNode(page);
        return doc;
    }

    private Object transform(Node source) {
        try {
            DOMSource xmlSource = new DOMSource((org.w3c.dom.Node)source.getDomNodeOrDie());
            DOMSource xsltSource = new DOMSource((org.w3c.dom.Node)this.style_.getDomNodeOrDie());
            org.w3c.dom.Document containerDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element containerElement = containerDocument.createElement("container");
            containerDocument.appendChild(containerElement);
            DOMResult result = new DOMResult(containerElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            for (Map.Entry<String, Object> entry : this.parameters_.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            transformer.transform(xmlSource, result);
            org.w3c.dom.Node transformedNode = result.getNode();
            if (transformedNode.getFirstChild().getNodeType() == 1) {
                return transformedNode;
            }
            xmlSource = new DOMSource((org.w3c.dom.Node)source.getDomNodeOrDie());
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(xmlSource, streamResult);
            return writer.toString();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
    }

    public DocumentFragment jsxFunction_transformToFragment(Node source, Object output) {
        SgmlPage page = (SgmlPage)((Document)output).getDomNodeOrDie();
        DomDocumentFragment fragment = page.createDomDocumentFragment();
        DocumentFragment rv = new DocumentFragment();
        rv.setPrototype(this.getPrototype(rv.getClass()));
        rv.setParentScope(this.getParentScope());
        rv.setDomNode(fragment);
        this.transform(source, fragment);
        return rv;
    }

    private void transform(Node source, DomNode parent) {
        Object result = this.transform(source);
        if (result instanceof org.w3c.dom.Node) {
            SgmlPage parentPage = parent.getPage();
            NodeList children = ((org.w3c.dom.Node)result).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XmlUtil.appendChild(parentPage, parent, children.item(i));
            }
        } else {
            DomText text = new DomText(parent.getPage(), (String)result);
            parent.appendChild(text);
        }
    }

    public void jsxFunction_setParameter(String namespaceURI, String localName, Object value) {
        this.parameters_.put(this.getQualifiedName(namespaceURI, localName), value);
    }

    public Object jsxFunction_getParameter(String namespaceURI, String localName) {
        return this.parameters_.get(this.getQualifiedName(namespaceURI, localName));
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String qualifiedName = namespaceURI != null && namespaceURI.length() != 0 && !"null".equals(namespaceURI) ? '{' + namespaceURI + '}' + localName : localName;
        return qualifiedName;
    }

    public void jsxSet_input(Node input) {
        this.input_ = input;
    }

    public Node jsxGet_input() {
        return this.input_;
    }

    public void jsxSet_output(Object output) {
        this.output_ = output;
    }

    public Object jsxGet_output() {
        return this.output_;
    }

    public void jsxFunction_addParameter(String baseName, Object parameter, Object namespaceURI) {
        String nsString = namespaceURI instanceof String ? (String)namespaceURI : null;
        this.jsxFunction_setParameter(nsString, baseName, parameter);
    }

    public void jsxFunction_transform() {
        Node input = this.input_;
        SgmlPage page = ((DomNode)input.getDomNodeOrDie()).getPage();
        if (this.output_ == null || !(this.output_ instanceof Node)) {
            DomDocumentFragment fragment = page.createDomDocumentFragment();
            DocumentFragment node = new DocumentFragment();
            node.setParentScope(this.getParentScope());
            node.setPrototype(this.getPrototype(node.getClass()));
            node.setDomNode(fragment);
            this.output_ = fragment.getScriptObject();
        }
        this.transform(this.input_, (DomNode)((Node)this.output_).getDomNodeOrDie());
        XMLSerializer serializer = new XMLSerializer();
        serializer.setParentScope(this.getParentScope());
        StringBuilder output = new StringBuilder();
        for (DomNode child : ((DomNode)((Node)this.output_).getDomNodeOrDie()).getChildren()) {
            if (child instanceof DomText) {
                if (!StringUtils.isNotBlank((CharSequence)((DomText)child).getData())) continue;
                output.append(((DomText)child).getData());
                continue;
            }
            String serializedString = serializer.jsxFunction_serializeToString((Node)child.getScriptObject());
            output.append(serializedString.substring(0, serializedString.length() - 2));
        }
        this.output_ = output.toString();
    }
}

