/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.XPathResult;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DocumentType;

@JsxClass
public class Document
extends EventNode {
    private static final Log LOG = LogFactory.getLog(Document.class);
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("\\w+");
    private Window window_;
    private DOMImplementation implementation_;
    private String designMode_;

    public void setWindow(Window window) {
        this.window_ = window;
    }

    @JsxGetter
    public Location getLocation() {
        return this.window_.getLocation();
    }

    @JsxSetter
    public void setLocation(String location) throws IOException {
        this.window_.setLocation(location);
    }

    @JsxGetter
    public String getReferrer() {
        String referrer = this.getPage().getWebResponse().getWebRequest().getAdditionalHeaders().get("Referer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    @JsxGetter
    public Element getDocumentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (Element)this.getScriptableFor(documentElement);
    }

    @JsxGetter
    public SimpleScriptable getDoctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return this.getScriptableFor(documentType);
    }

    @JsxGetter
    public String getDesignMode() {
        if (this.designMode_ == null) {
            this.designMode_ = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_30) ? (this.getWindow().getWebWindow() instanceof FrameWindow ? "Inherit" : "Off") : "off";
        }
        return this.designMode_;
    }

    @JsxSetter
    public void setDesignMode(String mode) {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_31);
        if (ie) {
            if (!("on".equalsIgnoreCase(mode) || "off".equalsIgnoreCase(mode) || "inherit".equalsIgnoreCase(mode))) {
                throw Context.reportRuntimeError((String)("Invalid document.designMode value '" + mode + "'."));
            }
            if (!(this.getWindow().getWebWindow() instanceof FrameWindow)) {
                return;
            }
            if ("on".equalsIgnoreCase(mode)) {
                this.designMode_ = "On";
            } else if ("off".equalsIgnoreCase(mode)) {
                this.designMode_ = "Off";
            } else if ("inherit".equalsIgnoreCase(mode)) {
                this.designMode_ = "Inherit";
            }
        } else if ("on".equalsIgnoreCase(mode)) {
            this.designMode_ = "on";
            SgmlPage page = this.getPage();
            if (page instanceof HtmlPage) {
                HtmlPage htmlPage = (HtmlPage)page;
                DomNode child = htmlPage.getBody().getFirstChild();
                DomNode rangeNode = child == null ? htmlPage.getBody() : child;
                htmlPage.setSelectionRange(new SimpleRange(rangeNode, 0));
            }
        } else if ("off".equalsIgnoreCase(mode)) {
            this.designMode_ = "off";
        }
    }

    protected SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getDefaultView() {
        return this.getWindow();
    }

    @JsxFunction
    public Object createDocumentFragment() {
        DomDocumentFragment fragment = ((DomNode)this.getDomNodeOrDie()).getPage().createDomDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    @JsxFunction
    public Attr createAttribute(String attributeName) {
        return (Attr)this.getPage().createAttribute(attributeName).getScriptObject();
    }

    public BoxObject getBoxObjectFor(HTMLElement element) {
        return element.getBoxObject();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public Object importNode(Node importedNode, boolean deep) {
        Object domNode = importedNode.getDomNodeOrDie();
        domNode = ((DomNode)domNode).cloneNode(deep);
        ((DomNode)domNode).processImportNode(this);
        for (DomNode childNode : ((DomNode)domNode).getDescendants()) {
            childNode.processImportNode(this);
        }
        return ((DomNode)domNode).getScriptObject();
    }

    @JsxGetter
    public DOMImplementation getImplementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void captureEvents(String type) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public Object createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(((DomNode)this.getDomNodeOrDie()).getPage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction
    public Object createComment(String comment) {
        DomComment domNode = new DomComment(((DomNode)this.getDomNodeOrDie()).getPage(), comment);
        return this.getScriptableFor(domNode);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public XPathResult evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        xPathResult.init(((DomNode)contextNode.getDomNodeOrDie()).getByXPath(expression), type);
        return xPathResult;
    }

    @JsxFunction
    public Object createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            SimpleScriptable jsElement;
            Matcher matcher;
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_CREATE_ELEMENT_EXTENDED_SYNTAX) && tagName.startsWith("<") && tagName.endsWith(">") && !(matcher = TAG_NAME_PATTERN.matcher(tagName = tagName.substring(1, tagName.length() - 1))).matches()) {
                LOG.info((Object)"createElement: String contains an invalid character: ");
                throw Context.reportRuntimeError((String)"String contains an invalid character");
            }
            SgmlPage page = this.getPage();
            org.w3c.dom.Element element = page.createElement(tagName);
            if (element instanceof BaseFrameElement) {
                ((BaseFrameElement)element).markAsCreatedByJavascript();
            }
            if ((jsElement = this.getScriptableFor(element)) == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName()));
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Object createElementNS(String namespaceURI, String qualifiedName) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        org.w3c.dom.Element element = browserVersion.hasFeature(BrowserVersionFeatures.XUL_SUPPORT) && "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI) ? new HtmlDivision(namespaceURI, qualifiedName, this.getPage(), null) : ("http://www.w3.org/1999/xhtml".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null));
        return this.getScriptableFor(element);
    }

    @JsxFunction
    public HTMLCollection getElementsByTagName(String tagName) {
        HTMLCollection collection;
        String description = "Document.getElementsByTagName('" + tagName + "')";
        if ("*".equals(tagName)) {
            collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, description){

                @Override
                protected boolean isMatching(DomNode node) {
                    return true;
                }
            };
        } else {
            final boolean useLocalName = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_32);
            final String tagNameLC = tagName.toLowerCase();
            collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, description){

                @Override
                protected boolean isMatching(DomNode node) {
                    if (useLocalName) {
                        return tagNameLC.equalsIgnoreCase(node.getLocalName());
                    }
                    return tagNameLC.equalsIgnoreCase(node.getNodeName());
                }
            };
        }
        return collection;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public Object getElementsByTagNameNS(Object namespaceURI, final String localName) {
        String description = "Document.getElementsByTagNameNS('" + namespaceURI + "', '" + localName + "')";
        final String prefix = namespaceURI != null && !"*".equals(namespaceURI) ? XmlUtil.lookupPrefix(this.getPage().getDocumentElement(), Context.toString((Object)namespaceURI)) : null;
        HTMLCollection collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, description){

            @Override
            protected boolean isMatching(DomNode node) {
                if (!localName.equals(node.getLocalName())) {
                    return false;
                }
                if (prefix == null) {
                    return true;
                }
                return true;
            }
        };
        return collection;
    }
}

