/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;

public class HtmlForm
extends HtmlElement {
    public static final String TAG_NAME = "form";
    private static final Collection<String> SUBMITTABLE_ELEMENT_NAMES = Arrays.asList("input", "button", "select", "textarea", "isindex");
    private static final Pattern SUBMIT_CHARSET_PATTERN = Pattern.compile("[ ,].*");
    private final List<HtmlElement> lostChildren_ = new ArrayList<HtmlElement>();
    private boolean isPreventDefault_;

    HtmlForm(String namespaceURI, String qualifiedName, SgmlPage htmlPage, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, htmlPage, attributes);
    }

    Page submit(SubmittableElement submitElement) {
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        WebClient webClient = htmlPage.getWebClient();
        if (webClient.getOptions().isJavaScriptEnabled()) {
            String action;
            if (submitElement != null) {
                this.isPreventDefault_ = false;
                ScriptResult scriptResult = this.fireEvent("submit");
                if (this.isPreventDefault_) {
                    if (scriptResult == null) {
                        return htmlPage;
                    }
                    return scriptResult.getNewPage();
                }
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)(action = this.getActionAttribute().trim()), (CharSequence)"javascript:")) {
                return htmlPage.executeJavaScriptIfPossible(action, "Form action", this.getStartLineNumber()).getNewPage();
            }
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)this.getActionAttribute(), (CharSequence)"javascript:")) {
            return htmlPage;
        }
        WebRequest request = this.getWebRequest(submitElement);
        String target = htmlPage.getResolvedTarget(this.getTargetAttribute());
        WebWindow webWindow = htmlPage.getEnclosingWindow();
        String action = this.getActionAttribute();
        boolean isHashJump = HttpMethod.GET == request.getHttpMethod() && action.endsWith("#");
        webClient.download(webWindow, target, request, isHashJump, "JS form.submit()");
        return htmlPage;
    }

    public WebRequest getWebRequest(SubmittableElement submitElement) {
        URL url;
        HttpMethod method;
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        List<NameValuePair> parameters = this.getParameterListForSubmit(submitElement);
        String methodAttribute = this.getMethodAttribute();
        if ("post".equalsIgnoreCase(methodAttribute)) {
            method = HttpMethod.POST;
        } else {
            if (!"get".equalsIgnoreCase(methodAttribute) && StringUtils.isNotBlank((CharSequence)methodAttribute)) {
                this.notifyIncorrectness("Incorrect submit method >" + this.getMethodAttribute() + "<. Using >GET<.");
            }
            method = HttpMethod.GET;
        }
        BrowserVersion browser = this.getPage().getWebClient().getBrowserVersion();
        String actionUrl = this.getActionAttribute();
        if (HttpMethod.GET == method) {
            String anchor = StringUtils.substringAfter((String)actionUrl, (String)"#");
            String enc = this.getPage().getPageEncoding();
            String queryFromFields = URLEncodedUtils.format(Arrays.asList(NameValuePair.toHttpClient(parameters)), (String)enc);
            actionUrl = StringUtils.substringBefore((String)actionUrl, (String)"#");
            actionUrl = StringUtils.substringBefore((String)actionUrl, (String)"?");
            if (browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_URL_END_WITH_QUESTIONMARK) || queryFromFields.length() > 0) {
                actionUrl = actionUrl + "?" + queryFromFields;
            }
            if (anchor.length() > 0 && !browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_URL_WITHOUT_HASH)) {
                actionUrl = actionUrl + "#" + anchor;
            }
            parameters.clear();
        }
        try {
            if (actionUrl.isEmpty()) {
                url = htmlPage.getUrl();
                if (browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_URL_WITHOUT_HASH)) {
                    url = UrlUtils.getUrlWithNewRef(url, null);
                }
            } else if (actionUrl.startsWith("?")) {
                String urlString = htmlPage.getUrl().toExternalForm();
                if (urlString.indexOf(63) != -1) {
                    urlString = urlString.substring(0, urlString.indexOf(63));
                } else if (urlString.indexOf(35) != -1 && browser.hasFeature(BrowserVersionFeatures.FORM_SUBMISSION_URL_WITHOUT_HASH)) {
                    urlString = urlString.substring(0, urlString.indexOf(35));
                }
                url = new URL(urlString + actionUrl);
            } else {
                url = htmlPage.getFullyQualifiedUrl(actionUrl);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Not a valid url: " + actionUrl);
        }
        WebRequest request = new WebRequest(url, method);
        request.setRequestParameters(parameters);
        if (HttpMethod.POST == method) {
            request.setEncodingType(FormEncodingType.getInstance(this.getEnctypeAttribute()));
        }
        request.setCharset(this.getSubmitCharset());
        request.setAdditionalHeader("Referer", htmlPage.getUrl().toExternalForm());
        return request;
    }

    private String getSubmitCharset() {
        if (this.getAcceptCharsetAttribute().length() > 0) {
            return SUBMIT_CHARSET_PATTERN.matcher(this.getAcceptCharsetAttribute().trim()).replaceAll("").toUpperCase();
        }
        return this.getPage().getPageEncoding();
    }

    private List<NameValuePair> getParameterListForSubmit(SubmittableElement submitElement) {
        Collection<SubmittableElement> submittableElements = this.getSubmittableElements(submitElement);
        ArrayList<NameValuePair> parameterList = new ArrayList<NameValuePair>(submittableElements.size());
        for (SubmittableElement element : submittableElements) {
            for (NameValuePair pair : element.getSubmitKeyValuePairs()) {
                parameterList.add(pair);
            }
        }
        return parameterList;
    }

    public Page reset() {
        SgmlPage htmlPage = this.getPage();
        ScriptResult scriptResult = this.fireEvent("reset");
        if (ScriptResult.isFalse(scriptResult)) {
            return scriptResult.getNewPage();
        }
        for (HtmlElement next : this.getHtmlElementDescendants()) {
            if (!(next instanceof SubmittableElement)) continue;
            ((SubmittableElement)((Object)next)).reset();
        }
        return htmlPage;
    }

    Collection<SubmittableElement> getSubmittableElements(SubmittableElement submitElement) {
        ArrayList<SubmittableElement> submittableElements = new ArrayList<SubmittableElement>();
        for (HtmlElement element : this.getFormHtmlElementDescendants()) {
            if (!this.isSubmittable(element, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)element));
        }
        for (HtmlElement element : this.lostChildren_) {
            if (!this.isSubmittable(element, submitElement)) continue;
            submittableElements.add((SubmittableElement)((Object)element));
        }
        return submittableElements;
    }

    private boolean isValidForSubmission(HtmlElement element, SubmittableElement submitElement) {
        String type;
        String tagName = element.getTagName();
        if (!SUBMITTABLE_ELEMENT_NAMES.contains(tagName)) {
            return false;
        }
        if (element.hasAttribute("disabled")) {
            return false;
        }
        if (element == submitElement && element instanceof HtmlImageInput) {
            return true;
        }
        if (!"isindex".equals(tagName) && !element.hasAttribute("name")) {
            return false;
        }
        if (!"isindex".equals(tagName) && "".equals(element.getAttribute("name"))) {
            return false;
        }
        if (element instanceof HtmlInput && ("radio".equals(type = element.getAttribute("type").toLowerCase()) || "checkbox".equals(type))) {
            return element.hasAttribute("checked");
        }
        if ("select".equals(tagName)) {
            return ((HtmlSelect)element).isValidForSubmission();
        }
        return true;
    }

    private boolean isSubmittable(HtmlElement element, SubmittableElement submitElement) {
        HtmlInput input;
        String type;
        String tagName = element.getTagName();
        if (!this.isValidForSubmission(element, submitElement)) {
            return false;
        }
        if (element == submitElement) {
            return true;
        }
        if (element instanceof HtmlInput && ("submit".equals(type = (input = (HtmlInput)element).getTypeAttribute().toLowerCase()) || "image".equals(type) || "reset".equals(type) || "button".equals(type))) {
            return false;
        }
        return !"button".equals(tagName);
    }

    public List<HtmlInput> getInputsByName(String name) {
        List<HtmlInput> list = this.getFormElementsByAttribute("input", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlInput) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlInput)elt);
        }
        return list;
    }

    private <E extends HtmlElement> List<E> getFormElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase();
        for (HtmlElement next : this.getFormHtmlElementDescendants()) {
            String attValue;
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttribute(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    private Iterable<HtmlElement> getFormHtmlElementDescendants() {
        final DomNode.DescendantElementsIterator<HtmlElement> iter = new DomNode.DescendantElementsIterator<HtmlElement>(HtmlElement.class){
            private boolean filterChildrenOfNestedForms_;

            @Override
            protected boolean isAccepted(DomNode node) {
                if (node instanceof HtmlForm) {
                    this.filterChildrenOfNestedForms_ = true;
                    return false;
                }
                boolean accepted = super.isAccepted(node);
                if (accepted && this.filterChildrenOfNestedForms_) {
                    return ((HtmlElement)node).getEnclosingForm() == HtmlForm.this;
                }
                return accepted;
            }
        };
        return new Iterable<HtmlElement>(){

            @Override
            public Iterator<HtmlElement> iterator() {
                return iter;
            }
        };
    }

    public final <I extends HtmlInput> I getInputByName(String name) throws ElementNotFoundException {
        List<HtmlInput> inputs = this.getInputsByName(name);
        if (inputs.isEmpty()) {
            throw new ElementNotFoundException("input", "name", name);
        }
        return (I)inputs.get(0);
    }

    public List<HtmlSelect> getSelectsByName(String name) {
        List<HtmlSelect> list = this.getFormElementsByAttribute("select", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlSelect) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlSelect)elt);
        }
        return list;
    }

    public HtmlSelect getSelectByName(String name) throws ElementNotFoundException {
        List<HtmlSelect> list = this.getSelectsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("select", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlButton> getButtonsByName(String name) {
        List<HtmlButton> list = this.getFormElementsByAttribute("button", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlButton) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlButton)elt);
        }
        return list;
    }

    public HtmlButton getButtonByName(String name) throws ElementNotFoundException {
        List<HtmlButton> list = this.getButtonsByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("button", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlTextArea> getTextAreasByName(String name) {
        List<HtmlTextArea> list = this.getFormElementsByAttribute("textarea", "name", name);
        for (HtmlElement elt : this.getLostChildren()) {
            if (!(elt instanceof HtmlTextArea) || !name.equals(elt.getAttribute("name"))) continue;
            list.add((HtmlTextArea)elt);
        }
        return list;
    }

    public HtmlTextArea getTextAreaByName(String name) throws ElementNotFoundException {
        List<HtmlTextArea> list = this.getTextAreasByName(name);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("textarea", "name", name);
        }
        return list.get(0);
    }

    public List<HtmlRadioButtonInput> getRadioButtonsByName(String name) {
        WebAssert.notNull("name", name);
        ArrayList<HtmlRadioButtonInput> results = new ArrayList<HtmlRadioButtonInput>();
        for (HtmlElement htmlElement : this.getInputsByName(name)) {
            if (!(htmlElement instanceof HtmlRadioButtonInput)) continue;
            results.add((HtmlRadioButtonInput)htmlElement);
        }
        return results;
    }

    void setCheckedRadioButton(HtmlRadioButtonInput radioButtonInput) {
        if (!this.isAncestorOf(radioButtonInput) && !this.lostChildren_.contains(radioButtonInput)) {
            throw new IllegalArgumentException("HtmlRadioButtonInput is not child of this HtmlForm");
        }
        List<HtmlRadioButtonInput> radios = this.getRadioButtonsByName(radioButtonInput.getNameAttribute());
        for (HtmlRadioButtonInput input : radios) {
            if (input == radioButtonInput) {
                input.setAttribute("checked", "checked");
                continue;
            }
            input.removeAttribute("checked");
        }
    }

    public HtmlRadioButtonInput getCheckedRadioButton(String name) {
        WebAssert.notNull("name", name);
        for (HtmlRadioButtonInput input : this.getRadioButtonsByName(name)) {
            if (!input.isChecked()) continue;
            return input;
        }
        return null;
    }

    public final String getActionAttribute() {
        return this.getAttribute("action");
    }

    public final void setActionAttribute(String action) {
        this.setAttribute("action", action);
    }

    public final String getMethodAttribute() {
        return this.getAttribute("method");
    }

    public final void setMethodAttribute(String method) {
        this.setAttribute("method", method);
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final void setNameAttribute(String name) {
        this.setAttribute("name", name);
    }

    public final String getEnctypeAttribute() {
        return this.getAttribute("enctype");
    }

    public final void setEnctypeAttribute(String encoding) {
        this.setAttribute("enctype", encoding);
    }

    public final String getOnSubmitAttribute() {
        return this.getAttribute("onsubmit");
    }

    public final String getOnResetAttribute() {
        return this.getAttribute("onreset");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAcceptCharsetAttribute() {
        return this.getAttribute("accept-charset");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public final void setTargetAttribute(String target) {
        this.setAttribute("target", target);
    }

    public <I extends HtmlInput> I getInputByValue(String value) throws ElementNotFoundException {
        List<HtmlInput> list = this.getInputsByValue(value);
        if (list.isEmpty()) {
            throw new ElementNotFoundException("input", "value", value);
        }
        return (I)list.get(0);
    }

    public List<HtmlInput> getInputsByValue(String value) {
        List<HtmlInput> results = this.getFormElementsByAttribute("input", "value", value);
        for (HtmlElement element : this.getLostChildren()) {
            if (!(element instanceof HtmlInput) || !value.equals(element.getAttribute("value"))) continue;
            results.add((HtmlInput)element);
        }
        return results;
    }

    void addLostChild(HtmlElement field) {
        this.lostChildren_.add(field);
        field.setOwningForm(this);
    }

    public List<HtmlElement> getLostChildren() {
        return this.lostChildren_;
    }

    @Override
    protected void preventDefault() {
        this.isPreventDefault_ = true;
    }
}

