/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

public final class Version {
    private Version() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1 && "-SanityCheck".equals(args[0])) {
            Version.runSanityCheck();
            return;
        }
        System.out.println(Version.getProductName());
        System.out.println(Version.getCopyright());
        System.out.println("Version: " + Version.getProductVersion());
    }

    private static void runSanityCheck() throws Exception {
        try (WebClient webClient = new WebClient();){
            HtmlPage page = (HtmlPage)webClient.getPage("http://htmlunit.sourceforge.net/index.html");
            page.executeJavaScript("document.location");
            System.out.println("Sanity check complete.");
        }
    }

    public static String getProductName() {
        return "HtmlUnit";
    }

    public static String getProductVersion() {
        return Version.class.getPackage().getImplementationVersion();
    }

    public static String getCopyright() {
        return "Copyright (c) 2002-2015 Gargoyle Software Inc. All rights reserved.";
    }
}

