/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBufferView;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class ArrayBufferViewBase
extends ArrayBufferView {
    public void constructor(Object object, Object byteOffset, Object length) {
        if (object instanceof Number) {
            this.constructor(((Number)object).intValue());
        } else if (object instanceof NativeArray) {
            this.constructor((NativeArray)object);
        } else if (object instanceof ArrayBufferViewBase) {
            this.constructor((ArrayBufferViewBase)object);
        } else if (object instanceof ArrayBuffer) {
            double dbLength;
            ArrayBuffer array = (ArrayBuffer)object;
            double dbByteOffset = Context.toNumber((Object)byteOffset);
            if (dbByteOffset != dbByteOffset) {
                dbByteOffset = 0.0;
            }
            if ((dbLength = Context.toNumber((Object)length)) != dbLength) {
                dbLength = array.getByteLength();
            }
            super.constructor(array, (int)dbByteOffset, (int)dbLength);
        } else {
            Context.reportRuntimeError((String)("Invalid type " + object.getClass().getName()));
        }
    }

    private void constructor(int length) {
        int byteLength = length * this.getBytesPerElement();
        this.setByteLength(byteLength);
        this.initBuffer(byteLength);
    }

    private void constructor(NativeArray array) {
        int byteLength = (int)array.getLength() * this.getBytesPerElement();
        this.setByteLength(byteLength);
        this.initBuffer(byteLength);
        this.set((ScriptableObject)array, 0);
    }

    private void constructor(ArrayBufferViewBase array) {
        int byteLength = array.getLength() * this.getBytesPerElement();
        this.setByteLength(byteLength);
        this.initBuffer(byteLength);
        this.set(array, 0);
    }

    private void initBuffer(int lengthInBytes) {
        ArrayBuffer buffer = new ArrayBuffer();
        buffer.constructor(lengthInBytes);
        buffer.setPrototype(this.getPrototype(buffer.getClass()));
        buffer.setParentScope(this.getParentScope());
        this.setBuffer(buffer);
    }

    @JsxGetter
    public int getLength() {
        return this.getByteLength() / this.getBytesPerElement();
    }

    @JsxFunction
    public void set(ScriptableObject sourceArray, int offset) {
        int length = ((Number)ScriptableObject.getProperty((Scriptable)sourceArray, (String)"length")).intValue();
        for (int i = 0; i < length; ++i) {
            this.put(i + offset, (Scriptable)this, sourceArray.get((Object)i));
        }
    }

    public Number get(int index, Scriptable start) {
        int offset = index * this.getBytesPerElement() + this.getByteOffset();
        return this.fromArray(this.getBuffer().getBytes(), offset);
    }

    public void put(int index, Scriptable start, Object value) {
        this.getBuffer().setBytes(index * this.getBytesPerElement() + this.getByteOffset(), this.toArray((Number)value));
    }

    protected byte[] toArray(Number number) {
        return null;
    }

    protected Number fromArray(byte[] array, int offset) {
        return null;
    }

    @JsxFunction
    public ArrayBufferView subarray(int begin, Object end) {
        if (end == Undefined.instance) {
            end = this.getLength();
        }
        try {
            ArrayBufferView object = (ArrayBufferView)this.getClass().newInstance();
            object.setPrototype(this.getPrototype());
            object.setParentScope(this.getParentScope());
            object.constructor(this.getBuffer(), begin, ((Number)end).intValue() - begin);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int getBytesPerElement() {
        return 1;
    }
}

