/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.host.css.BrowserConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class StyleAttributes {
    private static final Map<String, Definition> styles_ = new HashMap<String, Definition>();

    private StyleAttributes() {
    }

    public static Definition getDefinition(String propertyName, BrowserVersion browserVersion) {
        if (browserVersion == null) {
            return null;
        }
        Definition definition = styles_.get(propertyName);
        if (definition == null) {
            return null;
        }
        if (!definition.isAvailable(browserVersion)) {
            return null;
        }
        return definition;
    }

    public static List<Definition> getDefinitions(BrowserVersion browserVersion) {
        ArrayList<Definition> list = new ArrayList<Definition>();
        for (Definition definition : Definition.values()) {
            if (!definition.isAvailable(browserVersion)) continue;
            list.add(definition);
        }
        return list;
    }

    static {
        Definition.values();
    }

    public static enum Definition {
        MOZ_ANIMATION("MozAnimation", "-moz-animation", BrowserConfiguration.ff("")),
        MOZ_ANIMATION_DELAY("MozAnimationDelay", "-moz-animation-delay", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_DIRECTION("MozAnimationDirection", "-moz-animation-direction", BrowserConfiguration.ff("normal")),
        MOZ_ANIMATION_DURATION("MozAnimationDuration", "-moz-animation-duration", BrowserConfiguration.ff("0s")),
        MOZ_ANIMATION_FILL_MODE("MozAnimationFillMode", "moz-animation-fill-mode", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_ITERATION_COUNT("MozAnimationIterationCount", "-moz-animation-iteration-count", BrowserConfiguration.ff("1")),
        MOZ_ANIMATION_NAME("MozAnimationName", "moz-annimation-name", BrowserConfiguration.ff("none")),
        MOZ_ANIMATION_PLAY_STATE("MozAnimationPlayState", "moz-annimation-play-state", BrowserConfiguration.ff("running")),
        MOZ_ANIMATION_TIMING_FUNCTION("MozAnimationTimingFunction", "moz-annimation-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MOZ_APPEARANCE("MozAppearance", "-moz-appearance", BrowserConfiguration.ff("none")),
        MOZ_BACKFACE_VISIBILITY("MozBackfaceVisibility", "-moz-backface-visibility", BrowserConfiguration.ff("visible")),
        MOZ_BACKGROUND_CLIP("MozBackgroundClip", "-moz-background-clip", new BrowserConfiguration[0]),
        MOZ_BACKGROUND_INLINE_POLICY("MozBackgroundInlinePolicy", "-moz-background-inline-policy", BrowserConfiguration.ff("continuous")),
        MOZ_BACKGROUND_ORIGIN("MozBackgroundOrigin", "-moz-background-origin", new BrowserConfiguration[0]),
        MOZ_BACKGROUND_SIZE("MozBackgroundSize", "-moz-background-size", new BrowserConfiguration[0]),
        MOZ_BINDING("MozBinding", "-moz-binding", BrowserConfiguration.ff("none")),
        MOZ_BORDER_BOTTOM_COLORS("MozBorderBottomColors", "-moz-border-bottom-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_END("MozBorderEnd", "-moz-border-end", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_COLOR("MozBorderEndColor", "-moz-border-end-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_STYLE("MozBorderEndStyle", "-moz-border-end-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_END_WIDTH("MozBorderEndWidth", "-moz-border-end-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_IMAGE("MozBorderImage", "-moz-border-image", BrowserConfiguration.ff("")),
        MOZ_BORDER_LEFT_COLORS("MozBorderLeftColors", "-moz-border-left-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_RADIUS("MozBorderRadius", "-moz-border-radius", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_BOTTOMLEFT("MozBorderRadiusBottomleft", "-moz-border-radius-bottomleft", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_BOTTOMRIGHT("MozBorderRadiusBottomright", "-moz-border-radius-bottomright", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_TOPLEFT("MozBorderRadiusTopleft", "-moz-border-radius-topleft", new BrowserConfiguration[0]),
        MOZ_BORDER_RADIUS_TOPRIGHT("MozBorderRadiusTopright", "-moz-border-radius-topright", new BrowserConfiguration[0]),
        MOZ_BORDER_RIGHT_COLORS("MozBorderRightColors", "-moz-border-right-colors", BrowserConfiguration.ff("none")),
        MOZ_BORDER_START("MozBorderStart", "-moz-border-start", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_COLOR("MozBorderStartColor", "-moz-border-start-color", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_STYLE("MozBorderStartStyle", "-moz-border-start-style", BrowserConfiguration.ff("")),
        MOZ_BORDER_START_WIDTH("MozBorderStartWidth", "-moz-border-start-width", BrowserConfiguration.ff("")),
        MOZ_BORDER_TOP_COLORS("MozBorderTopColors", "-moz-border-top-colors", BrowserConfiguration.ff("none")),
        MOZ_BOX_ALIGN("MozBoxAlign", "-moz-box-align", BrowserConfiguration.ff("stretch")),
        MOZ_BOX_DIRECTION("MozBoxDirection", "-moz-box-direction", BrowserConfiguration.ff("normal")),
        MOZ_BOX_FLEX("MozBoxFlex", "-moz-box-flex", BrowserConfiguration.ff("0")),
        MOZ_BOX_ORDINAL_GROUP("MozBoxOrdinalGroup", "-moz-box-ordinal-group", BrowserConfiguration.ff("1")),
        MOZ_BOX_ORIENT("MozBoxOrient", "-moz-box-orient", BrowserConfiguration.ff("horizontal")),
        MOZ_BOX_PACK("MozBoxPack", "-moz-box-pack", BrowserConfiguration.ff("start")),
        MOZ_BOX_SHADOW("MozBoxShadow", "-moz-box-shadow", new BrowserConfiguration[0]),
        MOZ_BOX_SIZING("MozBoxSizing", "-moz-box-sizing", BrowserConfiguration.ff("content-box")),
        MOZ_COLUMN_COUNT("MozColumnCount", "-moz-column-count", BrowserConfiguration.ff("auto")),
        MOZ_COLUMN_FILL("MozColumnFill", "-moz-column-fill", BrowserConfiguration.ff24up("balance")),
        MOZ_COLUMN_GAP("MozColumnGap", "-moz-column-gap", BrowserConfiguration.ff("16px")),
        MOZ_COLUMN_RULE("MozColumnRule", "-moz-column-rule", BrowserConfiguration.ff("")),
        MOZ_COLUMN_RULE_COLOR("MozColumnRuleColor", "-moz-column-rule-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_COLUMN_RULE_STYLE("MozColumnRuleStyle", "-moz-column-rule-style", BrowserConfiguration.ff("none")),
        MOZ_COLUMN_RULE_WIDTH("MozColumnRuleWidth", "-moz-column-rule-width", BrowserConfiguration.ff("0px")),
        MOZ_COLUMN_WIDTH("MozColumnWidth", "-moz-column-width", BrowserConfiguration.ff("auto")),
        MOZ_COLUMNS("MozColumns", "-moz-columns", BrowserConfiguration.ff("")),
        MOZ_FLOAT_EDGE("MozFloatEdge", "-moz-float-edge", BrowserConfiguration.ff("content-box")),
        MOZ_FONT_FEATURE_SETTINGS("MozFontFeatureSettings", "-moz-font-feature-settings", BrowserConfiguration.ff("normal")),
        MOZ_FONT_LANGUAGE_OVERRIDE("MozFontLanguageOverride", "-moz-font-language-override", BrowserConfiguration.ff("normal")),
        MOZ_FORCE_BROKEN_IMAGE_ICON("MozForceBrokenImageIcon", "-moz-force-broken-image-icon", BrowserConfiguration.ff("0")),
        MOZ_HYPHENS("MozHyphens", "-moz-hyphens", BrowserConfiguration.ff("manual")),
        MOZ_IMAGE_REGION("MozImageRegion", "-moz-image-region", BrowserConfiguration.ff("auto")),
        MOZ_MARGIN_END("MozMarginEnd", "-moz-margin-end", BrowserConfiguration.ff("")),
        MOZ_MARGIN_START("MozMarginStart", "-moz-margin-start", BrowserConfiguration.ff("")),
        MOZ_OPACITY("MozOpacity", "-moz-opacity", new BrowserConfiguration[0]),
        MOZ_ORIENT("MozOrient", "-moz-orient", BrowserConfiguration.ff24up("auto"), BrowserConfiguration.ff("horizontal")),
        MOZ_OUTLINE("MozOutline", "-moz-outline", new BrowserConfiguration[0]),
        MOZ_OUTLINE_COLOR("MozOutlineColor", "-moz-outline-color", new BrowserConfiguration[0]),
        MOZ_OUTLINE_OFFSET("MozOutlineOffset", "-moz-outline-offset", new BrowserConfiguration[0]),
        MOZ_OUTLINE_RADIUS("MozOutlineRadius", "-mz-outline-radius", BrowserConfiguration.ff("")),
        MOZ_OUTLINE_RADIUS_BOTTOMLEFT("MozOutlineRadiusBottomleft", "-moz-outline-radius-bottomleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_BOTTOMRIGHT("MozOutlineRadiusBottomright", "-moz-outline-radius-bottomright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPLEFT("MozOutlineRadiusTopleft", "-moz-outline-radius-topleft", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_RADIUS_TOPRIGHT("MozOutlineRadiusTopright", "-moz-outline-radius-topright", BrowserConfiguration.ff("0px")),
        MOZ_OUTLINE_STYLE("MozOutlineStyle", "-moz-outline-style", new BrowserConfiguration[0]),
        MOZ_OUTLINE_WIDTH("MozOutlineWidth", "-moz-outline-width", new BrowserConfiguration[0]),
        MOZ_PADDING_END("MozPaddingEnd", "-moz-padding-end", BrowserConfiguration.ff("")),
        MOZ_PADDING_START("MozPaddingStart", "-moz-padding-start", BrowserConfiguration.ff("")),
        MOZ_PERSPECTIVE("MozPerspective", "-moz-perspective", BrowserConfiguration.ff("none")),
        MOZ_PERSPECTIVE_ORIGIN("MozPerspectiveOrigin", "-moz-perspective-origin", BrowserConfiguration.ff("621px 172.5px")),
        MOZ_STACK_SIZING("MozStackSizing", "-moz-stack-sizing", BrowserConfiguration.ff("stretch-to-fit")),
        MOZ_TAB_SIZE("MozTabSize", "-moz-tab-size", BrowserConfiguration.ff("8")),
        MOZ_TEXT_ALIGN_LAST("MozTextAlignLast", "-moz-text-align-last", BrowserConfiguration.ff("auto")),
        MOZ_TEXT_BLINK("MozTextBlink", "-moz-text-blink", BrowserConfiguration.ffBelow31("none")),
        MOZ_TEXT_DECORATION_COLOR("MozTextDecorationColor", "-moz-text-decoration-color", BrowserConfiguration.ff("rgb(0, 0, 0)")),
        MOZ_TEXT_DECORATION_LINE("MozTextDecorationLine", "-moz-text-decoration-line", BrowserConfiguration.ff("none")),
        MOZ_TEXT_DECORATION_STYLE("MozTextDecorationStyle", "-moz-text-decoration-style", BrowserConfiguration.ff("solid")),
        MOZ_TEXT_SIZE_ADJUST("MozTextSizeAdjust", "-moz-text-size-adjust", BrowserConfiguration.ff("auto")),
        MOZ_TRANSFORM("MozTransform", "-moz-transform", BrowserConfiguration.ff("none")),
        MOZ_TRANSFORM_ORIGIN("MozTransformOrigin", "-moz-transform-origin", BrowserConfiguration.ff("621px 172.5px")),
        MOZ_TRANSFORM_STYLE("MozTransformStyle", "-moz-transform-style", BrowserConfiguration.ff("flat")),
        MOZ_TRANSITION("MozTransition", "-moz-transition", BrowserConfiguration.ff("")),
        MOZ_TRANSITION_DELAY("MozTransitionDelay", "-moz-transition-delay", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_DURATION("MozTransitionDuration", "-moz-transition-duration", BrowserConfiguration.ff("0s")),
        MOZ_TRANSITION_PROPERTY("MozTransitionProperty", "-moz-transition-property", BrowserConfiguration.ff("all")),
        MOZ_TRANSITION_TIMING_FUNCTION("MozTransitionTimingFunction", "-moz-transition-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MOZ_USER_FOCUS("MozUserFocus", "-moz-user-focus", BrowserConfiguration.ff("none")),
        MOZ_USER_INPUT("MozUserInput", "-moz-user-input", BrowserConfiguration.ff("auto")),
        MOZ_USER_MODIFY("MozUserModify", "-moz-user-modify", BrowserConfiguration.ff("read-only")),
        MOZ_USER_SELECT("MozUserSelect", "-moz-user-select", BrowserConfiguration.ff("auto")),
        MOZ_WINDOW_SHADOW("MozWindowShadow", "-moz-window-shadow", BrowserConfiguration.ff("default")),
        MS_ANIMATION("msAnimation", "-ms-animation", BrowserConfiguration.ie11up("")),
        MS_ANIMATION_DELAY("msAnimationDelay", "-ms-animation-delay", BrowserConfiguration.ie11up("0s")),
        MS_ANIMATION_DIRECTION("msAnimationDirection", "-ms-animation-direction", BrowserConfiguration.ie11up("normal")),
        MS_ANIMATION_DURATION("msAnimationDuration", "-ms-animation-duration", BrowserConfiguration.ie11up("0s")),
        MS_ANIMATION_FILL_MODE("msAnimationFillMode", "-ms-animation-fill-mode", BrowserConfiguration.ie11up("none")),
        MS_ANIMATION_ITERATION_COUNT("msAnimationIterationCount", "-ms-animation-iteration-count", BrowserConfiguration.ie11up("1")),
        MS_ANIMATION_NAME("msAnimationName", "-ms-annimation-name", BrowserConfiguration.ie11up("none")),
        MS_ANIMATION_PLAY_STATE("msAnimationPlayState", "-ms-animation-play-state", BrowserConfiguration.ie11up("running")),
        MS_ANIMATION_TIMING_FUNCTION("msAnimationTimingFunction", "-ms-animation-timing-function", BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MS_BACKFACE_VISIBILITY("msBackfaceVisibility", "-ms-backface-visibility", BrowserConfiguration.ie11up("visible")),
        MS_BLOCK_PROGRESSION("msBlockProgression", "-ms-block-progression", BrowserConfiguration.ie11up("undefined")),
        MS_CONTENT_ZOOM_CHAINING("msContentZoomChaining", "-ms-content-zoom-chaining", BrowserConfiguration.ie11up("none")),
        MS_CONTENT_ZOOM_LIMIT("msContentZoomLimit", "-ms-content-zoom-limit", BrowserConfiguration.ie11up("")),
        MS_CONTENT_ZOOM_LIMIT_MAX("msContentZoomLimitMax", "-ms-content-zoom-limit-max", BrowserConfiguration.ie11up("400%")),
        MS_CONTENT_ZOOM_LIMIT_MIN("msContentZoomLimitMin", "-ms-content-zoom-limit-min", BrowserConfiguration.ie11up("100%")),
        MS_CONTENT_ZOOM_SNAP("msContentZoomSnap", "-ms-content-zoom-snap", BrowserConfiguration.ie11up("none snapInterval(0%, 100%)")),
        MS_CONTENT_ZOOM_SNAP_POINTS("msContentZoomSnapPoints", "-ms-content-zoom-snap-points", BrowserConfiguration.ie11up("snapInterval(0%, 100%)")),
        MS_CONTENT_ZOOM_SNAP_TYPE("msContentZoomSnapType", "-ms-content-zoom-snap-type", BrowserConfiguration.ie11up("none")),
        MS_CONTENT_ZOOMING("msContentZooming", "-ms-content-zooming", BrowserConfiguration.ie11up("none")),
        MS_FLEX("msFlex", "-ms-flex", BrowserConfiguration.ie11up("0 1 auto")),
        MS_FLEX_ALIGN("msFlexAlign", "-ms-flex-align", BrowserConfiguration.ie11up("stretch")),
        MS_FLEX_DIRECTION("msFlexDirection", "-ms-flex-direction", BrowserConfiguration.ie11up("row")),
        MS_FLEX_FLOW("msFlexFlow", "-ms-flex-flow", BrowserConfiguration.ie11up("row nowrap")),
        MS_FLEX_ITEM_ALIGN("msFlexItemAlign", "-ms-flex-item-align", BrowserConfiguration.ie11up("auto")),
        MS_FLEX_LINE_PACK("msFlexLinePack", "-ms-flex-line-pack", BrowserConfiguration.ie11up("stretch")),
        MS_FLEX_NEGATIVE("msFlexNegative", "-ms-flex-negative", BrowserConfiguration.ie11up("1")),
        MS_FLEX_ORDER("msFlexOrder", "-ms-flex-order", BrowserConfiguration.ie11up("0")),
        MS_FLEX_PACK("msFlexPack", "-ms-flex-pack", BrowserConfiguration.ie11up("start")),
        MS_FLEX_POSITIVE("msFlexPositive", "-ms-flex-positive", BrowserConfiguration.ie11up("0")),
        MS_FLEX_PREFERRED_SIZE("msFlexPreferredSize", "-ms-flex-preferred-size", BrowserConfiguration.ie11up("auto")),
        MS_FLEX_WRAP("msFlexWrap", "-ms-flex-wrap", BrowserConfiguration.ie11up("nowrap")),
        MS_FLOW_FROM("msFlowFrom", "-ms-flow-from", BrowserConfiguration.ie11up("none")),
        MS_FLOW_INTO("msFlowInto", "-ms-flow-into", BrowserConfiguration.ie11up("none")),
        MS_FONT_FEATURE_SETTINGS("msFontFeatureSettings", "-ms-font-feature-settings", BrowserConfiguration.ie11up("normal")),
        MS_GRID_COLUMN("msGridColumn", "-ms-grid-column", BrowserConfiguration.ie11up("1")),
        MS_GRID_COLUMN_ALIGN("msGridColumnAlign", "-ms-grid-column-align", BrowserConfiguration.ie11up("stretch")),
        MS_GRID_COLUMN_SPAN("msGridColumnSpan", "-ms-grid-column-span", BrowserConfiguration.ie11up("1")),
        MS_GRID_COLUMNS("msGridColumns", "-ms-grid-columns", BrowserConfiguration.ie11up("none")),
        MS_GRID_ROW("msGridRow", "-ms-grid-row", BrowserConfiguration.ie11up("1")),
        MS_GRID_ROW_ALIGN("msGridRowAlign", "-ms-grid-row-align", BrowserConfiguration.ie11up("stretch")),
        MS_GRID_ROW_SPAN("msGridRowSpan", "-ms-grid-row-span", BrowserConfiguration.ie11up("1")),
        MS_GRID_ROWS("msGridRows", "-ms-grid-rows", BrowserConfiguration.ie11up("none")),
        MS_HIGH_CONTRAST_ADJUST("msHighContrastAdjust", "-ms-high-contrast-adjust", BrowserConfiguration.ie11up("auto")),
        MS_HYPHENATE_LIMIT_CHARS("msHyphenateLimitChars", "-ms-hyphenate-limit-chars", BrowserConfiguration.ie11up("5 2 2")),
        MS_HYPHENATE_LIMIT_LINES("msHyphenateLimitLines", "-ms-hyphenate-limit-lines", BrowserConfiguration.ie11up("no-limit")),
        MS_HYPHENATE_LIMIT_ZONE("msHyphenateLimitZone", "-ms-hyphenate-limit-zone", BrowserConfiguration.ie11up("0px")),
        MS_HYPHENS("msHyphens", "-ms-hyphens", BrowserConfiguration.ie11up("manual")),
        MS_IME_ALIGN("msImeAlign", "-ms-ime-align", BrowserConfiguration.ie11up("")),
        MS_INTERPOLATION_MODE("msInterpolationMode", "-ms-interpolation-mode", BrowserConfiguration.ie11up("undefined")),
        MS_OVERFLOW_STYLE("msOverflowStyle", "-ms-overflow-style", BrowserConfiguration.ie11up("scrollbar")),
        MS_PERSPECTIVE("msPerspective", "-ms-perspective", BrowserConfiguration.ie11up("none")),
        MS_PERSPECTIVE_ORIGIN("msPerspectiveOrigin", "-ms-perspective-origin", BrowserConfiguration.ie11up("620px 163.2px")),
        MS_SCROLL_CHAINING("msScrollChaining", "-ms-scroll-chaining", BrowserConfiguration.ie11up("chained")),
        MS_SCROLL_LIMIT("msScrollLimit", "-ms-scroll-limit", BrowserConfiguration.ie11up("")),
        MS_SCROLL_LIMIT_X_MAX("msScrollLimitXMax", "-ms-scroll-limit-x-max", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_LIMIT_X_MIN("msScrollLimitXMin", "-ms-scroll-limit-x-min", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_LIMIT_Y_MAX("msScrollLimitYMax", "-ms-scroll-limit-y-max", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_LIMIT_Y_MIN("msScrollLimitYMin", "-ms-scroll-limit-y-min", BrowserConfiguration.ie11up("0px")),
        MS_SCROLL_RAILS("msScrollRails", "-ms-scroll-rails", BrowserConfiguration.ie11up("railed")),
        MS_SCROLL_SNAP_POINTS_X("msScrollSnapPointsX", "-ms-scroll-snap-points-x", BrowserConfiguration.ie11up("snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_POINTS_Y("msScrollSnapPointsY", "-ms-scroll-snap-points-y", BrowserConfiguration.ie11up("snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_TYPE("msScrollSnapType", "-ms-scroll-snap-type", BrowserConfiguration.ie11up("none")),
        MS_SCROLL_SNAP_X("msScrollSnapX", "-ms-scroll-snap-x", BrowserConfiguration.ie11up("none snapInterval(0%, 100%)")),
        MS_SCROLL_SNAP_Y("msScrollSnapY", "-ms-scroll-snap-y", BrowserConfiguration.ie11up("none snapInterval(0%, 100%)")),
        MS_SCROLL_TRANSLATION("msScrollTranslation", "-ms-scroll-translation", BrowserConfiguration.ie11up("none")),
        MS_TEXT_COMBINE_HORIZONTAL("msTextCombineHorizontal", "-ms-text-combine-horizontal", BrowserConfiguration.ie11up("none")),
        MS_TOUCH_ACTION("msTouchAction", "-ms-touch-action", BrowserConfiguration.ie11up("auto")),
        MS_TOUCH_SELECT("msTouchSelect", "-ms-touch-select", BrowserConfiguration.ie11up("")),
        MS_TRANSFORM("msTransform", "-ms-transform", BrowserConfiguration.ie11up("none")),
        MS_TRANSFORM_ORIGIN("msTransformOrigin", "-ms-transform-origin", BrowserConfiguration.ie11up("620px 163.2px")),
        MS_TRANSFORM_STYLE("msTransformStyle", "-ms-transform-style", BrowserConfiguration.ie11up("flat")),
        MS_TRANSITION("msTransition", "-ms-transition", BrowserConfiguration.ie11up("")),
        MS_TRANSITION_DELAY("msTransitionDelay", "-ms-transition-delay", BrowserConfiguration.ie11up("0s")),
        MS_TRANSITION_DURATION("msTransitionDuration", "-ms-transition-duration", BrowserConfiguration.ie11up("0s")),
        MS_TRANSITION_PROPERTY("msTransitionProperty", "-ms-transition-property", BrowserConfiguration.ie11up("all")),
        MS_TRANSITION_TIMING_FUNCTION("msTransitionTimingFunction", "-ms-transition-timing-function", BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        MS_USER_SELECT("msUserSelect", "-ms-user-select", BrowserConfiguration.ie11up("text")),
        MS_WRAP_FLOW("msWrapFlow", "-ms-wrap-flow", BrowserConfiguration.ie11up("auto")),
        MS_WRAP_MARGIN("msWrapMargin", "-ms-wrap-margin", BrowserConfiguration.ie11up("auto")),
        MS_WRAP_THROUGH("msWrapThrough", "-ms-wrap-through", BrowserConfiguration.ie11up("wrap")),
        ALIGN_CONTENT("alignContent", "align-content", BrowserConfiguration.ie11up("stretch"), BrowserConfiguration.ff31up("stretch")),
        ALIGN_ITEMS("alignItems", "align-items", BrowserConfiguration.ff24up("stretch"), BrowserConfiguration.ie11up("stretch")),
        ALIGN_SELF("alignSelf", "align-self", BrowserConfiguration.ff24up("stretch"), BrowserConfiguration.ie11up("auto")),
        ALIGNMENT_BASELINE("alignmentBaseline", "alignment-baseline", BrowserConfiguration.ie11up("auto")),
        ALL("all", "all", BrowserConfiguration.ff31up("")),
        ANIMATION("animation", "animation", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("")),
        ANIMATION_DELAY("animationDelay", "animation-delay", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s")),
        ANIMATION_DIRECTION("animationDirection", "animation-direction", BrowserConfiguration.ff("normal"), BrowserConfiguration.ie11up("normal")),
        ANIMATION_DURATION("animationDuration", "animation-duration", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s")),
        ANIMATION_FILL_MODE("animationFillMode", "animation-fill-mode", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        ANIMATION_ITERATION_COUNT("animationIterationCount", "animation-iteration-count", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1")),
        ANIMATION_NAME("animationName", "animation-name", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        ANIMATION_PLAY_STATE("animationPlayState", "animation-play-state", BrowserConfiguration.ff("running"), BrowserConfiguration.ie11up("running")),
        ANIMATION_TIMING_FUNCTION("animationTimingFunction", "animation-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        AZIMUTH("azimuth", "azimuth", new BrowserConfiguration[0]),
        BACKFACE_VISIBILITY("backfaceVisibility", "backface-visibility", BrowserConfiguration.ff("visible"), BrowserConfiguration.ie11up("visible")),
        BACKGROUND_BLEND_MODE("backgroundBlendMode", "background-blend-mode", BrowserConfiguration.ff31up("normal")),
        BACKGROUND_CLIP("backgroundClip", "background-clip", BrowserConfiguration.ff("border-box"), BrowserConfiguration.ie11up("border-box")),
        BACKGROUND_ORIGIN("backgroundOrigin", "background-origin", BrowserConfiguration.ff("padding-box"), BrowserConfiguration.ie11up("padding-box")),
        BACKGROUND_POSITION_X("backgroundPositionX", "background-position-x", BrowserConfiguration.ie11up("undefined")),
        BACKGROUND_POSITION_Y("backgroundPositionY", "background-position-y", BrowserConfiguration.ie11up("undefined")),
        BACKGROUND_SIZE("backgroundSize", "background-size", BrowserConfiguration.ff("auto auto"), BrowserConfiguration.ie11up("auto")),
        BASELINE_SHIFT("baselineShift", "baseline-shift", BrowserConfiguration.ie11up("baseline")),
        BEHAVIOR("behavior", "behavior", new BrowserConfiguration[0]),
        BORDER_BOTTOM_LEFT_RADIUS("borderBottomLeftRadius", "border-bottom-left-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px")),
        BORDER_BOTTOM_RIGHT_RADIUS("borderBottomRightRadius", "border-bottom-right-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px")),
        BORDER_IMAGE("borderImage", "border-image", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("")),
        BORDER_IMAGE_OUTSET("borderImageOutset", "border-image-outset", BrowserConfiguration.ff("0 0 0 0"), BrowserConfiguration.ie11up("0")),
        BORDER_IMAGE_REPEAT("borderImageRepeat", "border-image-repeat", BrowserConfiguration.ff("stretch stretch"), BrowserConfiguration.ie11up("stretch")),
        BORDER_IMAGE_SLICE("borderImageSlice", "border-image-slice", BrowserConfiguration.ff("100% 100% 100% 100%"), BrowserConfiguration.ie11up("100%")),
        BORDER_IMAGE_SOURCE("borderImageSource", "border-image-source", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        BORDER_IMAGE_WIDTH("borderImageWidth", "border-image-width", BrowserConfiguration.ff("1 1 1 1"), BrowserConfiguration.ie11up("1")),
        BORDER_RADIUS("borderRadius", "border-radius", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("")),
        BORDER_TOP_LEFT_RADIUS("borderTopLeftRadius", "border-top-left-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px")),
        BORDER_TOP_RIGHT_RADIUS("borderTopRightRadius", "border-top-right-radius", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px")),
        BOX_SHADOW("boxShadow", "box-shadow", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        BOX_SIZING("boxSizing", "box-sizing", BrowserConfiguration.ff31up("content-box"), BrowserConfiguration.ie11up("content-box")),
        BREAK_AFTER("breakAfter", "break-after", BrowserConfiguration.ie11up("auto")),
        BREAK_BEFORE("breakBefore", "break-before", BrowserConfiguration.ie11up("auto")),
        BREAK_INSIDE("breakInside", "break-inside", BrowserConfiguration.ie11up("auto")),
        CLIP_PATH("clipPath", "clip-path", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        CLIP_RULE("clipRule", "clip-rule", BrowserConfiguration.ff("nonzero"), BrowserConfiguration.ie11up("nonzero")),
        COLOR_INTERPOLATION("colorInterpolation", "color-interpolation", BrowserConfiguration.ff("srgb")),
        COLOR_INTERPOLATION_FILTERS("colorInterpolationFilters", "color-interpolation-filters", BrowserConfiguration.ff("linearrgb"), BrowserConfiguration.ie11up("")),
        COLUMN_COUNT("columnCount", "column-count", BrowserConfiguration.ie11up("auto")),
        COLUMN_FILL("columnFill", "column-fill", BrowserConfiguration.ie11up("balance")),
        COLUMN_GAP("columnGap", "column-gap", BrowserConfiguration.ie11up("normal")),
        COLUMN_RULE("columnRule", "column-rule", BrowserConfiguration.ie11up("")),
        COLUMN_RULE_COLOR("columnRuleColor", "column-rule-color", BrowserConfiguration.ie11up("rgb(0, 0, 0)")),
        COLUMN_RULE_STYLE("columnRuleStyle", "column-rule-style", BrowserConfiguration.ie11up("none")),
        COLUMN_RULE_WIDTH("columnRuleWidth", "column-rule-width", BrowserConfiguration.ie11up("medium")),
        COLUMN_SPAN("columnSpan", "column-span", BrowserConfiguration.ie11up("1")),
        COLUMN_WIDTH("columnWidth", "column-width", BrowserConfiguration.ie11up("auto")),
        COLUMNS("columns", "columns", BrowserConfiguration.ie11up("")),
        CONTENT("content", "content", BrowserConfiguration.ie11up("normal")),
        CUE("cue", "cue", new BrowserConfiguration[0]),
        CUE_AFTER("cueAfter", "cue-after", new BrowserConfiguration[0]),
        CUE_BEFORE("cueBefore", "cue-before", new BrowserConfiguration[0]),
        DOMINANT_BASELINE("dominantBaseline", "dominant-baseline", BrowserConfiguration.ff("auto"), BrowserConfiguration.ie11up("auto")),
        EMPTY_CELLS("emptyCells", "empty-cells", BrowserConfiguration.ie11up("show")),
        ENABLE_BACKGROUND("enableBackground", "enable-background", BrowserConfiguration.ie11up("accumulate")),
        ELEVATION("elevation", "elevation", new BrowserConfiguration[0]),
        FILL("fill", "fill", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie11up("black")),
        FILL_OPACITY("fillOpacity", "fill-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1")),
        FILL_RULE("fillRule", "fill-rule", BrowserConfiguration.ff("nonzero"), BrowserConfiguration.ie11up("nonzero")),
        FILTER("filter", "filter", BrowserConfiguration.ff("none"), BrowserConfiguration.ieBelow11(""), BrowserConfiguration.ie11up("none")),
        FLEX("flex", "flex", BrowserConfiguration.ff24up(""), BrowserConfiguration.ie11up("0 1 auto")),
        FLEX_BASIS("flexBasis", "flex-basis", BrowserConfiguration.ff24up("auto"), BrowserConfiguration.ie11up("auto")),
        FLEX_DIRECTION("flexDirection", "flex-direction", BrowserConfiguration.ff24up("row"), BrowserConfiguration.ie11up("row")),
        FLEX_FLOW("flexFlow", "flex-flow", BrowserConfiguration.ff31up(""), BrowserConfiguration.ie11up("row nowrap")),
        FLEX_GROW("flexGrow", "flex-grow", BrowserConfiguration.ff24up("0"), BrowserConfiguration.ie11up("0")),
        FLEX_SHRINK("flexShrink", "flex-shrink", BrowserConfiguration.ff24up("1"), BrowserConfiguration.ie11up("1")),
        FLEX_WRAP("flexWrap", "flex-wrap", BrowserConfiguration.ff31up("nowrap"), BrowserConfiguration.ie11up("nowrap")),
        FLOOD_COLOR("floodColor", "flood-color", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie11up("")),
        FLOOD_OPACITY("floodOpacity", "flood-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1")),
        FONT_FEATURE_SETTINGS("fontFeatureSettings", "font-feature-settings", BrowserConfiguration.ie11up("normal")),
        GLYPH_ORIENTATION_HORIZONTAL("glyphOrientationHorizontal", "glyph-orientation-horizontal", BrowserConfiguration.ie11up("0deg")),
        GLYPH_ORIENTATION_VERTICAL("glyphOrientationVertical", "glyph-orientation-vertical", BrowserConfiguration.ie11up("auto")),
        IMAGE_ORIENTATION("imageOrientation", "image-orientation", BrowserConfiguration.ff31up("0deg")),
        IMAGE_RENDERING("imageRendering", "image-rendering", BrowserConfiguration.ff("auto")),
        IME_MODE("imeMode", "ime-mode", BrowserConfiguration.ie11up("undefined")),
        JUSTIFY_CONTENT("justifyContent", "justify-content", BrowserConfiguration.ff24up("flex-start"), BrowserConfiguration.ie11up("flex-start")),
        KERNING("kerning", "kerning", BrowserConfiguration.ie11up("auto")),
        LAYOUT_FLOW("layoutFlow", "layout-flow", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID("layoutGrid", "layout-grid", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_CHAR("layoutGridChar", "layout-grid-char", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_LINE("layoutGridLine", "layout-grid-line", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_MODE("layoutGridMode", "layout-grid-mode", BrowserConfiguration.ie11up("undefined")),
        LAYOUT_GRID_TYPE("layoutGridType", "layout-grid-type", BrowserConfiguration.ie11up("undefined")),
        LIGHTING_COLOR("lightingColor", "lighting-color", BrowserConfiguration.ff("rgb(255, 255, 255)"), BrowserConfiguration.ie11up("")),
        LINE_BREAK("lineBreak", "line-break", BrowserConfiguration.ie11up("undefined")),
        LINE_HEIGHT("lineHeight", "line-height", BrowserConfiguration.ff("20px"), BrowserConfiguration.ieBelow11("20px"), BrowserConfiguration.ie11up("normal")),
        MARKER("marker", "marker", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("none")),
        MARKER_END("markerEnd", "marker-end", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        MARKER_MID("markerMid", "marker-mid", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        MARKER_START("markerStart", "marker-start", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        MASK("mask", "mask", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        ORDER("order", "order", BrowserConfiguration.ff24up("0"), BrowserConfiguration.ie11up("0")),
        ORPHANS("orphans", "orphans", BrowserConfiguration.ie11up("2")),
        OUTLINE_COLOR("outlineColor", "outline-color", BrowserConfiguration.ie11up("transparent")),
        PAGE_BREAK_INSIDE("pageBreakInside", "page-break-inside", BrowserConfiguration.ff24up("auto"), BrowserConfiguration.ie11up("auto")),
        PAUSE("pause", "pause", new BrowserConfiguration[0]),
        PAUSE_AFTER("pauseAfter", "pause-after", new BrowserConfiguration[0]),
        PAUSE_BEFORE("pauseBefore", "pause-before", new BrowserConfiguration[0]),
        PITCH("pitch", "pitch", new BrowserConfiguration[0]),
        PITCH_RANGE("pitchRange", "pitch-range", new BrowserConfiguration[0]),
        PAINT_ORDER("paintOrder", "paint-order", BrowserConfiguration.ff31up("normal")),
        PERSPECTIVE("perspective", "perspective", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        PERSPECTIVE_ORIGIN("perspectiveOrigin", "perspective-origin", BrowserConfiguration.ff("621px 172.5px"), BrowserConfiguration.ie11up("620px 163.2px")),
        POINTER_EVENTS("pointerEvents", "pointer-events", BrowserConfiguration.ie11up("visiblePainted")),
        QUOTES("quotes", "quotes", BrowserConfiguration.ff("\"\u201c\" \"\u201d\" \"\u2018\" \"\u2019\""), BrowserConfiguration.ie8up("")),
        RESIZE("resize", "resize", BrowserConfiguration.ff("none")),
        RICHNESS("richness", "richness", new BrowserConfiguration[0]),
        RUBY_ALIGN("rubyAlign", "ruby-align", new BrowserConfiguration[0]),
        RUBY_OVERHANG("rubyOverhang", "ruby-overhang", BrowserConfiguration.ie11up("auto")),
        RUBY_POSITION("rubyPosition", "ruby-position", BrowserConfiguration.ie11up("above")),
        SCROLLBAR_3DLIGHT_COLOR("scrollbar3dLightColor", "scrollbar-3dlight-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_ARROW_COLOR("scrollbarArrowColor", "scrollbar-arrow-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_BASE_COLOR("scrollbarBaseColor", "scrollbar-base-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_DARKSHADOW_COLOR("scrollbarDarkShadowColor", "scrollbar-darkshadow-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_FACE_COLOR("scrollbarFaceColor", "scrollbar-face-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_HIGHLIGHT_COLOR("scrollbarHighlightColor", "scrollbar-highlight-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_SHADOW_COLOR("scrollbarShadowColor", "scrollbar-shadow-color", BrowserConfiguration.ie11up("undefined")),
        SCROLLBAR_TRACK_COLOR("scrollbarTrackColor", "scrollbar-track-color", BrowserConfiguration.ie11up("undefined")),
        SHAPE_RENDERING("shapeRendering", "shape-rendering", BrowserConfiguration.ff("auto")),
        SPEAK("speak", "speak", new BrowserConfiguration[0]),
        SPEAK_HEADER("speakHeader", "speak-header", new BrowserConfiguration[0]),
        SPEAK_NUMERAL("speakNumeral", "speak-numeral", new BrowserConfiguration[0]),
        SPEAK_PUNCTUATION("speakPunctuation", "speak-punctuation", new BrowserConfiguration[0]),
        SPEECH_RATE("speechRate", "speech-rate", new BrowserConfiguration[0]),
        STOP_COLOR("stopColor", "stop-color", BrowserConfiguration.ff("rgb(0, 0, 0)"), BrowserConfiguration.ie11up("")),
        STOP_OPACITY("stopOpacity", "stop-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1")),
        STROKE("stroke", "stroke", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("")),
        STROKE_DASHARRAY("strokeDasharray", "stroke-dasharray", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        STROKE_DASHOFFSET("strokeDashoffset", "stroke-dashoffset", BrowserConfiguration.ff("0px"), BrowserConfiguration.ie11up("0px")),
        STROKE_LINECAP("strokeLinecap", "stroke-linecap", BrowserConfiguration.ff("butt"), BrowserConfiguration.ie11up("butt")),
        STROKE_LINEJOIN("strokeLinejoin", "stroke-linejoin", BrowserConfiguration.ff("miter"), BrowserConfiguration.ie11up("miter")),
        STROKE_MITERLIMIT("strokeMiterlimit", "stroke-miterlimit", BrowserConfiguration.ff("4"), BrowserConfiguration.ie11up("4")),
        STROKE_OPACITY("strokeOpacity", "stroke-opacity", BrowserConfiguration.ff("1"), BrowserConfiguration.ie11up("1")),
        STROKE_WIDTH("strokeWidth", "stroke-width", BrowserConfiguration.ff("1px"), BrowserConfiguration.ie11up("0.01px")),
        STRESS("stress", "stress", new BrowserConfiguration[0]),
        STYLE_FLOAT("styleFloat", "style-float", BrowserConfiguration.ie11up("undefined")),
        TEXT_ALIGN("textAlign", "text-align", BrowserConfiguration.ie11up("left")),
        TEXT_ALIGN_LAST("textAlignLast", "text-align-last", BrowserConfiguration.ie11up("auto")),
        TEXT_ANCHOR("textAnchor", "text-anchor", BrowserConfiguration.ff("start"), BrowserConfiguration.ie11up("start")),
        TEXT_AUTOSPACE("textAutospace", "text-autospace", BrowserConfiguration.ie11up("undefined")),
        TEXT_JUSTIFY("textJustify", "text-justify", BrowserConfiguration.ie11up("auto")),
        TEXT_JUSTIFY_TRIM("textJustifyTrim", "text-justify-trim", BrowserConfiguration.ie11up("undefined")),
        TEXT_KASHIDA("textKashida", "text-kashida", BrowserConfiguration.ie11up("undefined")),
        TEXT_TEXT_KASHIDA_SPACE("textKashidaSpace", "text-kashida-space", BrowserConfiguration.ie11up("undefined")),
        TEXT_OVERFLOW("textOverflow", "text-overflow", BrowserConfiguration.ff("clip"), BrowserConfiguration.ie11up("clip")),
        TEXT_RENDERING("textRendering", "text-rendering", BrowserConfiguration.ff("auto")),
        TEXT_UNDERLINE_POSITION("textUnderlinePosition", "text-underline-position", BrowserConfiguration.ie11up("auto")),
        TOUCH_ACTION("touchAction", "touch-action", BrowserConfiguration.ie11up("auto")),
        TRANSFORM("transform", "transform", BrowserConfiguration.ff("none"), BrowserConfiguration.ie11up("none")),
        TRANSFORM_ORIGIN("transformOrigin", "transform-origin", BrowserConfiguration.ff("621px 172.5px"), BrowserConfiguration.ie11up("620px 163.2px")),
        TRANSFORM_STYLE("transformStyle", "transform-style", BrowserConfiguration.ff("flat"), BrowserConfiguration.ie11up("flat")),
        TRANSITION("transition", "transition", BrowserConfiguration.ff(""), BrowserConfiguration.ie11up("")),
        TRANSITION_DELAY("transitionDelay", "transition-delay", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s")),
        TRANSITION_DURATION("transitionDuration", "transition-duration", BrowserConfiguration.ff("0s"), BrowserConfiguration.ie11up("0s")),
        TRANSITION_PROPERTY("transitionProperty", "transition-property", BrowserConfiguration.ff("all"), BrowserConfiguration.ie11up("all")),
        TRANSITION_TIMING_FUNCTION("transitionTimingFunction", "transition-timing-function", BrowserConfiguration.ff("cubic-bezier(0.25, 0.1, 0.25, 1)"), BrowserConfiguration.ie11up("cubic-bezier(0.25, 0.1, 0.25, 1)")),
        UNICODE_BIDI("unicodeBidi", "unicode-bidi", BrowserConfiguration.ff("-moz-isolate"), BrowserConfiguration.ieBelow11("embed"), BrowserConfiguration.ie11up("normal")),
        VECTOR_EFFECT("vectorEffect", "vector-effect", BrowserConfiguration.ff("none")),
        VOICE_FAMILY("voiceFamily", "voice-family", new BrowserConfiguration[0]),
        VOLUME("volume", "volume", new BrowserConfiguration[0]),
        WIDOWS("widows", "widows", BrowserConfiguration.ie11up("2")),
        WORD_BREAK("wordBreak", "word-break", BrowserConfiguration.ff("normal"), BrowserConfiguration.ieBelow11(""), BrowserConfiguration.ie11up("normal")),
        WORD_WRAP("wordWrap", "word-wrap", BrowserConfiguration.ie11up("")),
        WRITING_MODE("writingMode", "writing-mode", BrowserConfiguration.ie11up("undefined")),
        ZOOM("zoom", "zoom", BrowserConfiguration.ie11up("undefined"));

        private final String propertyName_;
        private final String attributeName_;
        private final BrowserConfiguration[] browserConfigurations_;

        private Definition(String propertyName, String styleAttributeName, BrowserConfiguration ... browserConfigurations) {
            this.attributeName_ = styleAttributeName;
            this.propertyName_ = propertyName;
            this.browserConfigurations_ = browserConfigurations;
            styles_.put(this.propertyName_, this);
        }

        private boolean isAvailable(BrowserVersion browserVersion) {
            return BrowserConfiguration.isDefined(browserVersion, this.browserConfigurations_);
        }

        public String getPropertyName() {
            return this.propertyName_;
        }

        public String getAttributeName() {
            return this.attributeName_;
        }

        public String getDefaultComputedValue(BrowserVersion browserVersion) {
            return BrowserConfiguration.getMatchingConfiguration(browserVersion, this.browserConfigurations_).getDefaultValue();
        }
    }
}

