/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserFeature;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BrowserVersion
implements Serializable,
Cloneable {
    private String applicationCodeName_ = "Mozilla";
    private String applicationMinorVersion_ = "0";
    private String applicationName_;
    private String applicationVersion_;
    private String buildId_;
    private String vendor_;
    private String browserLanguage_ = "en-us";
    private String cpuClass_ = "x86";
    private boolean onLine_ = true;
    private String platform_ = "Win32";
    private String systemLanguage_ = "en-us";
    private String userAgent_;
    private String userLanguage_ = "en-us";
    private float browserVersionNumeric_;
    private final Set<PluginConfiguration> plugins_ = new HashSet<PluginConfiguration>();
    private final Set<BrowserVersionFeatures> features_ = EnumSet.noneOf(BrowserVersionFeatures.class);
    private final String nickname_;
    private String htmlAcceptHeader_;
    private String imgAcceptHeader_;
    private String cssAcceptHeader_;
    private String scriptAcceptHeader_;
    private String xmlHttpRequestAcceptHeader_;
    private String[] headerNamesOrdered_;
    private static final String INTERNET_EXPLORER = "Microsoft Internet Explorer";
    private static final String NETSCAPE = "Netscape";
    private static final String LANGUAGE_ENGLISH_US = "en-us";
    private static final String CPU_CLASS_X86 = "x86";
    private static final String PLATFORM_WIN32 = "Win32";
    @Deprecated
    public static final BrowserVersion FIREFOX_24 = new BrowserVersion("Netscape", "5.0 (Windows)", "Mozilla/5.0 (Windows NT 6.1; rv:24.0) Gecko/20100101 Firefox/24.0", 24.0f, "FF24", null);
    @Deprecated
    public static final BrowserVersion FIREFOX_31 = new BrowserVersion("Netscape", "5.0 (Windows)", "Mozilla/5.0 (Windows NT 6.1; rv:31.0) Gecko/20100101 Firefox/31.0", 31.0f, "FF31", null);
    public static final BrowserVersion FIREFOX_38 = new BrowserVersion("Netscape", "5.0 (Windows)", "Mozilla/5.0 (Windows NT 6.1; rv:38.0) Gecko/20100101 Firefox/38.0", 38.0f, "FF38", null);
    public static final BrowserVersion INTERNET_EXPLORER_8 = new BrowserVersion("Microsoft Internet Explorer", "4.0 (compatible; MSIE 8.0; Windows NT 6.0)", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)", 8.0f, "IE8", null);
    public static final BrowserVersion INTERNET_EXPLORER_11 = new BrowserVersion("Netscape", "5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", "Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko", 11.0f, "IE11", null);
    public static final BrowserVersion CHROME = new BrowserVersion("Netscape", "5.0 (Windows NT 6.1) AppleWebKit/537.81 (KHTML, like Gecko) Chrome/43.0.2357.65 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.81 (KHTML, like Gecko) Chrome/43.0.2357.65 Safari/537.36", 43.0f, "Chrome", null);
    private static BrowserVersion DefaultBrowserVersion_ = INTERNET_EXPLORER_8;

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric) {
        this(applicationName, applicationVersion, userAgent, browserVersionNumeric, applicationName + browserVersionNumeric, null);
    }

    public BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric, BrowserVersionFeatures[] features) {
        this(applicationName, applicationVersion, userAgent, browserVersionNumeric, applicationName + browserVersionNumeric, features);
    }

    private BrowserVersion(String applicationName, String applicationVersion, String userAgent, float browserVersionNumeric, String nickname, BrowserVersionFeatures[] features) {
        this.applicationName_ = applicationName;
        this.setApplicationVersion(applicationVersion);
        this.userAgent_ = userAgent;
        this.browserVersionNumeric_ = browserVersionNumeric;
        this.nickname_ = nickname;
        this.htmlAcceptHeader_ = "*/*";
        this.imgAcceptHeader_ = "*/*";
        this.cssAcceptHeader_ = "*/*";
        this.scriptAcceptHeader_ = "*/*";
        this.xmlHttpRequestAcceptHeader_ = "*/*";
        if (features != null) {
            this.features_.addAll(Arrays.asList(features));
        }
    }

    private void initDefaultFeatures() {
        String expectedBrowserName = this.isIE() ? "IE" : (this.isFirefox() ? "FF" : "CHROME");
        for (BrowserVersionFeatures features : BrowserVersionFeatures.values()) {
            try {
                Field field = BrowserVersionFeatures.class.getField(features.name());
                BrowserFeature browserFeature = field.getAnnotation(BrowserFeature.class);
                if (browserFeature == null) continue;
                for (WebBrowser browser : browserFeature.value()) {
                    if (!expectedBrowserName.equals(browser.value().name()) || !(browser.minVersion() <= this.getBrowserVersionNumeric()) || !(browser.maxVersion() >= this.getBrowserVersionNumeric())) continue;
                    this.features_.add(features);
                }
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException();
            }
        }
    }

    public static BrowserVersion getDefault() {
        return DefaultBrowserVersion_;
    }

    public static void setDefault(BrowserVersion newBrowserVersion) {
        WebAssert.notNull("newBrowserVersion", newBrowserVersion);
        DefaultBrowserVersion_ = newBrowserVersion;
    }

    public final boolean isIE() {
        return this.getNickname().startsWith("IE");
    }

    public final boolean isChrome() {
        return this.getNickname().startsWith("Chrome");
    }

    public final boolean isFirefox() {
        return this.getNickname().startsWith("FF");
    }

    public String getApplicationCodeName() {
        return this.applicationCodeName_;
    }

    public String getApplicationMinorVersion() {
        return this.applicationMinorVersion_;
    }

    public String getApplicationName() {
        return this.applicationName_;
    }

    public String getApplicationVersion() {
        return this.applicationVersion_;
    }

    public String getVendor() {
        return this.vendor_;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage_;
    }

    public String getCpuClass() {
        return this.cpuClass_;
    }

    public boolean isOnLine() {
        return this.onLine_;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public String getSystemLanguage() {
        return this.systemLanguage_;
    }

    public String getUserAgent() {
        return this.userAgent_;
    }

    public String getUserLanguage() {
        return this.userLanguage_;
    }

    public String getHtmlAcceptHeader() {
        return this.htmlAcceptHeader_;
    }

    public String getScriptAcceptHeader() {
        return this.scriptAcceptHeader_;
    }

    public String getXmlHttpRequestAcceptHeader() {
        return this.xmlHttpRequestAcceptHeader_;
    }

    public String getImgAcceptHeader() {
        return this.imgAcceptHeader_;
    }

    public String getCssAcceptHeader() {
        return this.cssAcceptHeader_;
    }

    public void setApplicationCodeName(String applicationCodeName) {
        this.applicationCodeName_ = applicationCodeName;
    }

    public void setApplicationMinorVersion(String applicationMinorVersion) {
        this.applicationMinorVersion_ = applicationMinorVersion;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName_ = applicationName;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion_ = applicationVersion;
    }

    public void setVendor(String vendor) {
        this.vendor_ = vendor;
    }

    public void setBrowserLanguage(String browserLanguage) {
        this.browserLanguage_ = browserLanguage;
    }

    public void setCpuClass(String cpuClass) {
        this.cpuClass_ = cpuClass;
    }

    public void setOnLine(boolean onLine) {
        this.onLine_ = onLine;
    }

    public void setPlatform(String platform) {
        this.platform_ = platform;
    }

    public void setSystemLanguage(String systemLanguage) {
        this.systemLanguage_ = systemLanguage;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent_ = userAgent;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage_ = userLanguage;
    }

    public void setBrowserVersion(float browserVersion) {
        this.browserVersionNumeric_ = browserVersion;
    }

    public void setHtmlAcceptHeader(String htmlAcceptHeader) {
        this.htmlAcceptHeader_ = htmlAcceptHeader;
    }

    public void setImgAcceptHeader(String imgAcceptHeader) {
        this.imgAcceptHeader_ = imgAcceptHeader;
    }

    public void setCssAcceptHeader(String cssAcceptHeader) {
        this.cssAcceptHeader_ = cssAcceptHeader;
    }

    public void setScriptAcceptHeader(String scriptAcceptHeader) {
        this.scriptAcceptHeader_ = scriptAcceptHeader;
    }

    public void setXmlHttpRequestAcceptHeader(String xmlHttpRequestAcceptHeader) {
        this.xmlHttpRequestAcceptHeader_ = xmlHttpRequestAcceptHeader;
    }

    public float getBrowserVersionNumeric() {
        return this.browserVersionNumeric_;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public Set<PluginConfiguration> getPlugins() {
        return this.plugins_;
    }

    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.features_.contains((Object)property);
    }

    public String getNickname() {
        return this.nickname_;
    }

    public String getBuildId() {
        return this.buildId_;
    }

    public String[] getHeaderNamesOrdered() {
        return this.headerNamesOrdered_;
    }

    public void setHeaderNamesOrdered(String[] headerNames) {
        this.headerNamesOrdered_ = headerNames;
    }

    public String toString() {
        return this.nickname_;
    }

    public BrowserVersion clone() {
        BrowserVersion clone = new BrowserVersion(this.getApplicationName(), this.getApplicationVersion(), this.getUserAgent(), this.getBrowserVersionNumeric(), this.getNickname(), null);
        clone.setApplicationCodeName(this.getApplicationCodeName());
        clone.setApplicationMinorVersion(this.getApplicationMinorVersion());
        clone.setVendor(this.getVendor());
        clone.setBrowserLanguage(this.getBrowserLanguage());
        clone.setCpuClass(this.getCpuClass());
        clone.setOnLine(this.isOnLine());
        clone.setPlatform(this.getPlatform());
        clone.setSystemLanguage(this.getSystemLanguage());
        clone.setUserLanguage(this.getUserLanguage());
        clone.buildId_ = this.getBuildId();
        clone.htmlAcceptHeader_ = this.getHtmlAcceptHeader();
        clone.imgAcceptHeader_ = this.getImgAcceptHeader();
        clone.cssAcceptHeader_ = this.getCssAcceptHeader();
        clone.scriptAcceptHeader_ = this.getScriptAcceptHeader();
        clone.xmlHttpRequestAcceptHeader_ = this.getXmlHttpRequestAcceptHeader();
        clone.headerNamesOrdered_ = this.getHeaderNamesOrdered();
        for (PluginConfiguration pluginConf : this.getPlugins()) {
            clone.getPlugins().add(pluginConf.clone());
        }
        clone.features_.addAll(this.features_);
        return clone;
    }

    static {
        INTERNET_EXPLORER_8.initDefaultFeatures();
        INTERNET_EXPLORER_11.initDefaultFeatures();
        FIREFOX_24.initDefaultFeatures();
        FIREFOX_31.initDefaultFeatures();
        FIREFOX_38.initDefaultFeatures();
        FIREFOX_24.setBrowserLanguage("en-US");
        FIREFOX_24.setVendor("");
        BrowserVersion.FIREFOX_24.buildId_ = "20140923194127";
        FIREFOX_24.setHeaderNamesOrdered(new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Referer", "Cookie", "Connection"});
        FIREFOX_24.setHtmlAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        FIREFOX_24.setXmlHttpRequestAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        FIREFOX_24.setImgAcceptHeader("image/png,image/*;q=0.8,*/*;q=0.5");
        FIREFOX_24.setCssAcceptHeader("text/css,*/*;q=0.1");
        FIREFOX_31.setBrowserLanguage("en-US");
        FIREFOX_31.setVendor("");
        BrowserVersion.FIREFOX_31.buildId_ = "20150504194141";
        FIREFOX_31.setHeaderNamesOrdered(new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Referer", "Cookie", "Connection"});
        FIREFOX_31.setHtmlAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        FIREFOX_31.setXmlHttpRequestAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        FIREFOX_31.setImgAcceptHeader("image/png,image/*;q=0.8,*/*;q=0.5");
        FIREFOX_31.setCssAcceptHeader("text/css,*/*;q=0.1");
        FIREFOX_38.setBrowserLanguage("en-US");
        FIREFOX_38.setVendor("");
        BrowserVersion.FIREFOX_38.buildId_ = "20150505103531";
        FIREFOX_38.setHeaderNamesOrdered(new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Referer", "Cookie", "Connection"});
        FIREFOX_38.setHtmlAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        FIREFOX_38.setXmlHttpRequestAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        FIREFOX_38.setImgAcceptHeader("image/png,image/*;q=0.8,*/*;q=0.5");
        FIREFOX_38.setCssAcceptHeader("text/css,*/*;q=0.1");
        INTERNET_EXPLORER_8.setHtmlAcceptHeader("image/gif, image/jpeg, image/pjpeg, image/pjpeg, */*");
        INTERNET_EXPLORER_11.setBrowserLanguage("en-US");
        INTERNET_EXPLORER_11.setVendor("");
        INTERNET_EXPLORER_11.setHeaderNamesOrdered(new String[]{"Accept", "Referer", "Accept-Language", "User-Agent", "Accept-Encoding", "Host", "DNT", "Connection", "Cookie"});
        INTERNET_EXPLORER_11.setHtmlAcceptHeader("text/html, application/xhtml+xml, */*");
        INTERNET_EXPLORER_11.setImgAcceptHeader("image/png, image/svg+xml, image/*;q=0.8, */*;q=0.5");
        INTERNET_EXPLORER_11.setCssAcceptHeader("text/css, */*");
        INTERNET_EXPLORER_11.setScriptAcceptHeader("application/javascript, */*;q=0.8");
        PluginConfiguration flash = new PluginConfiguration("Shockwave Flash", "Shockwave Flash 9.0 r31", "libflashplayer.so");
        flash.getMimeTypes().add(new PluginConfiguration.MimeType("application/x-shockwave-flash", "Shockwave Flash", "swf"));
        FIREFOX_24.getPlugins().add(flash);
        FIREFOX_31.getPlugins().add(flash);
        FIREFOX_38.getPlugins().add(flash);
        CHROME.initDefaultFeatures();
        CHROME.setApplicationCodeName("Mozilla");
        CHROME.setVendor("Google Inc.");
        CHROME.setPlatform("MacIntel");
        CHROME.setCpuClass(null);
        CHROME.setBrowserLanguage("en-US");
        CHROME.setHeaderNamesOrdered(new String[]{"Host", "Connection", "Accept", "User-Agent", "Referer", "Accept-Encoding", "Accept-Language", "Cookie"});
        CHROME.setHtmlAcceptHeader("text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        CHROME.setImgAcceptHeader("image/webp,*/*;q=0.8");
        CHROME.setCssAcceptHeader("text/css,*/*;q=0.1");
        CHROME.setScriptAcceptHeader("*/*");
    }
}

