/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.MimeType;
import com.gargoylesoftware.htmlunit.javascript.host.MimeTypeArray;
import com.gargoylesoftware.htmlunit.javascript.host.Plugin;
import com.gargoylesoftware.htmlunit.javascript.host.PluginArray;
import com.gargoylesoftware.htmlunit.javascript.host.geo.Geolocation;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class Navigator
extends SimpleScriptable {
    private PluginArray plugins_;
    private MimeTypeArray mimeTypes_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=31.0f)})
    public Navigator() {
    }

    @JsxGetter
    public String getAppCodeName() {
        return this.getBrowserVersion().getApplicationCodeName();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getAppMinorVersion() {
        return this.getBrowserVersion().getApplicationMinorVersion();
    }

    @JsxGetter
    public String getAppName() {
        return this.getBrowserVersion().getApplicationName();
    }

    @JsxGetter
    public String getAppVersion() {
        return this.getBrowserVersion().getApplicationVersion();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBrowserLanguage() {
        return this.getBrowserVersion().getBrowserLanguage();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getLanguage() {
        return this.getBrowserVersion().getBrowserLanguage();
    }

    @JsxGetter
    public boolean getCookieEnabled() {
        return this.getWindow().getWebWindow().getWebClient().getCookieManager().isCookiesEnabled();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getCpuClass() {
        return this.getBrowserVersion().getCpuClass();
    }

    @JsxGetter
    public boolean getOnLine() {
        return this.getBrowserVersion().isOnLine();
    }

    @JsxGetter
    public String getPlatform() {
        return this.getBrowserVersion().getPlatform();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getProduct() {
        return "Gecko";
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public String getProductSub() {
        return "20100215";
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getSystemLanguage() {
        return this.getBrowserVersion().getSystemLanguage();
    }

    @JsxGetter
    public String getUserAgent() {
        return this.getBrowserVersion().getUserAgent();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getUserLanguage() {
        return this.getBrowserVersion().getUserLanguage();
    }

    @JsxGetter
    public Object getPlugins() {
        this.initPlugins();
        return this.plugins_;
    }

    private void initPlugins() {
        if (this.plugins_ != null) {
            return;
        }
        this.plugins_ = new PluginArray();
        this.plugins_.setParentScope((Scriptable)this);
        this.plugins_.setPrototype(this.getPrototype(PluginArray.class));
        this.mimeTypes_ = new MimeTypeArray();
        this.mimeTypes_.setParentScope((Scriptable)this);
        this.mimeTypes_.setPrototype(this.getPrototype(MimeTypeArray.class));
        for (PluginConfiguration pluginConfig : this.getBrowserVersion().getPlugins()) {
            Plugin plugin = new Plugin(pluginConfig.getName(), pluginConfig.getDescription(), pluginConfig.getFilename());
            plugin.setParentScope((Scriptable)this);
            plugin.setPrototype(this.getPrototype(Plugin.class));
            this.plugins_.add(plugin);
            for (PluginConfiguration.MimeType mimeTypeConfig : pluginConfig.getMimeTypes()) {
                MimeType mimeType = new MimeType(mimeTypeConfig.getType(), mimeTypeConfig.getDescription(), mimeTypeConfig.getSuffixes(), plugin);
                mimeType.setParentScope((Scriptable)this);
                mimeType.setPrototype(this.getPrototype(MimeType.class));
                this.mimeTypes_.add(mimeType);
                plugin.add(mimeType);
            }
        }
    }

    @JsxGetter
    public Object getMimeTypes() {
        this.initPlugins();
        return this.mimeTypes_;
    }

    @JsxFunction
    public boolean javaEnabled() {
        return this.getWindow().getWebWindow().getWebClient().getOptions().isAppletEnabled();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public boolean taintEnabled() {
        return false;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Geolocation getGeolocation() {
        Geolocation geolocation = new Geolocation();
        geolocation.setPrototype(this.getPrototype(geolocation.getClass()));
        geolocation.setParentScope(this.getParentScope());
        return geolocation;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getBuildID() {
        return this.getBrowserVersion().getBuildId();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getVendor() {
        return this.getBrowserVersion().getVendor();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public String getVendorSub() {
        return "";
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getDoNotTrack() {
        if (this.getWindow().getWebWindow().getWebClient().getOptions().isDoNotTrackEnabled()) {
            return "yes";
        }
        return "unspecified";
    }

    public String getMsDoNotTrack() {
        if (this.getWindow().getWebWindow().getWebClient().getOptions().isDoNotTrackEnabled()) {
            return "1";
        }
        return "0";
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getOscpu() {
        return "Windows NT 6.1";
    }
}

