/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.FunctionWrapper;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

class NativeFunctionToStringFunction
extends FunctionWrapper {
    static void installFix(Scriptable window, BrowserVersion browserVersion) {
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NEW_LINE)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, (String)"toString");
            NativeFunctionToStringFunction newToString = new NativeFunctionToStringFunction(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, (String)"toString", (Object)newToString);
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_COMPACT)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, (String)"toString");
            NativeFunctionToStringFunctionChrome newToString = new NativeFunctionToStringFunctionChrome(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, (String)"toString", (Object)newToString);
        }
    }

    NativeFunctionToStringFunction(Function wrapped) {
        super(wrapped);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String s = (String)super.call(cx, scope, thisObj, args);
        if (thisObj instanceof BaseFunction && s.indexOf("[native code]") > -1) {
            String functionName = ((BaseFunction)thisObj).getFunctionName();
            if (thisObj instanceof IdFunctionObject && functionName.length() > 5 && functionName.endsWith("Error") && ((Window)scope).getWebWindow().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ERROR)) {
                return functionName;
            }
            return "\nfunction " + functionName + "() {\n    [native code]\n}\n";
        }
        return s;
    }

    static class NativeFunctionToStringFunctionChrome
    extends FunctionWrapper {
        NativeFunctionToStringFunctionChrome(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String s = (String)super.call(cx, scope, thisObj, args);
            if (thisObj instanceof BaseFunction && s.indexOf("[native code]") > -1) {
                String functionName = ((BaseFunction)thisObj).getFunctionName();
                return "function " + functionName + "() { [native code] }";
            }
            return s;
        }
    }
}

