/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptableProxy;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLUnknownElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Stack;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleScriptable
extends ScriptableObject
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(SimpleScriptable.class);
    private DomNode domNode_;
    private boolean caseSensitive_ = true;
    private String className_;

    public Object get(String name, Scriptable start) {
        Object response;
        if (!this.caseSensitive_) {
            for (Object o : this.getAllIds()) {
                String objectName = Context.toString((Object)o);
                if (!name.equalsIgnoreCase(objectName)) continue;
                name = objectName;
                break;
            }
        }
        if ((response = super.get(name, start)) != NOT_FOUND) {
            return response;
        }
        if (this == start) {
            return this.getWithPreemption(name);
        }
        return NOT_FOUND;
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    public String getClassName() {
        if (this.className_ != null) {
            return this.className_;
        }
        if (this.getPrototype() != null) {
            return this.getPrototype().getClassName();
        }
        String className = this.getClass().getSimpleName();
        if (className.isEmpty()) {
            className = this.getClass().getSuperclass().getSimpleName();
        }
        return className;
    }

    public void setClassName(String className) {
        this.className_ = className;
    }

    public DomNode getDomNodeOrDie() throws IllegalStateException {
        if (this.domNode_ == null) {
            String clazz = this.getClass().getName();
            throw new IllegalStateException("DomNode has not been set for this SimpleScriptable: " + clazz);
        }
        return this.domNode_;
    }

    public DomNode getDomNodeOrNull() {
        return this.domNode_;
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        WebAssert.notNull("domNode", domNode);
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptObject(this);
        }
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        this.setDomNode(htmlElement);
    }

    protected SimpleScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (SimpleScriptable)((WebWindow)object).getScriptObject();
        }
        DomNode domNode = (DomNode)object;
        ScriptableObject scriptObject = domNode.getScriptObject();
        if (scriptObject != null) {
            return (SimpleScriptable)scriptObject;
        }
        return this.makeScriptableFor(domNode);
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        Class javaScriptClass = null;
        if (domNode instanceof HtmlImage && "image".equals(((HtmlImage)domNode).getOriginalQualifiedName()) && ((HtmlImage)domNode).wasCreatedByJavascript()) {
            if (domNode.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT)) {
                javaScriptClass = HTMLElement.class;
            } else if (domNode.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT)) {
                javaScriptClass = HTMLUnknownElement.class;
            }
        }
        if (javaScriptClass == null) {
            for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
                javaScriptClass = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptClass(c);
            }
        }
        if (javaScriptClass == null) {
            scriptable = new HTMLElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No JavaScript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement"));
            }
        } else {
            try {
                scriptable = (SimpleScriptable)javaScriptClass.newInstance();
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        WebWindow enclosingWindow = domNode.getPage().getEnclosingWindow();
        if (enclosingWindow.getEnclosedPage() == domNode.getPage()) {
            scriptable.setParentScope((Scriptable)enclosingWindow.getScriptObject());
        } else {
            scriptable.setParentScope(ScriptableObject.getTopLevelScope((Scriptable)domNode.getPage().getScriptObject()));
        }
    }

    protected Scriptable getPrototype(Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = this.getWindow().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    protected Transformer getTransformerScriptableFor() {
        return new Transformer(){

            public Object transform(Object obj) {
                return SimpleScriptable.this.getScriptableFor(obj);
            }
        };
    }

    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            Page page;
            if ((this.getDomNodeOrNull() != null || this.getParentScope() != null) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OBJECT_IN_QUIRKS_MODE) && (page = this.getWindow().getWebWindow().getEnclosedPage()) != null && page.isHtmlPage() && ((HtmlPage)page).isQuirksMode()) {
                return "[object]";
            }
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    public Window getWindow() throws RuntimeException {
        return SimpleScriptable.getWindow((Scriptable)this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope((Scriptable)s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected Scriptable getStartingScope() {
        Stack stack = (Stack)Context.getCurrentContext().getThreadLocal((Object)"startingScope");
        if (null == stack) {
            return null;
        }
        return (Scriptable)stack.peek();
    }

    public void defineProperty(String propertyName, Class<?> clazz, int attributes) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = clazz.getMethods();
        Method getter = SimpleScriptable.findMethod(methods, getterName);
        Method setter = SimpleScriptable.findMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter, attributes);
    }

    public void defineFunctionProperties(String[] names, Class<?> clazz, int attributes) {
        Method[] methods = clazz.getMethods();
        for (String name : names) {
            Method method = SimpleScriptable.findMethod(methods, name);
            if (method == null) {
                throw Context.reportRuntimeError((String)("Method \"" + name + "\" not found in \"" + clazz.getName() + '\"'));
            }
            FunctionObject f = new FunctionObject(name, (Member)method, (Scriptable)this);
            this.defineProperty(name, f, attributes);
        }
    }

    private static Method findMethod(Method[] methods, String name) {
        for (Method m : methods) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public BrowserVersion getBrowserVersion() {
        DomNode node = this.getDomNodeOrNull();
        if (node != null) {
            return node.getPage().getWebClient().getBrowserVersion();
        }
        return this.getWindow().getWebWindow().getWebClient().getBrowserVersion();
    }

    public boolean hasInstance(Scriptable instance) {
        if (this.getPrototype() == null) {
            Object prototype = this.get("prototype", (Scriptable)this);
            if (!(prototype instanceof ScriptableObject)) {
                Context.throwAsScriptRuntimeEx((Throwable)new Exception("Null prototype"));
            }
            return ((ScriptableObject)prototype).hasInstance(instance);
        }
        return super.hasInstance(instance);
    }

    protected Object equivalentValues(Object value) {
        if (value instanceof SimpleScriptableProxy) {
            value = ((SimpleScriptableProxy)value).getDelegee();
        }
        return super.equivalentValues(value);
    }

    public SimpleScriptable clone() {
        try {
            return (SimpleScriptable)super.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException("Clone not supported");
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_ = caseSensitive;
        Scriptable prototype = this.getPrototype();
        if (prototype instanceof SimpleScriptable) {
            ((SimpleScriptable)prototype).setCaseSensitive(caseSensitive);
        }
    }

    protected boolean isReadOnlySettable(String name, Object value) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.SET_READONLY_PROPERTIES)) {
            throw ScriptRuntime.typeError3((String)"msg.set.prop.no.setter", (String)name, (String)this.getClassName(), (String)Context.toString((Object)value));
        }
        for (Method m : this.getClass().getMethods()) {
            CanSetReadOnly canSetReadOnly;
            String methodProperty;
            JsxGetter jsxGetter = m.getAnnotation(JsxGetter.class);
            if (jsxGetter == null) continue;
            if (jsxGetter.propertyName().isEmpty()) {
                int prefix = m.getName().startsWith("is") ? 2 : 3;
                methodProperty = m.getName().substring(prefix);
                methodProperty = Character.toLowerCase(methodProperty.charAt(0)) + methodProperty.substring(1);
            } else {
                methodProperty = jsxGetter.propertyName();
            }
            if (!methodProperty.equals(name) || (canSetReadOnly = m.getAnnotation(CanSetReadOnly.class)) == null) continue;
            switch (canSetReadOnly.value()) {
                case YES: {
                    return true;
                }
                case IGNORE: {
                    return false;
                }
                case EXCEPTION: {
                    throw ScriptRuntime.typeError3((String)"msg.set.prop.no.setter", (String)name, (String)this.getClassName(), (String)Context.toString((Object)value));
                }
            }
        }
        return true;
    }

    public void setParentScope(Scriptable m) {
        if (m == this) {
            throw new IllegalArgumentException("Object can't be its own parentScope");
        }
        super.setParentScope(m);
    }
}

