/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class StyleSheetList
extends SimpleScriptable {
    private HTMLCollection nodes_;

    public static boolean isStyleSheetLink(DomNode domNode) {
        return domNode instanceof HtmlLink && "stylesheet".equalsIgnoreCase(((HtmlLink)domNode).getRelAttribute());
    }

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=31.0f)})
    public StyleSheetList() {
    }

    public StyleSheetList(HTMLDocument document) {
        this.setParentScope(document);
        this.setPrototype(this.getPrototype(this.getClass()));
        boolean cssEnabled = this.getWindow().getWebWindow().getWebClient().getOptions().isCssEnabled();
        this.nodes_ = cssEnabled ? new HTMLCollection(document.getDomNodeOrDie(), true, "stylesheets"){

            @Override
            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlStyle || StyleSheetList.isStyleSheetLink(node);
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                HtmlElement node = event.getHtmlElement();
                if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        } : HTMLCollection.emptyCollection(this.getWindow());
    }

    @JsxGetter
    public int getLength() {
        return this.nodes_.getLength();
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            if (this.getWindow().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLESHEETLIST_EXCEPTION_FOR_NEGATIVE_INDEX)) {
                throw Context.reportRuntimeError((String)("Invalid negative index: " + index));
            }
            return Context.getUndefinedValue();
        }
        if (index >= this.nodes_.getLength()) {
            if (this.getWindow().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLESHEETLIST_EXCEPTION_FOR_TOO_HIGH_INDEX)) {
                throw Context.reportRuntimeError((String)("Invalid index: " + index));
            }
            return Context.getUndefinedValue();
        }
        HTMLElement element = (HTMLElement)this.nodes_.item(index);
        CSSStyleSheet sheet = element instanceof HTMLStyleElement ? ((HTMLStyleElement)element).getSheet() : ((HTMLLinkElement)element).getSheet();
        return sheet;
    }

    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.item(index);
        }
        return super.get(index, start);
    }
}

