/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.httpclient;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitBrowserCompatCookieHeaderValueFormatter;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitDomainHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitExpiresHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitHttpOnlyHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitPathHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitVersionAttributeHandler;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;

public class HtmlUnitBrowserCompatCookieSpec
extends CookieSpecBase {
    public static final String EMPTY_COOKIE_NAME = "HTMLUNIT_EMPTY_COOKIE";
    public static final String LOCAL_FILESYSTEM_DOMAIN = "LOCAL_FILESYSTEM";
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new CookiePathComparator();
    static final Date DATE_1_1_1970;

    public HtmlUnitBrowserCompatCookieSpec(BrowserVersion browserVersion) {
        super(new CommonCookieAttributeHandler[]{new HtmlUnitVersionAttributeHandler(), new HtmlUnitDomainHandler(), new HtmlUnitPathHandler(browserVersion), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new HtmlUnitExpiresHandler(browserVersion), new HtmlUnitHttpOnlyHandler()});
    }

    /*
     * WARNING - void declaration
     */
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        List<BasicClientCookie> cookies;
        int pos;
        String text = header.getValue();
        int endPos = text.indexOf(59);
        endPos = endPos < 0 ? text.indexOf(61) : ((pos = text.indexOf(61)) > endPos ? -1 : pos);
        if (endPos < 0) {
            header = new BasicHeader(header.getName(), "HTMLUNIT_EMPTY_COOKIE=" + header.getValue());
        } else if (endPos == 0 || StringUtils.isBlank((CharSequence)text.substring(0, endPos))) {
            header = new BasicHeader(header.getName(), EMPTY_COOKIE_NAME + header.getValue());
        }
        String headername = header.getName();
        if (!headername.equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement helem : helems) {
            if (helem.getParameterByName("version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            void var11_15;
            ParserCursor cursor;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                CharArrayBuffer charArrayBuffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), charArrayBuffer.length());
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                CharArrayBuffer charArrayBuffer = new CharArrayBuffer(s.length());
                charArrayBuffer.append(s);
                cursor = new ParserCursor(0, charArrayBuffer.length());
            }
            HeaderElement elem = parser.parseHeader((CharArrayBuffer)var11_15, cursor);
            String name = elem.getName();
            String value = elem.getValue();
            if (name == null || name.isEmpty()) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie cookie = new BasicClientCookie(name, value);
            cookie.setPath(HtmlUnitBrowserCompatCookieSpec.getDefaultPath((CookieOrigin)origin));
            cookie.setDomain(HtmlUnitBrowserCompatCookieSpec.getDefaultDomain((CookieOrigin)origin));
            NameValuePair[] attribs = elem.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase(Locale.ROOT);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse((SetCookie)cookie, attrib.getValue());
            }
            if (netscape) {
                cookie.setVersion(0);
            }
            cookies = Collections.singletonList(cookie);
        } else {
            cookies = this.parse(helems, origin);
        }
        for (Cookie cookie : cookies) {
            if (!header.getValue().contains(cookie.getName() + "=\"" + cookie.getValue())) continue;
            ((BasicClientCookie)cookie).setValue('\"' + cookie.getValue() + '\"');
        }
        return cookies;
    }

    public List<Header> formatCookies(List<Cookie> cookies) {
        Collections.sort(cookies, COOKIE_COMPARATOR);
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("; ");
            }
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (cookie.getVersion() > 0 && !HtmlUnitBrowserCompatCookieSpec.isQuoteEnclosed(cookieValue)) {
                HtmlUnitBrowserCompatCookieHeaderValueFormatter.INSTANCE.formatHeaderElement(buffer, (HeaderElement)new BasicHeaderElement(cookieName, cookieValue), false);
                continue;
            }
            buffer.append(cookieName);
            buffer.append("=");
            if (cookieValue == null) continue;
            buffer.append(cookieValue);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add((Header)new BufferedHeader(buffer));
        return headers;
    }

    private static boolean isQuoteEnclosed(String s) {
        return s != null && '\"' == s.charAt(0) && '\"' == s.charAt(s.length() - 1);
    }

    public int getVersion() {
        return 0;
    }

    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "compatibility";
    }

    static {
        Calendar calendar = Calendar.getInstance(Locale.ROOT);
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(1970, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DATE_1_1_1970 = calendar.getTime();
    }
}

