/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBufferViewBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass(browsers={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)})
public class Uint32Array
extends ArrayBufferViewBase {
    @JsxConstant
    public static final int BYTES_PER_ELEMENT = 4;

    @Override
    @JsxConstructor
    public void constructor(Object object, Object byteOffset, Object length) {
        super.constructor(object, byteOffset, length);
    }

    @Override
    protected byte[] toArray(Number number) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.putInt(number.intValue());
        return buff.array();
    }

    @Override
    protected Object fromArray(byte[] array, int offset) {
        if (offset >= array.length) {
            return Scriptable.NOT_FOUND;
        }
        ByteBuffer buff = ByteBuffer.wrap(array);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        return (long)buff.getInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    protected int getBytesPerElement() {
        return 4;
    }
}

